/****************************************************************************/
/* TMENUBAR                                                                 */
/*--------------------------------------------------------------------------*/
/* Objet TMenuBar (barre de menus)                                          */
/****************************************************************************/

#ifndef _TMENUBAR_H_
#define _TMENUBAR_H_

#include "Types.h"

#include "Keyboard.h"

#include "TObject.h"

// Liste chane de menus

typedef struct menu_node
{
  PMenu                    menu;
  struct menu_node        *next;
} TMenuNode,*PMenuNode;


class TMenuBar:public TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend class TMenu;
  friend class TWindow;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // Menus de l'objet

    int     f_nb_menus;
    PMenuNode
            f_menu_list,
            f_last_menu;

    // La barre de menu est en cours d'utilisation

    bool f_active;

    // Menu actif

    PMenu   f_active_menu;

    // Le curseur tait visible lors de l'ouverture du menu

    bool f_cursor_was_visible;

    // Message d'info de la fenetre avant d'ouvrir le menu */

    char    *f_window_info_message;

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TMenuBar(PWindow window);
    virtual 	   ~TMenuBar();

    // Mthodes d'accs

    virtual void    m_enable();
    virtual void    m_disable();

    // Donne le focus  la barre de menu

    virtual bool m_set_focus()                  { return false; };
    virtual bool m_set_focus_to_last_element()  { return false; };


  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    // Ajout d'un menu

    virtual int     m_add_menu(PMenu menu);

    // Affichage

    virtual void    m_display();

    // Ouverture/Fermeture de l'objet

    virtual void    m_set_open(bool open);

    // Evnements

    virtual bool m_left_button_pressed_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);
    virtual bool m_short_cut_pressed_event(int shortcut);


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

            void    m_display_menu_caption(int menu_nb);

    // Ouverture/Fermeture d'un menu

            bool m_open_menu(int menu_nb,bool select_first_possible);
            void    m_close_menu();

    // Donne le dbut et la largeur d'un des titres des onglets

            int     m_get_menu_caption_pos1(int menu_nb);
            void    m_get_menu_caption_pos(int menu_nb,int &rel_x1,int &rel_x2);

            void    m_activate_menu_bar();
            void    m_inactivate_menu_bar();

            PMenu   m_menu_number_to_menu(int menu_number);
            PMenuNode
                    m_menu_number_to_menu_node(int menu_number);

};

#endif
