/****************************************************************************/
/* TLIST                                                                    */
/*--------------------------------------------------------------------------*/
/* Objet TList (objet gnrique pour les objets reposant sur une liste de   */
/*              chanes)                                                    */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 03/02/95                                                    */
/****************************************************************************/

#include <conio.h>
#include <dos.h>
#include <stdlib.h>
#include <values.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"

#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"


#include "TList.h"
#include "TScrBar.h"
#include "TWindow.h"

#define  MAX_ITEM_INDEX  (MAXINT-1)

/*ͻ*/
/*                   PROPRIETES DES ELEMENTS DE LA LISTE                  */
/*ͼ*/

TListItemProperties::TListItemProperties()
{
}

TListItemProperties::~TListItemProperties()
{
}

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* parent           : Objet auquel appartient l'objet                       */
/* rel_x,rel_y      : Coordonnes de l'objet p/r au groupe                  */
/* width,height     : Dimensions de l'objet                                 */
/* caption          : Lgende de l'objet (hot-key prcd de ~)             */
/* list_rel_x,                                                              */
/* list_rel_y       : Position de la liste par rapport  l'objet            */
/* list_width,                                                              */
/* list_height      : Dimensions de la liste (le texte, sans les bordures)  */
/* enabled          : ENABLED si l'objet est activable (DISABLED sinon)     */
/* focus_depending..: L'aspect de l'objet dpend du focus ou non            */
/****************************************************************************/

TList::TList(PObject parent,
	     int type,
	     int rel_x,int rel_y,
	     int width,int height,
	     unsigned background,
	     const char *caption,
	     int list_rel_x,int list_rel_y,
	     int  list_width,
	     int  list_height,
	     bool sorted,
	     int     allowed_item_attribute,
	     bool always_one_item_selected,
	     bool item_hot_key_enabled,
	     bool scrollbar,
	     int     scrollbar_x,
	     int     scrollbar_y,
	     int     scrollbar_height,
	     bool enabled)
      :TObject(parent,
	       type,
	       rel_x,rel_y,
	       width,height,
	       background,
	       caption,
	       enabled,
	       true,  // FOCUS_DEPENDING_ASPECT
	       true,  // CAN_BE_ENABLED
	       !scrollbar),  // SIMPLE/NOT_SIMPLE
		selectedItemChangedAction_(this),
		visiblePartChangedAction_(this),
		nbItemsChangedAction_(this),
		itemCheckChangedAction_(this),
		itemDblClickAction_(this)
{
  // Liste double-chane des chanes et son nombre d'lments

  f_item_list=NULL;
  f_nb_items=0;

  // Les lments de la liste sont tris par ordre alphabtique ou non

  f_sorted=sorted;

  // Attributs autoriss pour les lments de la liste

  f_allowed_item_attribute=allowed_item_attribute;

  // Si possible, un lment est toujours slectionn

  f_always_one_item_selected=always_one_item_selected;

  // Les hot-keys des lments de la liste sont actives

  f_item_hot_key_enabled=item_hot_key_enabled;

  // Elments spciaux de la liste

  f_first_visible_item=NULL;
  f_first_visible_item_index=0;

  f_last_item=NULL;

  f_selected_item_index=0;

  f_current_item=NULL;
  f_current_item_index=0;

  // Position et hauteur de la liste (sans les bordures)

  f_list_rel_x=list_rel_x;
  f_list_rel_y=list_rel_y;
  f_list_height=0; // Fixs par m_set_list_size (ci-dessous)
  f_list_width=0;

  // Ligne vide (affiche en cas d'absence d'lments)

  f_empty_line=NULL;

  // Chane sparatrice

  f_separator_line=NULL;

  // Elment retourn par m_get_item

  f_return_item=NULL;

  // Ascenseur

  f_scrollbar=NULL;

  // On fixe la bonne taille de la liste

  m_set_list_size(list_width,list_height);

  // Cration de l'ascenseur

  if (scrollbar)
    {
      f_scrollbar=new TScrollBar(this,
				 SB_VERTICAL,
				 scrollbar_x,
				 scrollbar_y,
				 scrollbar_height,
				 DISABLED);

      f_scrollbar->m_set_can_be_enabled(false);
      f_scrollbar->m_set_min_max_values(1L,f_scrollbar->m_get_max_value());
      f_scrollbar->m_set_little_change(1L);
      f_scrollbar->m_set_big_change((long)(f_list_height));

		f_scrollbar->valueChangedAction_.set(*this);
    }
}


/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TList::~TList()
{
  // Libration des variables dynamiques

  if (f_scrollbar!=NULL)
    {
      delete f_scrollbar;
      f_scrollbar=NULL;
    }

  if (f_return_item!=NULL)
    {
      delete []f_return_item;
      f_return_item=NULL;
    }

  delete []f_separator_line;
  f_separator_line=NULL;

  delete []f_empty_line;
  f_empty_line=NULL;

  // Libration de la liste
  // (bien dsactiver les callbacks avant)

  m_clear_list();
}


/****************************************************************************/
/* m_get_item                                                               */
/*--------------------------------------------------------------------------*/
/* Retourne un lment de la liste (le texte uniquement)                    */
/****************************************************************************/

char *TList::m_get_item(int  index)
{
  char *label;

  if ((index<1) || (index>f_nb_items))
    label="";
  else
    label=m_index_to_item(index)->label;

  if (!strcmp(SEPARATOR,label))
    label=f_separator_line;

  if (f_return_item!=NULL)
    delete []f_return_item;

  f_return_item=new char[strlen(label)+1];
  strcpy(f_return_item,label);

  return(f_return_item);
}

/****************************************************************************/
/* m_get_item_index                                                         */
/*--------------------------------------------------------------------------*/
/* Retourne l'index dans la liste de l'lment de label indiqu (ou 0 si    */
/* n'existe pas). Prend la 1re ocurrence de l'lment si plusieurs.        */
/****************************************************************************/

int TList::m_get_item_index(const char *label)
{
  register PItemNode node=f_item_list;
  register int i=1;

  while (node!=NULL)
    {
      if (!strcmp(node->label,label))
	{
	  f_current_item_index=i;
	  f_current_item=node;
	  return(i);
	}
      node=node->next;
      i++;
    }

  return(0);
}

/****************************************************************************/
/* m_set_selected_item_index                                                */
/*--------------------------------------------------------------------------*/
/* Modifie l'lment de la liste slectionn                                */
/****************************************************************************/

bool TList::m_set_selected_item_index(int  index)
{
  PItemNode item;
  int         old_selected_index;

  if (index==f_selected_item_index)
    return true;

  if ((index<0) || (index>f_nb_items))
    return false;

  if ((index==0) && (f_always_one_item_selected) && (f_nb_items!=0))
    return false;

  old_selected_index=f_selected_item_index;

  if (index!=0)
    {
      item=m_index_to_item(index);

      // Si l'lment choisi est un sparateur, chec

      if (!strcmp(item->label,SEPARATOR))
	return false;
    }

  f_selected_item_index=index;
  if (index!=0)
    m_display_item(index);

  if (old_selected_index!=0)
    m_display_item(old_selected_index);

  m_selected_item_changed_callback();

  return true;
}

/****************************************************************************/
/* m_select_first_possible_item                                             */
/*--------------------------------------------------------------------------*/
/* Slectionne le premier item possible                                     */
/****************************************************************************/

void TList::m_select_first_possible_item()
{
  register int i;

  if (f_nb_items==0)
    return;
  i=1;
  while ((!m_set_selected_item_index(i)) && (i<f_nb_items))
    i++;
}

/****************************************************************************/
/* m_set_first_visible_item_index                                           */
/*--------------------------------------------------------------------------*/
/* Modifie le premier lment visible de la liste.                          */
/* Si l'index fourni est invalide, choisit l'lment adapt le plus proche. */
/****************************************************************************/

void TList::m_set_first_visible_item_index(int  index)
{
  if (f_nb_items==0)
    return;

  if (index+f_list_height-1>f_nb_items)
    index=f_nb_items+1-f_list_height;
  if (index<1)
    index=1;

  if (f_first_visible_item_index!=index)
    {
      f_first_visible_item=m_index_to_item(index);
      f_first_visible_item_index=index;
      m_display_list();
      m_visible_part_changed_callback();
    }
}

/****************************************************************************/
/* m_set_middle_visible_item_index                                          */
/*--------------------------------------------------------------------------*/
/* Modifie l'lment de la liste visible au milieu de la partie apparente.  */
/****************************************************************************/

void TList::m_set_middle_visible_item_index(int  index)
{
  m_set_first_visible_item_index(index-(f_list_height>>1));
}

/****************************************************************************/
/* m_set_last_visible_item_index                                            */
/*--------------------------------------------------------------------------*/
/* Modifie le dernier lment visible de la liste                           */
/****************************************************************************/

void TList::m_set_last_visible_item_index(int  index)
{
  m_set_first_visible_item_index(index-(f_list_height-1));
}

/****************************************************************************/
/* m_get_last_visible_item_index                                            */
/*--------------------------------------------------------------------------*/
/* Retourne l'index du dernier lment visible de la liste                  */
/****************************************************************************/

int TList::m_get_last_visible_item_index()
{
  int last=f_first_visible_item_index+f_list_height-1;

  return(MIN(last,f_nb_items));
}

/****************************************************************************/
/* m_delete_item                                                            */
/*--------------------------------------------------------------------------*/
/* Suppression d'un lment de la liste.                                    */
/****************************************************************************/

void TList::m_delete_item(int item_index)
{
  PItemNode node_before,node_after;
  PItemNode node;
  bool one_item_was_selected;


  if ((item_index<1) || (item_index>f_nb_items))
    return;

  node=m_index_to_item(item_index);

  // S'il n'y a qu'une ligne,
  // effacement total

  if (f_nb_items==1)
    {
      m_clear_list();
      return;
    }

  // Il restera au moins un item aprs suppression
  // Suppression du noeud

  one_item_was_selected = f_selected_item_index != 0;

  node_before=node->last;
  node_after=node->next;

  if (f_last_item==node)
    f_last_item=node_before;

  if (node_before!=NULL)
    node_before->next=node_after;
  else
    f_item_list=node_after;

  if (node_after!=NULL)
    node_after->last=node_before;

  delete [](node->label);
  if (node->properties!=NULL)
    delete (node->properties);
  delete node;

  // Mise  jour des champs

  f_nb_items--;

  if (f_current_item_index>item_index)
    f_current_item_index--;
  else
    {
      if (f_current_item_index==item_index)
	{
	  f_current_item=node_before; // Peut tre NULL (item_index==1)
	  f_current_item_index--;     // Vaut alors 0
	}
    }

  if (f_selected_item_index>item_index)
    f_selected_item_index--;
  else
    {
      if (f_selected_item_index==item_index)
	f_selected_item_index=0;
    }

  if (f_first_visible_item_index>item_index)
     f_first_visible_item_index--;
  else
    {
      if (f_first_visible_item_index==item_index)
	{
	  if (node_after!=NULL)
	    f_first_visible_item=node_after;
	  else
	    {
	      f_first_visible_item=node_before; // Non NULL car il reste
	      f_first_visible_item_index--;     // au moins une ligne
	    }
	}

    }

  // Pour tre sr que la premire ligne est correcte

  m_set_first_visible_item_index(f_first_visible_item_index);
  m_display_list();

  if ((one_item_was_selected) || (f_always_one_item_selected))
    m_select_first_possible_item();

  m_nb_items_changed_callback();
}

/****************************************************************************/
/* m_clear_list                                                             */
/*--------------------------------------------------------------------------*/
/* Efface la liste.                                                         */
/****************************************************************************/

void TList::m_clear_list()
{
  PItemNode next_node;
  PItemNode node=f_item_list;

  if (f_nb_items==0)
    return;

  while (node!=NULL)
    {
      delete [](node->label);
      if (node->properties!=NULL)
	delete (node->properties);
      next_node=node->next;
      delete node;
      node=next_node;
    }

  f_nb_items=0;
  f_item_list=NULL;


  f_first_visible_item=NULL;
  f_first_visible_item_index=0;

  f_last_item=NULL;

  f_current_item=NULL;
  f_current_item_index=0;

  f_selected_item_index=0;

  m_display_list();

  m_visible_part_changed_callback();
  m_selected_item_changed_callback();
  m_nb_items_changed_callback();
}

/****************************************************************************/
/* m_set_item_attribute, m_unset_item_attribute                             */
/*--------------------------------------------------------------------------*/
/* Positionne/Enlve un(des) attributs d'un lment de la liste             */
/****************************************************************************/

void TList::m_set_item_attribute(int item_index,int item_attribute)
{
  PItemNode item_node;

  // index invalide

  if ((item_index<1) || (item_index>f_nb_items))
    return;

  // Attributs non autoriss

  item_attribute&=f_allowed_item_attribute;

  // Pas d'attribut

  if (item_attribute==LI_NOATTR)
    return;

  // Sparateur

  item_node=m_index_to_item(item_index);
  if (!strcmp(SEPARATOR,item_node->label))
    return;

  // Sinon, on modifie l'attribut

  m_change_item_attribute(item_node,item_index,
			  (item_node->attribute)|item_attribute);
}

void TList::m_unset_item_attribute(int item_index,int item_attribute)
{
  PItemNode item_node;

  // index invalide

  if ((item_index<1) || (item_index>f_nb_items))
    return;

  // Pas d'attribut

  if (item_attribute==LI_NOATTR)
    return;

  // Sinon, on modifie l'attribut

  item_node=m_index_to_item(item_index);
  m_change_item_attribute(item_node,item_index,
			  (item_node->attribute)&(~item_attribute));
}


/****************************************************************************/
/* m_item_attribute_is_set                                                  */
/*--------------------------------------------------------------------------*/
/* Indique si un ou plusieurs attributs d'un lment de la liste sont       */
/* positionns                                                              */
/****************************************************************************/

bool TList::m_item_attribute_is_set(int item_index,int item_attribute)
{
  PItemNode item_node;

  // index invalide

  if ((item_index<1) || (item_index>f_nb_items))
    return false;

  // On teste le ou les attributs demands

  item_node=m_index_to_item(item_index);

  return  ((item_node->attribute) & item_attribute) == item_attribute;

}


/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************************************************************/
/* m_add_item_to_list                                                       */
/*--------------------------------------------------------------------------*/
/* Ajout d'un lment  la liste.                                           */
/* Si index!=0, l'lment est ajout  l'index indiqu                     */
/* Retourne son index ou 0 si l'ajout est impossible.                       */
/****************************************************************************/

int TList::m_add_item_to_list(int index, const char *label, int attribute,PListItemProperties properties)
{
  char *search_label;

  PItemNode new_node;
  PItemNode node;
  register  PItemNode search_node;
  register  int search_index;
  bool   force_index;

  // Reste-t-il de la place

  if (f_nb_items==(MAX_ITEM_INDEX))
    return(0);

  // Index correct

  force_index = !f_sorted && index != 0;
  if (force_index)
    {
      if (index<1)
	index=1;
      if (index>(f_nb_items+1))
	index=f_nb_items+1;
    }

  // Attribut autoris

  attribute&=f_allowed_item_attribute;

  // Sparateur -> item_attribute=LI_NOATTR

  if (!strcmp(SEPARATOR,label))
    attribute=LI_NOATTR;

  // Ajout  la liste

  new_node=new TItemNode;
  new_node->label=new char [strlen(label)+1];
  strcpy(new_node->label,label);
  new_node->attribute=attribute;
  new_node->hot_key=HotKey(label);
  new_node->properties=properties;

  // Recherche de l'emplacement du nouvel lment dans la liste

  if (force_index)
    {
      search_index=index-1;
      search_node=((search_index==0)?NULL:m_index_to_item(search_index));
    }
  else
    {
      search_node=f_last_item;
      search_index=f_nb_items;

      // Le sparateur est rang  la fin
      if ((f_sorted) && (strcmp(SEPARATOR,label)))
	{
	  while (search_index!=0)
	    {
	      search_label=search_node->label;
	      if (strcmp(SEPARATOR,search_label))
		{
		  if (strcmp(search_label,label)<0)
		    break;
		}
	      search_index--;
	      search_node=search_node->last;
	    }
	}
    }
  // L'index du nouvel lment est search_index +1

  // Insertion en dbut de liste

  if (search_index==0)
    {
      node=f_item_list;
      if (node!=NULL)
	node->last=new_node;
      new_node->last=NULL;
      new_node->next=f_item_list; // Peut tre NULL
      f_item_list=new_node;
    }

  // Insertion en milieu/fin de liste

  else
    {
      node=search_node->next;
      if (node!=NULL)
	node->last=new_node;
      new_node->next=node;
      new_node->last=search_node;
      search_node->next=new_node;
    }

  // Mise  jour des champs

  if (search_index==f_nb_items)
    f_last_item=new_node;

  f_nb_items++;

  if (f_nb_items==1)
    m_set_first_visible_item_index(1);
  else
    {
      if (f_selected_item_index>search_index)
	f_selected_item_index++;

      if (f_current_item_index>search_index)
	f_current_item_index++;

      if (f_first_visible_item_index>search_index)
	f_first_visible_item=f_first_visible_item->last;
    }

  search_index++;

  m_display_items(search_index,f_nb_items);

  if ((f_selected_item_index!=0) || (f_always_one_item_selected))
    m_select_first_possible_item();

  m_nb_items_changed_callback();

  return(search_index);
}


/****************************************************************************/
/* m_display                                                                */
/*--------------------------------------------------------------------------*/
/* Affichage de l'objet                                                     */
/****************************************************************************/

void TList::m_display()
{
  if (!f_open)
    return;

  TObject::m_display();
  m_display_list();
}

/****************************************************************************/
/* m_display_focus_depending_part                                           */
/*--------------------------------------------------------------------------*/
/* Affichage de la partie de l'objet dont l'aspect dpend du focus          */
/****************************************************************************/

void TList::m_display_focus_depending_part()
{
  if (f_selected_item_index!=0)
    m_display_item(f_selected_item_index);
}

/****************************************************************************/
/* m_display_list                                                           */
/*--------------------------------------------------------------------------*/
/* Affichage de la partie visible de la liste des lments.                 */
/****************************************************************************/

void TList::m_display_list()
{
  int       x,y1,y2;
  register  int   i;
  int       index;

  PItemNode item_node;

  if (!f_open)
    return;

  x=m_get_x_in_window()+f_list_rel_x;
  y1=m_get_y_in_window()+f_list_rel_y;
  y2=y1+f_list_height-1;


  // Affichage de la partie de la liste contenant des items

  item_node=f_first_visible_item;
  i=y1;
  index=f_first_visible_item_index;

  while ((i<=y2) && (item_node!=NULL))
    {
      f_window->m_gotoxy(x,i);
      m_display_item_node(item_node,index);
      item_node=item_node->next;
      index++;
      i++;
    }

  // On complte avec des lignes vides

  if (f_enabled)
    f_window->m_set_normal_attr(f_background);
  else
    f_window->m_set_inactive_attr(f_background);

  while (i<=y2)
    {
      f_window->m_gotoxy(x,i);
      f_window->m_puts(f_empty_line);
      i++;
    }
}

/****************************************************************************/
/* m_display_items                                                          */
/*--------------------------------------------------------------------------*/
/* Affichage des lments de la liste visibles compris entre les 2 indexes  */
/* indiqus.                                                                */
/****************************************************************************/

void TList::m_display_items(int first_index,int last_index)
{
  int       x,y1,y2,tmp;
  register  int   i;

  PItemNode item_node;

  if (!f_open)
    return;

  x=m_get_x_in_window()+f_list_rel_x;
  y1=m_get_y_in_window()+f_list_rel_y;
  y2=y1+f_list_height-1;


  // Affichage de la partie de la liste contenant des items

  if (first_index<f_first_visible_item_index)
    first_index=f_first_visible_item_index;

  i=y1+first_index-f_first_visible_item_index;
  if (i>y2)
    return;

  tmp=i+(last_index-first_index);
  y2=MIN(tmp,y2);

  item_node=m_index_to_item(first_index);

  while ((i<=y2) && (item_node!=NULL))
    {
      f_window->m_gotoxy(x,i);
      m_display_item_node(item_node,first_index);
      item_node=item_node->next;
      first_index++;
      i++;
    }
}

/****************************************************************************/
/* m_display_item                                                           */
/*--------------------------------------------------------------------------*/
/* Affichage d'un lment de la liste (s'il est dans la partie visible)     */
/****************************************************************************/

void TList::m_display_item(int item_index)
{
  int y_item;
  PItemNode item_node;

  if (!f_open)
    return;

  // Elment non visible de la liste

  y_item=item_index-f_first_visible_item_index;

  if (   (y_item<0)
      || (y_item>=f_list_height))
    return;

  // Elment visible

  f_window->m_gotoxy(m_get_x_in_window()+f_list_rel_x,
		     m_get_y_in_window()+f_list_rel_y+y_item);



  item_node=m_index_to_item(item_index);
  m_display_item_node(item_node,item_index);
}

/****************************************************************************/
/* m_set_list_size                                                          */
/*--------------------------------------------------------------------------*/
/* Permet de modifier la taille de la liste                                 */
/****************************************************************************/

void TList::m_set_list_size(int list_width,int list_height)
{
  char *end_ptr,*ptr;

  // La liste doit tre ferme

  if (f_open)
    return;

  if (list_width<0)
    list_width=0;
  if (list_height<0)
    list_height=0;

  f_list_width=list_width;
  f_list_height=list_height;

  // Ligne vide (affiche en cas d'absence d'lments)

  if (f_empty_line!=NULL)
    delete []f_empty_line;

  f_empty_line=new char [f_list_width+1];

  end_ptr=f_empty_line+f_list_width;
  for (ptr=f_empty_line;ptr<end_ptr;ptr++)
    (*ptr)=' ';
  (*ptr)=0;

  // Ligne sparatrice

  if (f_separator_line!=NULL)
    delete []f_separator_line;

  f_separator_line=new char [f_list_width+1];

  end_ptr=f_separator_line+f_list_width;
  for (ptr=f_separator_line;ptr<end_ptr;ptr++)
    (*ptr)='';
  (*ptr)=0;
}

/****************************************************************************/
/* m_get_list_needed_width                                                  */
/*--------------------------------------------------------------------------*/
/* Retourne la largeur que devrait avoir la liste pour que les items soient */
/* visibles en entier.                                                      */
/****************************************************************************/

int TList::m_get_list_needed_width()
{
  PItemNode node;

  int item_width;
  int list_width;

  list_width=0;
  node=f_item_list;

  while (node!=NULL)
    {
      item_width=DisplayLength(node->label);

      if (item_width>list_width)
	list_width=item_width;

      // Passage  l'lment suivant

      node=node->next;
    }

  return(list_width+2); // +1 pour la coche, +1 pour un espace  droite
}

/****************************************************************************/
/* m_selected_item_changed_callback                                         */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand l'lment slectionn de la liste est modifi.    */
/****************************************************************************/

void TList::m_selected_item_changed_callback()
{
	selectedItemChangedAction_();
}

/****************************************************************************/
/* m_visible_part_changed_callback                                          */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand la partie visible de la liste est modifie.       */
/****************************************************************************/

void TList::m_visible_part_changed_callback()
{
  static bool in_callback=false;

  if (!in_callback)
    {
      in_callback=true;

      if (f_scrollbar!=NULL)
	f_scrollbar->m_set_value((long)f_first_visible_item_index);

		visiblePartChangedAction_();

      in_callback=false;
    }
}

/****************************************************************************/
/* m_item_dbl_clicked_callback                                              */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand on double-clic sur un lment de la liste.        */
/****************************************************************************/

void TList::m_item_dbl_clicked_callback(int index)
{
	itemDblClickAction_(index);
}

/****************************************************************************/
/* m_nb_items_changed_callback                                              */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand le nombre d'lments de la liste est modifi.     */
/****************************************************************************/

void TList::m_nb_items_changed_callback()
{
  static bool in_callback=false;

  if (!in_callback)
    {
      in_callback=true;

      if (f_scrollbar!=NULL)
	{
	  if (f_nb_items<=f_list_height)
	    {
	      f_scrollbar->m_disable();
	      f_scrollbar->m_set_can_be_enabled(false);
	    }
	  else
	    {
	      f_scrollbar->m_set_min_max_values(f_scrollbar->m_get_min_value(),f_nb_items-f_list_height+1);
	      f_scrollbar->m_set_can_be_enabled(true);
	      if (f_enabled)
		f_scrollbar->m_enable();
	    }
	}

		nbItemsChangedAction_();

      in_callback=false;
    }
}

void	TList::operator()(TObject* who, what_type what, item_type item)
{
	static bool in_callback=false;
	if (!in_callback) {
    	in_callback=true;
      	PList 		list=(PList)(f_scrollbar->m_get_parent());
		unsigned	scrollbar_value=f_scrollbar->m_get_value();
      	list->m_set_first_visible_item_index(scrollbar_value);
		in_callback=false;
	}
}

/****************************************************************************/
/* m_mouse_went_to_list_callback                                            */
/*--------------------------------------------------------------------------*/
/* Appele dans les vnements souris quand la souris entre dans la partie  */
/* 'liste' de l'objet                                                       */
/****************************************************************************/

void TList::m_mouse_went_to_list_callback()
{
}

/****************************************************************************/
/* m_left_button_pressed_event                                              */
/*--------------------------------------------------------------------------*/
/* L'utilisateur a cliqu dans l'objet avec le bouton gauche                */
/* (l'objet tant activable).                                               */
/* Retourne true si l'objet est intress par cet vnement.                */
/****************************************************************************/

bool TList::m_left_button_pressed_event(int x,int y)
{
  int x1_list,y1_list,
      x2_list,y2_list;

  bool first_scroll;

  int button_state;

  int  index;
  int last_visible_item_index;

  bool wait_delay;
  bool need_refresh=false;

  bool went_to_list;
  bool out_of_list;

  if (!f_focused)
    {
      if (!m_set_focus())
	return false;
//      JPRefresh();
    }

  if (TObject::m_left_button_pressed_event(x,y))
    return true;

  if (f_nb_items==0)
    return true;


  wait_delay=false;
  went_to_list=false;
  out_of_list=true;

  button_state=LEFT_BUTTON_PRESSED;

  first_scroll=true;


  x1_list=m_get_x()+f_list_rel_x;
  y1_list=m_get_y()+f_list_rel_y;
  x2_list=x1_list+f_list_width-1;
  y2_list=y1_list+f_list_height-1;

  /*

  Enleve car probleme avec la boite de selection de fichier

  // Si l'lment cliqu est dj slectionn

  if (   (f_selected_item_index!=0)
      && (x>=x1_list) && (x<=x2_list)
      && (y>=y1_list) && (y<=y2_list))
    {
      went_to_list=true;
      m_mouse_went_to_list_callback();
      if ((y-y1_list+f_first_visible_item_index)==f_selected_item_index)
	{
	  y_chosen=y;
	  button_state=LEFT_BUTTON_PRESSED;

	  while (   (button_state==LEFT_BUTTON_PRESSED)
		 && (y==y_chosen)
		 && (x>=x1_list) && (x<=x2_list))
	    GetMouseState(x,y,button_state);

	  if (   (y==y_chosen)
		 && (x>=x1_list) && (x<=x2_list))
	    return(m_left_button_double_click_event(x,y));
	}
    }
  */

  button_state=LEFT_BUTTON_PRESSED;
  need_refresh=true;
  while (button_state==LEFT_BUTTON_PRESSED)
    {
      index=f_selected_item_index;

      out_of_list=  x < x1_list
			    || x > x2_list
			    || y < y1_list
			    || y > y2_list;

      if (!went_to_list)
	{
	  if (!out_of_list)
	    {
	      went_to_list=true;
	      m_mouse_went_to_list_callback();
	    }
	}


      if (went_to_list)
	{

	  if ((!f_always_one_item_selected) && ((x<x1_list) || (x>x2_list)))
	    index=0;
	  else
	    {
	      if (y<y1_list)
		{
		  if (f_first_visible_item_index>1)
		    {
		      m_set_first_visible_item_index(f_first_visible_item_index-1);
		      index=f_first_visible_item_index;
		      wait_delay=true;
		    }
		  else
		    {
		      if (!f_always_one_item_selected)
			index=0;
		    }
		}
	      else
		{
		  if (y>y2_list)
		    {
		      last_visible_item_index=f_first_visible_item_index+f_list_height-1;
		      if (last_visible_item_index<f_nb_items)
			{
			  last_visible_item_index++;
			  m_set_last_visible_item_index(last_visible_item_index);
			  index=last_visible_item_index;
			  wait_delay=true;
			}
		      else
                        {
                          if (!f_always_one_item_selected)
			    index=0;
			}
                    }
		  else
		    {
		      index=y-y1_list+f_first_visible_item_index;
		      if (index>f_nb_items)
			{
			  if (!f_always_one_item_selected)
			    index=0;
			  else
			    index=f_nb_items;
			}
		    }
		}
	    }
	}

      if (index!=f_selected_item_index)
	{
	  if ((!m_set_selected_item_index(index)) && (!f_always_one_item_selected))
	    m_set_selected_item_index(0);
	  need_refresh=true;
	}

      if (need_refresh)
	{
	  JPRefresh();
	  need_refresh=false;
	}

      if (wait_delay)
	{
	  if (first_scroll)
	    {
	      delay(LIST_FIRST_SCROLL_SPEED);
	      first_scroll=false;
	    }
	  else
	    delay(LIST_SCROLL_SPEED);
	  wait_delay=false;
	}

      if (out_of_list)
	{
	  if (m_leave_event_if_mouse_leave_list(x,y))
	    return true;
	}

      GetMouseState(x,y,button_state);
    }

  return true;
}

/****************************************************************************/
/* m_left_button_double_click_event                                         */
/*--------------------------------------------------------------------------*/
/* L'utilisateur a double-cliqu sur un lment de la liste                 */
/* (l'objet tant activable et ayant dj subi l'vnement                  */
/* m_left_button_pressed_event).                                            */
/* Retourne true si l'objet est intress par cet vnement.                */
/****************************************************************************/

bool TList::m_left_button_double_click_event(int x,int y)
{
  int x1_list,y1_list,
      x2_list,y2_list;

  int  index;

  if (TObject::m_left_button_double_click_event(x,y))
    return true;

  if (f_nb_items==0)
    return true;

  x1_list=m_get_x()+f_list_rel_x;
  y1_list=m_get_y()+f_list_rel_y;
  x2_list=x1_list+f_list_width-1;
  y2_list=y1_list+f_list_height-1;

  if ((x<x1_list) || (x>x2_list) || (y<y1_list) || (y>y2_list))
    return false;

  index=y-y1_list+f_first_visible_item_index;

  if (index!=f_selected_item_index)
    return false;

  m_item_dbl_clicked_callback(index);
  return true;
}


/****************************************************************************/
/* m_key_pressed_event                                                      */
/*--------------------------------------------------------------------------*/
/* L'utilisateur a appuy sur une touche qui est propose  l'objet         */
/* (qui est activable).                                                     */
/* Retourne true si l'objet est intress par cette touche.                 */
/****************************************************************************/

bool TList::m_key_pressed_event(TKey key)
{
  PItemNode node;
  int  index=1;


  if (TObject::m_key_pressed_event(key))
    return true;

  if ((!f_focused) || (f_nb_items==0))
    return false;

  if (IsExtendedKey(key))
    {
      switch (key.character)
	{
	  case UP   : if (f_selected_item_index!=0)
			{
			  if (f_selected_item_index>1)
			    index=f_selected_item_index-1;
			  else
			    index=1;
			}
		      else
			index=f_nb_items;
		      break;

	  case PGUP : if (f_selected_item_index!=0)
			{
			  if (f_selected_item_index>f_list_height)
			    index=f_selected_item_index-f_list_height;
			  else
			    index=1;
			}
		      else
			index=f_nb_items;
		      break;

	  case DOWN : if (f_selected_item_index!=0)
			{
			  if (f_selected_item_index<f_nb_items)
			    index=f_selected_item_index+1;
			  else
			    index=f_nb_items;
			}
		      else
			index=1;
		      break;

	  case PGDN : if (f_selected_item_index!=0)
			{
			  index=f_selected_item_index+f_list_height;
			  if (index>f_nb_items)
			    index=f_nb_items;
			}
		      else
			index=1;
		      break;

	  case HOME : if (f_nb_items!=0)
			index=1;
		      break;

	  case END  : if (f_nb_items!=0)
			index=f_nb_items;
		      break;

	  default   : return false;
	}

      if (index!=f_selected_item_index)
	{
	  if (index>f_selected_item_index)
	    {
	      while ((index<=f_nb_items) && (!m_set_selected_item_index(index)))
		index++;
	    }
	  else
	    {
	      while ((index>=1) && (!m_set_selected_item_index(index)))
		index--;
	    }
	}

      if (   (index<f_first_visible_item_index)
	  || (index>=(f_first_visible_item_index+f_list_height)))
	{
	  switch (key.character)
	    {
	      case UP   :
	      case PGUP :
	      case HOME : m_set_first_visible_item_index(index);
			  break;

	      case DOWN :
	      case PGDN :
	      case END  : m_set_last_visible_item_index(index);
			  break;
	    }
	}

      JPRefresh();
      return true;
    }


  // hot-keys des lments

  if (!f_item_hot_key_enabled)
    return false;


  node=f_item_list;
  index=1;
  while (node!=NULL)
    {
      if (node->hot_key==key.hot_character)
	{
	  if (!((node->attribute)&LI_DISABLED)) // Si item actif
	    {
	      f_current_item=node;
	      f_current_item_index=index;
	      m_item_hot_key_pressed_event(index);
	      return true;
	    }
	}
      node=node->next;
      index++;
    }
  return true;
}

/*ͻ*/
/*                             METHODES PRIVEES                           */
/*ͼ*/

/****************************************************************************/
/* m_index_to_item                                                          */
/*--------------------------------------------------------------------------*/
/* Retourne un pointeur sur un lment de la liste  partir de son index.   */
/****************************************************************************/

PItemNode TList::m_index_to_item(int  index)
{
  PItemNode node=NULL;
  register int  i;
  int  last_i;
  bool forward=true;


  int  gap[4];
  int  choice;


  JPDEBUG_TEST(DEBUG_ERROR_14,(index>=1) && (index<=f_nb_items));

  if (index==f_current_item_index)
    return(f_current_item);

  // On cherche le point de dpart du parcours de la liste
  // le plus intressant entre :

  gap[0]=abs(index-f_current_item_index);      // l'lment courant
  gap[1]=abs(index-f_first_visible_item_index);// le premier visible
  gap[2]=index-1;                              // le premier lment
  gap[3]=f_nb_items-index;                     // le dernier lment


  if (gap[0]<gap[1])
    choice=0;
  else
    choice=1;

  if (gap[2]<gap[choice])
    choice=2;

  if (gap[3]<gap[choice])
    choice=3;

  // Sens de parcours de la liste et point de depart

  switch(choice)
    {
      case 0 : // Elment courant
	       forward = index > f_current_item_index;
	       node=f_current_item;
               break;
      case 1 : // Premier visible
               forward = index > f_first_visible_item_index;
               node=f_first_visible_item;
               break;
      case 2 : // Premier lement
	       forward=true;
               node=f_item_list;
	       break;
      case 3 : // Dernier lment
               forward=false;
	       node=f_last_item;
               break;
    }


   // Parcours de la liste

  last_i=gap[choice];

  switch (forward)
    {
      case true : for (i=0;i<last_i;i++)
		    node=node->next;
                  break;
      case false: for (i=0;i<last_i;i++)
		    node=node->last;
                  break;
    }

  f_current_item=node;
  f_current_item_index=index;

  return(node);
}

/****************************************************************************/
/* m_display_item_node                                                      */
/*--------------------------------------------------------------------------*/
/* Affiche un lment de la liste d'aprs un pointeur sur cet lment       */
/* et son index (la position d'affichage doit dj tre fixe)              */
/****************************************************************************/

void TList::m_display_item_node(PItemNode node,int index)
{
  bool enabled;

  // Sparateur

  if (!strcmp(SEPARATOR,node->label))
    {
      if (f_enabled)
	f_window->m_set_normal_attr(f_background);
      else
	f_window->m_set_inactive_attr(f_background);

      f_window->m_puts(f_separator_line);
    }
  else
    {
      // Ce n'est pas un sparateur

      if (!f_enabled)
	enabled=false;
      else
	enabled = (node->attribute & LI_DISABLED) == 0;

      //->Elment slectionn

      if (f_selected_item_index==index)
	{
	  if ((f_focused) && (f_window->m_is_active()))
	    {
	      if (enabled)
		f_window->m_set_inverse_attr(f_background);
	      else
		f_window->m_set_inverse_inactive_attr(f_background);
	    }
	  else
	    f_window->m_textattr((LIGHTGRAY<<4)+(unsigned)(enabled?WHITE:CYAN));
	}
      else
	{
	  //->Elment activable/non activable

	  if (enabled)
	    f_window->m_set_normal_attr(f_background);
	  else
	    f_window->m_set_inactive_attr(f_background);
	}

      f_window->m_putch( (node->attribute&LI_CHECKED)?SPECIAL_CHAR(SCH_LIST_CHECK):' ');
      m_display_item_node_label(node, enabled && f_item_hot_key_enabled);
    }
}

/****************************************************************************/
/* m_display_item_node_label                                                */
/*--------------------------------------------------------------------------*/
/* Affiche un lment de la liste d'aprs un pointeur sur cet lment       */
/* (la position d'affichage doit dj tre fixe ainsi que la couleur)      */
/* N'est pas appel pour les sparateurs                                    */
/* N'affiche pas non plus la coche ventuelle                               */
/****************************************************************************/

void TList::m_display_item_node_label(PItemNode node,bool show_hot_key)
{
  char old_char;
  int length;
  int width;

  if (f_item_hot_key_enabled)
    f_window->m_put_caption(node->label,
			    show_hot_key,
			    f_list_width-1,
			    JUSTIFIED_LEFT);
  else
    {
      length=strlen(node->label);
      width=f_list_width-1;

      old_char=0;
      if (length>width)
	{
	  old_char=(node->label)[width];
	 (node->label)[width]=0;
	}

      f_window->m_puts(node->label);

      if (length>width)
	(node->label)[width]=old_char;
      else
	f_window->m_putnch(width-length,' ');
    }
}

/****************************************************************************/
/* m_change_item_attribute                                                  */
/*--------------------------------------------------------------------------*/
/* Modifie un ou plusieurs des attributs d'un lment de la liste           */
/****************************************************************************/

void TList::m_change_item_attribute(PItemNode item_node,int item_index,int new_attribute)
{
  int old_attribute=item_node->attribute;

  if (old_attribute!=new_attribute)
    {
      item_node->attribute=new_attribute;
      m_display_item(item_index);

      // Attribut LI_CHECKED modifi ?

      if ((old_attribute&LI_CHECKED)!=(new_attribute&LI_CHECKED))
			itemCheckChangedAction_(item_index);
    }
}

/****************************************************************************/
/* m_leave_event_if_mouse_leave_list                                        */
/*--------------------------------------------------------------------------*/
/* Appele dans l'vnement m_left_button_pressed_event lorsque la souris   */
/* quitte la zone de la liste.                                              */
/* Si true est retourne, l'vnement m_left_button_pressed_event est       */
/* interrompue                                                              */
/****************************************************************************/

bool TList::m_leave_event_if_mouse_leave_list(int /*x*/,int /*y*/)
{
  return false;
}

/****************************************************************************/
/* m_item_hot_key_pressed_event                                             */
/*--------------------------------------------------------------------------*/
/* Appele quand la hot-key d'un lment actif a t presse                */
/****************************************************************************/

void TList::m_item_hot_key_pressed_event(int /*item_index*/)
{
}

