/****************************************************************************/
/* THELPTZ                                                                  */
/*--------------------------------------------------------------------------*/
/* Class THelpTextZone (Help display text zone)				    */
/* Should only be used by the THelpWindow class				    */
/****************************************************************************/

#ifndef _THELPTZ_H_
#define _THELPTZ_H_

#include <stdio.h>

#include "TTextZn.h"

#define MAXHELPSTACK     100
#define MAXHELPKEYWORDS  50


// Arbre de huffman dans le fichier compress

typedef struct { short right,left; } THuffmanTree,*PHuffmanTree;


typedef struct help_topic
{
  char         *name;            // Nom de la rubrique d'aide
  long int     byte_pos;             // Index en octets dans le fichier d'aide         */
  short int    bit_pos;              // Index en bits
  short int    next_help;          // Index de la rubrique suivante
  short int    previous_help;          // Index de la rubrique prcdente
} THelpTopic;


typedef struct keywords
{
  int             lineno;
} TKeyWords;


typedef struct history
{
  int    topic_index;
  int    first_col,first_line;
  int    col,line;
  struct history *next;
}
THistoryNode,*PHistoryNode,*PHistoryList;

typedef struct link_node
{
  int		      col1;
  int		      col2;
  short int           help;
  struct link_node   *last,*next;
} TLinkNode,*PLinkNode,*TLinkList;


/*ͻ*/
/*                             CLASS DEFINITION                           */
/*ͼ*/


class THelpTextZone:public TTextZone
{

  /*----------------*/
  /* Private fields */
  /*----------------*/


  private:
    // Help file

    FILE                *f_help_file;
    char                *f_help_file_name;

    // History

    PHistoryList        f_help_history;

    // Decompressing

    PHuffmanTree        f_help_tree;
    short int           f_root;
    int                 f_in8;
    int                 f_ct8;


    // Help

    THelpTopic          *f_first_help,
			*f_this_help;
    short int           f_help_count;

//    TKeyWords           f_key_words[MAXHELPKEYWORDS];
//    int                 f_key_word_count;

    // Selected link

    PLinkNode           f_selected_link;
    int			f_selected_link_line;

  /*----------------*/
  /* Public methods */
  /*----------------*/

  public:

    // Constructor / Destructor

		    THelpTextZone(PObject parent,
				  int rel_x,int rel_y,
				  int width,int height);

    virtual         ~THelpTextZone();


	    bool m_load_help_file(const char *file_name);
	    void    m_unload_help_file();
	    bool m_topic_exists(const char *topic);
	    bool m_display_topic(const char *help, bool push_current_topic);

	    void    m_select_contents_topic();
	    void    m_select_index_topic();
	    void    m_select_back_topic();
	    void    m_select_previous_topic();
	    void    m_select_next_topic();

    virtual void    m_display_string_node(PStringNode node,int line);
	    void m_display_help_string_part(const char *string, 
              int string_length, int col1, int col2, int min_selected_col,
              int max_selected_col, unsigned normal_attr, unsigned selected_attr);

  /*-------------------*/
  /* Protected methods */
  /*-------------------*/

  protected:

    virtual void    m_cursor_pos_changed_callback();

    // Events

    virtual bool m_left_button_double_click_event(int x,int y);
    virtual bool m_key_pressed_event(TKey key);


  /*-----------------*/
  /* Private methods */
  /*-----------------*/

  private:

	    void    m_free_help_file();
	    bool m_open_help_file(const char *file_name);
	    THelpTopic *m_find_topic(const char *topic);
	    void    m_read_topic();
	    void    m_seek_help_line(long offset,int bit);
	    char *m_get_help_line(char *line);
	    void    m_select_topic(THelpTopic *new_topic,bool push_current_topic);

	    PLinkNode   m_pos_to_link(int col,int line);

//	    void    m_select_next_link();
//	    void    m_select_previous_link();

	    void    m_push_current_topic();
	    void    m_display_string(const char *caption, int string_number);

};


#endif
