#include "block.h"

void CreateBlocker(void)
{
    blocker = malloc(sizeof(struct list));
    blocker->count = 0;
    blocker->head = NULL;
}

void KillBlocker(void)
{
    free(blocker);
}

void block(struct thread * toblock)
{
    struct thread * foo;
    int count=0;

    Append(blocker, (void*) toblock);
    toblock->threadstatus = BLOCKED; 
    do{
        foo = (struct thread *) Remove(scheduler);
        if(foo->TID != toblock->TID)
        {
            AddToReady(foo);
        } 
        count++;
    }while((int) foo != NULL && (int) foo != 0 && foo->TID != toblock->TID && count <= blocker->count);
}

void kick(struct thread * tokick)
{
    struct thread * foo;
    int count=0;
    do{
        foo = (struct thread *) Remove(blocker);
        if(foo->TID == tokick->TID)
        {
            AddToReady(tokick);
        }
        else
        {
            Append(blocker, (void *) foo);
        }
        count++;
    }while((int) foo != NULL && (int) foo != 0 && foo->TID != tokick->TID && count <= blocker->count);
}
