/* Copyright (C) 1992-2000 the Florida State University
   Distributed by the Florida State University under the terms of the
   GNU Library General Public License.

This file is part of Pthreads.

Pthreads is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation (version 2).

Pthreads is distributed "AS IS" in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with Pthreads; see the file COPYING.  If not, write
to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.

Report problems and direct all questions to:

  pthreads-bugs@ada.cs.fsu.edu

  @(#)config_header.c	3.14 11/8/00

*/

/*
 * Create configuration header files depending on compile options
 */

#include <stdio.h>
#include <string.h>

#ifdef INTERNALS
#define PTHREAD_KERNEL
#include "internals.h"
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifndef MIN
#define MIN(x,y) (x < y ? x : y)
#endif

int main(argc, argv)
     int argc;
     char *argv[];
{
  short local = (argv[1][0] == '-' && argv[1][1] == 'l');
  int release_index = (local ? 2 : 1);
  short old_local = FALSE;
  short restore_local = FALSE;

  printf("/* Copyright (C) 1992, 1993, 1994, 1995, 1996 the Florida State University\n");
  printf("   Distributed by the Florida State University under the terms of the\n");
  printf("   GNU Library General Public License.\n");
  printf("\n");
  printf("This file is part of Pthreads.\n");
  printf("\n");
  printf("Pthreads is free software; you can redistribute it and/or\n");
  printf("modify it under the terms of the GNU Library General Public\n");
  printf("License as published by the Free Software Foundation (version 2).\n");
  printf("\n");
  printf("Pthreads is distributed \"AS IS\" in the hope that it will be\n");
  printf("useful, but WITHOUT ANY WARRANTY; without even the implied\n");
  printf("warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n");
  printf("See the GNU Library General Public License for more details.\n");
  printf("\n");
  printf("You should have received a copy of the GNU Library General Public\n");
  printf("License along with Pthreads; see the file COPYING.  If not, write\n");
  printf("to the Free Software Foundation, 675 Mass Ave, Cambridge,\n");
  printf("MA 02139, USA.\n");
  printf("\n");
  printf("Report problems and direct all questions to:\n");
  printf("\n");
  printf("  pthreads-bugs@ada.cs.fsu.edu\n");
  printf("\n");
  printf("  %%@(#)config_header.c	3.14%% %%11/8/00%%\n");
  printf("*/\n");
  printf("\n");

  printf("/*\n");
  printf(" * configuration header file to identify compile options\n");
  printf(" */\n");
  printf("\n");

  for (argc--; argc; argc--)
    if (argv[argc][0] == '-' && argv[argc][1] == 'D') {
      if (strcmp(&argv[argc][2], "__dos__") == 0 ||
          strcmp(&argv[argc][2], "_POSIX") == 0) {
        old_local = local;
        restore_local = TRUE;
        local = TRUE;
      }
      if (argc == release_index) {
	printf("#ifndef RELEASE%s\n", local ? "" : "_NP");
	printf("#define RELEASE%s %s\n", local ? "" : "_NP", &argv[argc][2]);
      } else {
	printf("#ifndef %s%s\n", &argv[argc][2], local ? "" : "_NP");
	printf("#define %s%s\n", &argv[argc][2], local ? "" : "_NP");
      }
      printf("#endif\n\n");
      if (restore_local) {
        local = old_local;
        restore_local = FALSE;
      }
    }

  printf("#ifndef _M_UNIX\n");
  printf("#if defined(M_UNIX) || defined(__M_UNIX)\n");
  printf("#define _M_UNIX\n");
  printf("#endif\n");
  printf("#endif\n");

#ifdef INTERNALS
  if (local)
  {
    struct context_t *scp;
    int sigset_t_size = sizeof(sigset_t);
    int sigcontext_mask_t_size = sizeof(scp->sc_mask);

    printf("\n");
    printf("#define PTHREAD_SIGSET_T_SIZE_NP %d\n", sigset_t_size);
    printf("#define PTHREAD_SIGCONTEXT_MASK_T_SIZE_NP %d\n",
	   sigcontext_mask_t_size);
    printf("#define PTHREAD_SIGSET2SET_SIZE_NP %d\n",
	   MIN(sigset_t_size, sigcontext_mask_t_size));

#ifdef __DJGPP__
    printf("\n"
           "/*  gcc no longer includes this by default.  */\n"
           "#include <sys/version.h>\n"
           "\n"
           "#if defined (__GNUC__) && (__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8))\n"
           "# define __gnuc_extension__  __extension__\n"
           "#else\n"
           "# define __gnuc_extension__\n"
           "#endif\n"
           "\n"
           "/*\n"
           " *  DJGPP's sigset_t is a struct with an\n"
           " *  unsigned lont int array member with 10 elements.\n"
           " *  Thus it cannot be assumed that it is int and\n"
           " *  all functions assuming pointer of int must be\n"
           " *  re-written for pointer of struct.\n"
           " */\n"
           "#define __sigset_t_is_struct__\n"
           "#define BITS __bits\n"
           "\n");
#endif

    {
      FILE *f = fopen("prototypes.h", "w");
      if (f)
      {
        fprintf(f, "/*\n"
                   " *  Generated by config_header to provide function prototypes.\n"
                   " */\n"
                   "\n"
                   "\n"
                   "#ifndef _function_prototypes_h\n"
                   "#define _function_prototypes_h\n"
                   "\n"
                   "/*  From cond.c.  */\n"
                   "void pthread_cond_wait_terminate(pthread_cond_t *_cond);\n"
                   "\n"
                   "/*  From disp.c.  */\n"
                   "void pthread_handle_pending_signals_wrapper(void);\n"
                   "int pthread_not_called_from_sighandler(int _addr);\n"
                   "void pthread_process_exit(int _status);\n"
                   "void pthread_sched(void);\n"
                   "pthread_t pthread_sched_new_signals(pthread_t _p, int _masked);\n"
                   "#ifdef C_CONTEXT_SWITCH\n"
                   "void pthread_sched_wrapper(int _sig, int _code, pthread_t _p);\n"
                   "#else /* !C_CONTEXT_SWITCH */\n"
                   "void pthread_sched_wrapper(int _sig, int _code);\n"
                   "#endif /* !C_CONTEXT_SWITCH */\n"
                   "void pthread_signal_sched(int _sig, int _code);\n"
                   "\n"
                   "/*  From init.c.  */\n"
                   "void pthread_initialize(pthread_t _t);\n"
                   "\n"
                   "/*  From signal.c.  */\n"
                   "int pthread_cancel_timed_sigwait(pthread_t _first_p, int _signaled, int _mode, int _activate);\n"
                   "void pthread_clear_sighandler(void);\n"
                   "void pthread_handle_pending_signals(void);\n"
                   "void pthread_handle_one_process_signal(int _sig, int _code);\n"
                   "void pthread_init_signals(void);\n"
                   "#ifdef __sigset_t_is_struct__\n"
                   "int pthread_signonemptyset(volatile sigset_t *_set);\n"
                   "int pthread_siggeset2set(volatile sigset_t *_dst, volatile sigset_t *_src);\n"
                   "void pthread_sigaddset2set(volatile sigset_t *_dst, volatile sigset_t *_src);\n"
                   "void pthread_sigcpyset2set(volatile sigset_t *_dst, volatile sigset_t *_src);\n"
                   "void pthread_sigdelset2set(volatile sigset_t *_dst, volatile sigset_t *_src);\n"
                   "void pthread_signalcpyset2set(unsigned long *_dst, unsigned long *_src);\n"
                   "#else /* !__sigset_t_is_struct__ */\n"
                   "int pthread_signonemptyset(int *_set);\n"
                   "int pthread_siggeset2set(int *_dst, int *_src);\n"
                   "void pthread_sigaddset2set(int *_dst, int *_src);\n"
                   "void pthread_sigcpyset2set(int *_dst, int *_src);\n"
                   "void pthread_sigdelset2set(int *_dst, int *_src);\n"
                   "#endif /* !__sigset_t_is_struct__ */\n"
                   "int pthread_timed_sigwait(pthread_t _p, struct timespec *_timeout, int _mode, pthread_func_t _func, any_t _arg);\n"
                   "\n"
                   "/*  From stack.c.  */\n"
                   "int pthread_alloc_stack(pthread_t _p);\n"
                   "void pthread_stack_init(pthread_t _p);\n"
                   "\n"
                   "/*  From queue.c.  */\n"
                   "void pthread_mutex_q_adjust(pthread_t _p);\n"
                   "void pthread_q_all_enq(pthread_queue_t _q, pthread_t _t);\n"
                   "void pthread_q_deq(pthread_queue_t _q, pthread_t _t, int _index);\n"
                   "void pthread_q_primary_enq(pthread_queue_t _q, pthread_t _t);\n"
                   "void pthread_q_primary_enq_first(pthread_queue_t _q, pthread_t _t);\n"
                   "void pthread_q_sleep(pthread_queue_t _q, int _index);\n"
                   "void pthread_q_sleep_thread(pthread_queue_t _q, pthread_t _p, int _index);\n"
                   "#ifdef STAND_ALONE\n"
                   "void pthread_q_timed_enq(pthread_timer_q_t *_q, pthread_t _p);\n"
                   "#else /* !STAND_ALONE */\n"
                   "int pthread_q_timed_enq(pthread_timer_q_t _q, struct timeval _in, int _mode, pthread_t _p);\n"
                   "#endif /* STAND_ALONE */\n"
                   "void pthread_q_timed_wakeup_thread(pthread_timer_q_t q, pthread_t p, int activate);\n"
                   "void pthread_q_wakeup(pthread_queue_t _q, int _index);\n"
                   "void pthread_q_wakeup_all(pthread_queue_t _q, int _index);\n"
                   "void pthread_q_wakeup_thread(pthread_queue_t _q, pthread_t _p, int _index);\n"
                   "pthread_t pthread_q_deq_head(pthread_queue_t _q, int _index);\n"
                   "\n"
                   "#endif /*  _function_prototypes_h  */\n");
        fclose(f);
      }
      else
        return(1);
    }
  }
#endif

  return(0);
}
