/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */

#ifndef __include_hash_h_
#define __include_hash_h_

#pragma pack(1)

typedef struct tagElem
{
        struct tagElem  *next;
        struct tagElem  *prev;
        void            *item;
} THashElem;

typedef struct  tagHashTab
{
        int      size     ;             /* Max number of elements in table */
        int      numitems ;             /* number of elements currently in table */
   unsigned long (*hash)(void *item);       /* hash function */
        int      (*cmp)(void* item, void* curitem);   /* comparison funct */
        THashElem   *items;             /* Pointer to actual hash table    */

} THashTab;

#pragma pack()

THashTab *_hash_createtab( unsigned maxsize, unsigned long (*hash)(void*), int(*cmp)(void*,void*));
int       _hash_addsym(THashTab *tab, void *item);
void     *_hash_findsym(THashTab *tab , void *item);
void     *_hash_delsym(THashTab *tab, void *item );
int       _hash_deltab(THashTab *tab);
void      _hash_pstat(void);
int       _hash_iter_init(THashTab *tab);
void     *_hash_iter_next(void);

unsigned int FHashString (const char *str);

#endif