/*
 * Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)
 */
#include "helpdefs.h"
#include "dlmstr.h"

static char *Copyright="Copyright (C) 1996-1998 Ilya Ryzhenkov (orangy@inetlab.com)";
int Argc;
char **Argv,*token;
char *infile=0,*ename=0,*ecname=0,*dump=0,*cname=0,*sexpr=0,*stub;
char wr=0,*exp=0,*dumpexp=0,*dumpimp=0,*dumpexpdlm=0,*dallst=0,*dalout=0;
char quite=0;

int exist(const char *fname)
{
 return __file_exists(fname);
}

int valid(const char *fname)
{
 int h=open(fname, O_RDONLY | O_CREAT, S_IWUSR | S_IRUSR);
 if (h==-1) return 0;
 close(h);
 return 1;
}

void next_screen()
{
 puts("\n Press any key for next screen of help.");
 getchar();
}

void Usage()
{
 puts("\nDLM Manager (c)1996 by Ilya P. Ryzhenkov");
 puts("DLMMAN <dlmname | objname> [-option, ...]");
 puts("  -q                      print only fatal messages");
 puts("  -e <exename>            create executable from given DLM");
 puts("  -ec <exename>           create executable from given obj");
 puts("  -d <dumpfile>           dump DLM structure to <dumpfile>");
 puts("  -dx <exportfilename>    generate list of import symbols");
 puts("  -di <importfilename>    generate list of export symbols");
 puts("  -da <fname>             append list of export with DLM name to file");
 puts("  -dl <fname>[,<dalname>] generate DAL - list of needed DLMs");
 puts("                          uses DLM's import and <fname> file as input data");
 puts("  -c <dlmname>            convert object file to DLM");
 puts("  -s <symbolname>=<fname> add extra symbol to DLM with the contents of file");
 puts("  -rs <symbolname>        remove extra symbol");
 puts("  -a <stubname>           use alternate stubfile");
 puts("  -l <dlmname>|<&dalname> add an Auto-Load DLM");
 puts("                          & at begining of filename means file contains list");
 puts("  -rl <dlmname>           remove an Auto-Load DLM");
 puts("  -u <exportfilename>     use export list file instead of implicit rules");
 next_screen();
 puts("\nIf name is not specified, output file name will be the same as input with");
 puts("the following extensions for the options :");
 puts("  .DLM for -c and -s");
 puts("  .EXE for -ec and -e");
 puts("  .DMP for -d");
 puts("  .EXP for -u and -dx");
 puts("  .IMP for -di");
 puts("  .LST for -da");
 puts("  .DAL for -dl (DAL stands for Dlm Autoload List)");
 puts("\nExamples :");
 puts("  DLMMAN test.dlm -e test.exe -s _txt=t.txt");
 puts("    - Create test.exe from test.dlm with added symbol '_txt'");
 puts("      which has content of file 't.txt'");
 puts("      Leading underscore must be present in symbol name");
 puts("  DLMMAN test.o -ec test.exe -c test.dlm -a altsub.exe");
 puts("    - Create both test.exe and test.dlm from object file");
 puts("      test.o, using 'altstub.exe' as stub for test.exe");
 puts("");
 puts("  To contact author : e-mail to ilya@spy.isp.nsc.ru");
 exit(1);
}

void Errf(char *fmt,char *s)
{
 printf(fmt,s);
 puts("\nRun DLMMAN without parameters for help.");
 exit(1);
}

void Err(char *fmt)
{
 printf(fmt);
 puts("\nRun DLMMAN without parameters for help.");
 exit(1);
}

char *DupFilename(char *filename, char *newext)
{
 char *file;
 int x;
 //file=(char*)malloc(strlen(filename)+1);
 file=strdup(filename);
 x=strrchr(file,'.')-file; // index of last dot
 file=(char*)realloc(file,x+strlen(newext)+3);
 strcpy(file+x+1,newext);
 file[x+strlen(newext)+1]=0;
 return file;
}

int CheckIdent(char *name)
{
 if (!name) return 0; else if (*name!='_')
  printf("Warning! No initial underscore for symbol '%s'\n",name);
 if (!name[strspn(name,
   "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$"
    )]) return 1; else return 0;
}

#define PARM(str) if (!strcmp(Argv[i],str))
void ParseParm()
{
 int i;
 if (Argv[1][0]=='-') Err("Input file name missed\n"); else
  if (!exist(Argv[1])) Errf("Illegal input file name '%s'\n",Argv[1]);
  else infile=strdup(Argv[1]);
 for (i=2; i<Argc; i++)
 {
    PARM("-q")
     {
      quite=1;
     } else
    PARM("-e")
     {
      if (ename) Err("Duplicate -e option\n"); else

       if (i+1==Argc || Argv[i+1][0]=='-') ename=DupFilename(infile,"exe");
         else ename=Argv[++i];
     } else
    PARM("-ec")
     {
      if (ecname) Err("Duplicate -ec option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') ecname=DupFilename(infile,"exe");
         else ecname=Argv[++i];
     } else
    PARM("-c")
     {
      if (cname) Err("Duplicate -c option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') cname=DupFilename(infile,"dlm");
         else cname=Argv[++i];
     } else
    PARM("-a")
     {
      if (stub) Err("Duplicate -a option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') Err("Stubname missed in -a option");
         else stub=Argv[++i];
     } else
    PARM("-d")
     {
      if (dump) Err("Duplicate -d option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') dump=DupFilename(infile,"dmp");
         else dump=Argv[++i];
     } else
    PARM("-dx")
     {
      if (dumpexp) Err("Duplicate -dx option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') dumpexp=DupFilename(infile,"exp");
         else dumpexp=Argv[++i];
     } else
    PARM("-da")
     {
      if (dumpexpdlm) Err("Duplicate -da option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') dumpexpdlm=DupFilename(infile,"lst");
         else dumpexpdlm=Argv[++i];
     } else
    PARM("-di")
     {
      if (dumpimp) Err("Duplicate -di option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') dumpimp=DupFilename(infile,"imp");
         else dumpimp=Argv[++i];
     } else
    PARM("-dl")
     {
      sexpr=strdup(Argv[++i]);
      token=strtok(sexpr,",");
      if (!exist(token))
        Errf("No such file '%s' in -dl option",token);
        else dallst=strdup(token);
      token=strtok(0,",");
      if (!token) dalout=DupFilename(infile,"dal");
        else dalout=strdup(token);
      if (!valid(dalout))
        Errf("Output file '%s' is not valid -dl option",token);
      free(sexpr);
     } else
    PARM("-u")
     {
      if (exp) Err("Duplicate -u option\n"); else
       if (i+1==Argc || Argv[i+1][0]=='-') exp=DupFilename(infile,"exp");
         else exp=Argv[++i];
     } else
    PARM("-s")
     {
      sexpr=strdup(Argv[++i]);
      token=strtok(sexpr,"=");
      if (!CheckIdent(token))
        Errf("Invalid symbol '%s' in -s option",token);
      token=strtok(0,"=");
      if (!exist(token))
        Errf("File '%s' doesn't exist in -s option",token);
      free(sexpr);
     } else
    PARM("-l")
     {
       if (i+1==Argc || Argv[i+1][0]=='-') Err("DLM name missed in -l option");
         else i++;
     } else
    PARM("-rs")
     {
       if (i+1==Argc || Argv[i+1][0]=='-') Err("Symbol name missed in -rs option");
         else if (!CheckIdent(Argv[i+1])) Errf("Invalid symbol name %s in -rs option",Argv[i+1]);
          else i++;
     } else
    PARM("-rl")
     {
       if (i+1==Argc || Argv[i+1][0]=='-') Err("DLM name missed in -rl option");
         else if (!valid(Argv[i+1])) Errf("Invalid DLM name %s in -rl option",Argv[i+1]);
          else i++;
     } else
    Errf("Illegal parameter '%s'\n",Argv[i]);
 }
 if (ecname && dumpexpdlm) Err("Conflicting options -e and -da\n");
 if (ename && ecname) Err("Conflicting options -e and -ec\n");
 if (ename && cname) Err("Conflicting options -e and -c\n");
 if (exp && dumpexp) Err("Conflicting options -u and -dx\n");
 if (stub) if (!exist(stub)) Errf("Alternate stub '%s' doesn't exist\n",stub);
 if (ename) if (!valid(ename)) Errf("Invalid -e file '%s'\n",ename);
 if (ecname) if (!valid(ecname)) Errf("Invalid -ec file '%s'\n",ecname);
 if (cname) if (!valid(cname)) Errf("Invalid -c file '%s'\n",cname);
}

void ProcessExpressions(TDlm *dlm)
{
 char *var,*file;
 int i;
 for (i=2; i<Argc; i++)
 {
  PARM("-s")
   {
    sexpr=strdup(Argv[++i]);
    var=strtok(sexpr,"=");
    file=strtok(0,"=");
    AddSymbol(dlm,var,file);
    free(sexpr);
    wr=1;
   } else
   PARM("-l")
   {
    i++;
    if (Argv[i][0]=='&') AddDAL(dlm,Argv[i]+1); else
     AddAutoLoad(dlm,Argv[i]);
    wr=1;
   } else
   PARM("-rl")
   {
    DelAutoLoad(dlm,Argv[++i]);
    wr=1;
   } else
   PARM("-rs")
   {
    DelSymbol(dlm,Argv[++i]);
    wr=1;
   }
 }
}

int main(int argc,char **argv)
{
 TCoff *coff=0;
 TDlm  *dlm=0;
 if (argc<2) Usage();
 Argc=argc; Argv=argv;
 ParseParm();
 if (!quite) puts("\nDLM Manager (c)1996 by Ilya P. Ryzhenkov");
 if (!quite) printf("Loading input file '%s' ...\n",infile);
 if (ecname || cname)
  {
   coff=LoadCoff(infile);
   dlm=coff2dlm(coff);
   DestroyCoff(coff);
   ename=ecname;
  } else dlm=LoadDlm(infile);
  if (cname) dlm->filename=cname; else
    dlm->filename=infile;
 ProcessExpressions(dlm);
 if (exp)
 {
  if (!quite) printf("Updating EXPORT information...\n");
  UpdateExport(dlm,exp);
  wr=1;
 }

 if (dump)
  {
   if (!quite) printf("Dumping DLM information ...\n");
   DumpDlm(dlm,dump);
  }

 if (dumpexp)
  {
   if (!quite) printf("Dumping EXPORT information ...\n");
   DumpExport(dlm,dumpexp);
  }

 if (dumpexpdlm)
  {
   if (!quite) printf("Dumping EXPORT information with DLM name ...\n");
   DumpExportWithDLM(dlm,dumpexpdlm);
  }

 if (dallst)
  {
   if (!quite) printf("Generating DLM Autoload List (DAL) ...\n");
   GenerateDAL(dlm,dalout,dallst);
  }

 if (dumpimp)
  {
   if (!quite) printf("Dumping IMPORT information ...\n");
   DumpImport(dlm,dumpimp);
  }

 if (cname)
  {
   if (!quite) printf("Writing DLM file '%s' ...\n",cname);
   WriteDlm(dlm,cname,0);
  }

 if (ename)
  {
   if (!quite) printf("Writing EXE file '%s' ...\n",ename);
   MakeExe(dlm,ename,stub);
  }

 if (wr && !cname && !ename)
  {
   if (!quite) printf("Writing DLM file '%s' ...\n",infile);
   WriteDlm(dlm,infile,0);
  }
 return 0;
}
