/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** CTC.H: This file is part of the BETATRON library and can be used
 **        and/or distributed only under the terms of the GNU Library
 **        General Public License. See doc/readme.1st for details.
 */


#ifndef pl_ctc_h
#define pl_ctc_h

#include <pc.h>


struct CTCtimer
{
  public:
  // constructor
  CTCtimer();
  long getretraceticks();

  void startCTC0timer()
  {
   oldcounter=counter=readCTC0counter();
  }

  long getCTC0elapsed()
  {
   long diff;

   counter=readCTC0counter();

   if (counter>oldcounter) diff= ( (65536L-counter) + oldcounter) >>1;
    else
   diff=(oldcounter-counter) >> 1;

   oldcounter=counter;
   return diff;
  }

  private:
  unsigned short oldcounter;
  unsigned short counter;

  unsigned short readCTC0counter()
  {
	unsigned short s;
	outportb(0x43,0);
        s=inportb(0x40)+ ((unsigned short)inportb(0x40)<<8);
	return s;
  }


};



#endif
