/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** GRIDS.CC: This file is part of the BETATRON library and can be used
 **           and/or distributed only under the terms of the GNU Library
 **           General Public License. See doc/readme.1st for details.
 */



#include "world.h"
#include "grid.h"
#include <stdarg.h>


short TOworld::makegrid(unsigned char gridno)
{
 short res;

 if (gridno>=MAXGRIDSNO) return ERR_OUTOFRANGE;
 if (grids[gridno]) return ERR_GRIDMADE;
 if (! (grids[gridno]=new Tclustergrid) ) return ERR_OUTOFMEM;
 return ERR_NOERR;
}



short TOworld::destroygrid(unsigned char gridno)
{
  if (gridno>=MAXGRIDSNO) return ERR_OUTOFRANGE;
  if (!grids[gridno]) return ERR_GRIDNOTMADE;
  delete grids[gridno];
  grids[gridno]=NULL;
  return ERR_NOERR;
}






short TOworld::setgridparameters(unsigned char gridno,unsigned char l20,
				 unsigned char h20,unsigned short maxobjsno0)
{
 short res;

 if (gridno>=MAXGRIDSNO) return ERR_OUTOFRANGE;
 if (grids[gridno]) return ERR_GRIDMADE;

 if (	(res=makegrid(gridno))
     || (res=grids[gridno]->setparameters(l20,h20,maxobjsno0))
     || (res=grids[gridno]->makegrid(length<<4, height << 4,this))
    )
  {
   destroygrid(gridno);
   return res;
  }

  return ERR_NOERR;
}


//  i discovered one more bug
//  variable arguments fail if the last parameter has not
//  size of 4. 4 bytes is always the distance between 2
//  consecutive parameters despite the size of the last fix


short TOworld::definegridlists(unsigned char gridno,long first,...)
{
 short arg;
 short res;
 va_list v;


 if (gridno>=MAXGRIDSNO) return ERR_OUTOFRANGE;
 if (!grids[gridno])
 {
  if (	 (res=makegrid(gridno))
      || (res=grids[gridno]->makegrid(length<<4, height << 4,this))
     )
   {
    destroygrid(gridno);
    return res;
   }
 }

  va_start(v,first);
  grids[gridno]->addfirstlist(first);

  arg=va_arg(v,short);

  for (;arg>=0 && arg<LISTSNO;)
  {
   grids[gridno]->addlist(arg);
   arg=va_arg(v,short);
  }

  va_end(v);
  return ERR_NOERR;
}



TOobject *TOworld::gridcollision(unsigned char gridno,TOobject *o)
{
 if (gridno>=MAXGRIDSNO || !grids[gridno]) return NULL;
 return grids[gridno]->gridcollision(o);
}



short TOworld::getgridarea(unsigned char gridno,TOobject *o,
			  unsigned short &x1,unsigned short &y1,
			  unsigned short &x2,unsigned short &y2)
{
  if (gridno>=MAXGRIDSNO) return ERR_OUTOFRANGE;
  if (!grids[gridno]) return ERR_GRIDNOTMADE;

  grids[gridno]->getgridarea(o,x1,y1,x2,y2);
  return ERR_NOERR;
}



TOobject *TOworld::getgridfirst(unsigned char gridno,
				unsigned short gridx,unsigned short gridy)
{
 if (gridno>=MAXGRIDSNO || !grids[gridno]) return NULL;
 return grids[gridno]->getfirst(gridx,gridy);
}



TOobject *TOworld::getgridnext(unsigned char gridno)
{
 if (gridno>=MAXGRIDSNO || !grids[gridno]) return NULL;
 return grids[gridno]->getnext();
}






