/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** DRAWVESA.CC: This file is part of the BETATRON library and can be used
 **              and/or distributed only under the terms of the GNU Library
 **              General Public License. See doc/readme.1st for details.
 */




#include "world.h"
#include "cb.h"



void TOworld::refreshtiles1vesa()
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short tileno;	 //  ⮦ tile

  unsigned short *lay;	  // layer  餜  椞 騘
  unsigned short *lay2;   // fore layer
  unsigned short laystep=length-Xtiles;
  signed char dwx,dwy;
  char *tilere;
  unsigned short tilestep=MAXXTILES+2 - Xtiles;

  //    tile (tilex,tiley) 坜  橣 
  //    椞

  lay = Pbacklayer + ((wy*length) + wx);
  lay2 = Pforelayer + ((wy*length) + wx);

  tilere=(char *)&tilerefresh[1+(long)wy-wy0][1+(long)wx-wx0];

  for (j0=0;j0<Ytiles;j0++,lay+=laystep,lay2+=laystep,tilere+=tilestep)
   for (i0=0;i0<Xtiles;i0++,lay++,lay2++,tilere++)
   {
    if ( ! (*tilere))  continue;

    tileno= *lay;
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      M2Mcbsolid(Ptiles[tileno & 32767],0,0, 16,   bufofs, i0<<4, j0<<4,16,16);

    tileno= *lay2;
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      M2Mcbthru(Ptiles[tileno & 32767],0,0, 16,   bufofs, i0<<4, j0<<4,16,16);

    Mcb2Vcbsolid(bufofs,i0<<4,j0<<4,drawofs,i0<<4,j0<<4,16,16);
   }
}

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void TOworld::refreshtiles2vesa()
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  signed char dwx,dwy;
  char *tilere;
  unsigned short tilestep=MAXXTILES+2 - Xtiles;

  tilere=(char *)&tilerefresh[1+(long)wy-wy0][1+(long)wx-wx0];

  for (j0=0;j0<Ytiles;j0++,tilere+=tilestep)
  {
   for (i0=0;i0<Xtiles;i0++,tilere++)
    if (*tilere)
    {
      Mcb2Vcbsolid(bufofs,i0<<4,j0<<4,drawofs,i0<<4,j0<<4,16,16);
      Mcb2Vcbsolid(bufofs,i0<<4,j0<<4,backofs,i0<<4,j0<<4,16,16);
    }
  }

}


//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
void TOworld::erasespritesvesa()
{
 int i;
 TOsprite *plist,*ptmp;
 unsigned short clipx1,clipy1,clipx2,clipy2;
 unsigned short x4,y4,len4,hei4; // x: tetrades apo arxi drawofs,len4: mikos se tetrades
 unsigned short x11,y11,x12,y12;
 short res;


 x11=wx<<4;
 x12=x11+(Xlen-1);
 y11=wy<<4;
 y12=y11+(Ylen-1);


 for (i=0;i<PRIORITIESNO;i++) // to i metraei layer proteraiotitas
 {
  for (plist=(TOsprite *)priorities[i];plist;)
  {
     if (!plist->framesbit)   // an den exei frames proxora parakato
     {
       plist=(TOsprite *)plist->Pnext2;
       continue;
     }

     //an einai enrgopoiimeno to deadbit i to antikeimeno den itan orato
     //sto proigoumeno frame tote pigaine parakato

     if ( (!plist->deadbit) && (plist->oldvisbit!=VIS_INVISIBLE))
     {
      clipx1=plist->oldx;
      clipy1=plist->oldy;
      clipx2=clipx1+plist->oldlen - 1;
      clipy2=clipy1+plist->oldhei - 1;

      MACROcmplace(x11,y11,x12,y12,clipx1,clipy1,clipx2,clipy2,res);
      if ( res )
       {
	x4 =  clipx1 - (wx << 4);
	y4 =  clipy1 - (wy << 4);
	len4 = clipx2 - clipx1 + 1;
	hei4 = clipy2 - clipy1 + 1;
	// ananeose to background svinontas ta palia sprites
	Mcb2Vcbsolid( bufofs,x4,y4,  drawofs,x4,y4, len4, hei4);
       }
     }

     plist->oldvisbit=plist->visbit;
     plist->oldx=plist->clipx;	      // antegrapse stis sintetagmenes oldx,,
     plist->oldy=plist->clipy;	    // tis sintetagmenes clipping gia ton
     plist->oldlen=plist->cliplen;    // epomeno kuklo
     plist->oldhei=plist->cliphei;

     ptmp=plist;  plist=(TOsprite *)plist->Pnext2;


     // einai na diagrafei auto to sprite
     if (ptmp->deletebit)
     {
       removeobj(ptmp);      // afairese to apo ton kosmo
       delete ptmp;	     // diagrapse to
     }
     else if (ptmp->removebit)
       removeobj(ptmp);     // afairese to aplos apo ton kosmo

   }
 }

}



void  TOworld::drawallvesa()
{
  unsigned char i0,j0;		 // (i0,j0) tile  餜  ⩞ 
  unsigned short tileno,tileno2;	 //  ⮦ tile
  unsigned short *lay,*lay2;	// layer  餜  椞 騘
  unsigned short step=length-Xtiles;

  lay = Pbacklayer + wy*length + wx;
  lay2= Pforelayer + wy*length + wx;

  for (j0=0;j0<Ytiles;j0++,lay+=step,lay2+=step)
   for (i0=0;i0<Xtiles;i0++,lay++,lay2++)
   {


     tileno=(*lay);
     if (tileno != 65535)	       // 65535: min tiposeis tipota
      M2Mcbsolid(Ptiles[tileno & 32767],0,0, 16,   bufofs, i0<<4, j0<<4,16,16);

     tileno2=(*lay2);
     if (tileno2 != 65535)		// 65535: min tiposeis tipota
      M2Mcbthru(Ptiles[tileno2 & 32767],0,0, 16,   bufofs, i0<<4, j0<<4,16,16);
   }



}



void  TOworld::drawcolvesa(unsigned short startx)
{
  unsigned char j0;		 // (col,j0) tile  餜  ⩞ 
				 //  (tilex,tiley) 
  unsigned short i;
  unsigned short tileno,tileno2;	 //  ⮦ tile
  register unsigned short *lay,*lay2;	 // layers back kai fore
  short intilex;  // apo poia sintetagmeni na arxiso mesa sto tile
  short pagey;


  i = (wx<<4) + startx;   // to i se pixels
  intilex=i&15; 	  // mod 16
  i>>=4;		  // kane to i se 16ades: tilex ston kosmo

  lay = Pbacklayer+ ( (wy*length) + i);
  lay2= Pforelayer+ ( (wy*length) + i);

  for (pagey=0,j0=0;j0<Ytiles;j0++,pagey+=16)	     // 15 = 篦 囘 椞  tiles
  {
    tileno= (*lay);
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      M2Mcbsolid(Ptiles[tileno & 32767],intilex,0, 16, bufofs, startx,pagey,SCROLLCOLLEN,16);
    lay+=length; // epomeni grammi

    tileno2= (*lay2);
    if (tileno2 != 65535)	       // 65535: min tiposeis tipota
      M2Mcbthru(Ptiles[tileno2 & 32767],intilex,0, 16, bufofs, startx,pagey,SCROLLCOLLEN,16);
    lay2+=length;
  }
}




void  TOworld::drawrowvesa(unsigned short starty) //坜  tile 
{
  unsigned char i0   ;		 // (i0,row) tile  餜  ⩞ 
  unsigned short j;
				 //   橣
  unsigned short tileno,tileno2; //  ⮦ tile
  register unsigned short *lay,*lay2;	  // layer  餜  椞 騘
  short intiley;
  short pagex;



  j = (wy<<4) + starty;
  intiley = j & 15;   // mod 4
  j>>=4;    // j to tile pou antistoixei sto row ston kosmo

  lay  = Pbacklayer+ ( (j*length) + wx);
  lay2 = Pforelayer + ( (j*length) + wx);

  for (pagex=0,i0=0;i0<Xtiles;i0++,pagex+=16)
  {
    tileno=(*lay);
    if (tileno != 65535)	      // 65535: min tiposeis tipota
      M2Mcbsolid(Ptiles[tileno & 32767],0,intiley, 16, bufofs, pagex,starty,16,SCROLLROWHEI);
    lay++;

    tileno2=(*lay2);
    if (tileno2 != 65535)	       // 65535: min tiposeis tipota
      M2Mcbthru(Ptiles[tileno2 & 32767],0,intiley, 16, bufofs, pagex,starty,16,SCROLLROWHEI);
    lay2++;
  }

}



void TOworld::drawbackgroundvesa(unsigned short layer)
{
 unsigned short tileno;
 unsigned short *lay;
 unsigned short i0,j0;
 short step=length-Xtiles;
 char *fore;
 short forestep=MAXXTILES-Xtiles;
 void (*PM2Vplanar)(char *,long, unsigned short,unsigned short,
		    unsigned short,unsigned short,
		    unsigned short,unsigned short,
		    unsigned short);



  lay = layers[layer] + ((wy*length) + wx);
  fore=(char *)forerefresh[0]; // min ksexnas oti oi 2 diastaseon pinakes
			    // exoun sinexomena stoixeia kai den
			    // einai 1 diastaseis pinakes deikton

       if (layer==LAY_BACK) PM2Vplanar= M2Vplanarsolid4;
  else if (layer==LAY_FORE) PM2Vplanar= M2Vplanarthru;

  for (j0=0;j0<Ytiles;j0++,fore+=forestep,lay+=step)
   for (i0=0;i0<Xtiles;i0++,fore++,lay++)
   {
     if ( ! (*fore) ) continue;
     tileno=(*lay);
     if (tileno!=65535)
     if (tileno & 32768)
      PM2Vplanar(Ptiles[tileno & 32767],drawofs,i0<<4, j0<<4, 16, 16,	0,0,16);
   }

};



