#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "stone.h"

#if stone_elf

#include "elf.h"

int stone_load_elf (FILE *file, char *filename)
{
  #define defy(CALL) do { if ((CALL)) { stone_report ("%s", #CALL); return defeat (); } } while (0)
  stone_object obj;
  Elf32_Ehdr hdr;
  Elf32_Shdr *sh = NULL; /* (free) */
  char **dat = NULL; /* (free) */
  char *str = NULL;
  int c, i, base;

  /* Free everything allocated and return in defeat */
  int defeat (void)
  {
    stone_free_obj (&obj);
    if (sh != NULL)
      free (sh);
    if (dat != NULL)
      free (dat);
    if (str != NULL)
      free (str);
    if (dat != NULL)
    for (c = 0; c < hdr.e_shnum; c ++)
      free (dat [c]);
    sh = NULL; dat = NULL; str = NULL;
    obj.src = NULL;
    return -1;
  }
   
  char *readsection (int idx)
  {
    if (dat [idx] == NULL)
    {
      dat [idx] = malloc (sh [idx].sh_size);
      fseek (file, sh [idx].sh_offset, SEEK_SET);
      fread (dat [idx], 1, sh [idx].sh_size, file);
    }
    return dat [idx];
  }

  stone_setup ();
  stone_clear_obj (&obj);
  memset (&hdr, 0, sizeof (hdr));
  obj.user = 1;
  if ((obj.src = strdup (filename)) == NULL)
    return -1;
  defy (fseek (file, 0, SEEK_SET));
  if (fread (&hdr, 1, sizeof (hdr), file) != sizeof (hdr))
    return defeat ();
  if (hdr.e_ident [EI_MAG0] != ELFMAG0
    || hdr.e_ident [EI_MAG1] != ELFMAG1
    || hdr.e_ident [EI_MAG2] != ELFMAG2
    || hdr.e_ident [EI_MAG3] != ELFMAG3)
    return defeat ();
  defy (hdr.e_ident [EI_CLASS] != ELFCLASS32);
  defy (hdr.e_ident [EI_DATA] != ELFDATA2LSB);
  defy (hdr.e_ident [EI_VERSION] != EV_CURRENT);
  defy (hdr.e_machine != EM_386); /* Need to add new ones selectively, as they prove their workiveness */
  defy (hdr.e_shentsize != sizeof (*sh));
  defy ((stone_allot (sh, hdr.e_shnum)) == NULL);
  defy (fseek (file, hdr.e_shoff, SEEK_SET));
  defy (fread (sh, sizeof (*sh), hdr.e_shnum, file) != hdr.e_shnum);
  defy ((stone_allot (dat, hdr.e_shnum)) == NULL);

  /* Read in the section data */
  for (c = 0; c < hdr.e_shnum; c ++)
    dat [c] = NULL;
  for (c = 0; c < hdr.e_shnum; c ++)
    if (sh [c].sh_type == SHT_PROGBITS || sh [c].sh_type == SHT_NOBITS)
    {
      if (sh [c].sh_addralign > 1)
        obj.len = (obj.len + sh [c].sh_addralign - 1) / sh [c].sh_addralign * sh [c].sh_addralign;
      sh [c].sh_addr = obj.len;
      obj.len += sh [c].sh_size;
    }

   /* Now read in the symbols */
   base = obj.len;
   for (c = 0; c < hdr.e_shnum; c ++)
      if (sh [c].sh_type == SHT_SYMTAB && sh [c].sh_entsize == sizeof (Elf32_Sym))
      {
         Elf32_Sym *sym = (Elf32_Sym *) readsection (c);
         char *str = readsection (sh [c].sh_link);
         int i;
         
         obj.nsym = sh [c].sh_size / sizeof (Elf32_Sym);
         stone_allot (obj.sym, obj.nsym);

         for (i = 0; i < obj.nsym; sym ++, i ++)
         {
            obj.sym [i].name = strdup (&str [sym->st_name]);
            obj.sym [i].obj = -1;
            obj.sym [i].sym = -1;
            if (ELF32_ST_BIND (sym->st_info) == STB_GLOBAL
             && (ELF32_ST_TYPE (sym->st_info) == STT_FUNC
              || ELF32_ST_TYPE (sym->st_info) == STT_OBJECT))
               obj.sym [i].type = csst_export;
            else if (ELF32_ST_BIND (sym->st_info) == STB_GLOBAL)
               obj.sym [i].type = csst_import;
            else
               obj.sym [i].type = csst_unknown;
            if (sym->st_shndx < hdr.e_shnum)
               obj.sym [i].off = sym->st_value + sh [sym->st_shndx].sh_addr;
            else if (sym->st_shndx == 0xFFF2)
            {
               if (sym->st_value > 1)
                  obj.len = (obj.len + sym->st_value - 1) / sym->st_value * sym->st_value;
               obj.sym [i].off = obj.len;
               obj.len += sym->st_size;
            }
            else
               obj.sym [i].off = sym->st_value;
         }
      }

   obj.code = malloc (obj.len);
   memset (obj.code + base, 0, obj.len - base);
   for (c = 0; c < hdr.e_shnum; c ++)
      if (sh [c].sh_type == SHT_PROGBITS || sh [c].sh_type == SHT_NOBITS)
      {
         if (sh [c].sh_type == SHT_NOBITS)
            memset (obj.code + sh [c].sh_addr, 0, sh [c].sh_size);
         else
         {
            fseek (file, sh [c].sh_offset, SEEK_SET);
            fread (obj.code + sh [c].sh_addr, 1, sh [c].sh_size, file);
         }
      }

   /* And the links */
   for (c = 0; c < hdr.e_shnum; c ++)
      if (sh [c].sh_type == SHT_REL && sh [c].sh_entsize == sizeof (Elf32_Rel))
      {
         Elf32_Rel *rel = (Elf32_Rel *) readsection (c);
         Elf32_Sym *shsym = (Elf32_Sym *) readsection (sh [c].sh_link);
         stone_object_rel *robj;
         Elf32_Sym *sym;
         int base = 0, old;
         int i;

         base = sh [sh [c].sh_info].sh_addr;
         old = obj.nrel;
         obj.nrel += sh [c].sh_size / sizeof (*rel);
         stone_resize (obj.rel, obj.nrel);
         
         for (i = old, robj = obj.rel + old; i < obj.nrel; rel ++, i ++, robj ++)
         {
            sym = &shsym [ELF32_R_SYM (rel->r_info)];
            robj->off = rel->r_offset + base;
            robj->sym = ELF32_R_SYM (rel->r_info);
            robj->base = *(int *) &obj.code [robj->off];// + sh [sym->st_shndx].sh_addr;
            switch (ELF32_R_TYPE (rel->r_info))
            {
               case R_386_32: robj->type = csr_absolute2; break;
               case R_386_PC32: robj->type = csr_relative2; break;
               default: robj->type = csr_unknown; break;
            }
         }
      }

   for (i = 1; i < stone_nobj; i ++)
      if (stone_obj [i].user <= 0)
         break;

   if (i < stone_nobj)
      stone_obj [i] = obj;
   else
   {
      defy (stone_resize (stone_obj, stone_nobj + 1) == NULL);
      stone_obj [stone_nobj ++] = obj;
   }
   for (c = 0; c < hdr.e_shnum; c ++)
      free (dat [c]);
   free (sh);
   free (str);
   free (dat);
   return i;
}

#endif /* stone_elf */

