/* pane.h
 */

#ifndef screen_pane_header
#define screen_pane_header

#include "sheet.h"
#include <_string.h>

#define MAXIMUM_CHILDREN 32
#define DEFAULT_SHADOW_COLOUR (black_bg+gray_fg)
#define DEFAULT_BORDER_COLOUR (black_bg+white_fg)
#define DEFAULT_TITLE_COLOUR  (black_bg+bright_white_fg)
#define DEFAULT_BORDER_CHARS  single_border_chars

typedef enum
{
   vertically = 1, horizontally = 2, both_ways
}
scroll_direction_t;

extern const char * single_border_chars;
extern const char * double_border_chars;

class screen_pane : public screen_sheet
{
public:
 screen_pane( int tlx, int tly, int width, int height );
 screen_pane();
~screen_pane();

void to_top();

void show();
bool is_visible();
void hide();
bool is_invisible();

void set_title( const char * title_text );
void set_title_colour( char new_colour );

virtual void set_border( bool setting );
void set_border_colour( char new_colour );
void set_border_chars( const char * border_chars = DEFAULT_BORDER_CHARS );
void draw_border();

void set_shadow( bool setting );
void set_shadow_colour( char new_colour );
void draw_shadow();

void mouse_scroll_while( int condition,
                         int direction = both_ways );
void scroll( int amount_left, int amount_up );
void scroll_left( int cols = 1 );
void scroll_right( int cols = 1 );
void scroll_up( int rows  = 1 );
void scroll_down( int rows = 1 );

void mouse_move_while( int condition );
void move( int amount_down, int amount_right );
void move_left( int cols = 1 );
void move_right( int cols = 1 );
void move_up( int rows  = 1 );
void move_down( int rows = 1 );
void move_to( int x, int y );

virtual void adopt( screen_pane & new_child );

screen_pane * top_child_under( int x, int y );
screen_pane * top_child();
screen_pane * child( int index );
screen_pane & parent();

void draw_children();
void child_to_top( screen_pane & new_top_child );

int designated_quit_key;

virtual int take_control() { return 0; }
virtual int process_key( int keystroke ) { return keystroke; }
virtual int process_mouse() { return 0; }

private:
virtual void refresh_image();

void add_child( screen_pane & new_child );
void remove_child( screen_pane & unwanted_child );

screen_pane * _parent;
screen_pane * _child[MAXIMUM_CHILDREN];
int    _child_count;
int    _active_child;
bool   _visible;
bool   _shadow_on;
bool   _border_on;
char   _vertical_bar, _horizontal_bar;
char   _tl_corner, _tr_corner, _bl_corner, _br_corner;
char   _left_bookend, _right_bookend;
char   _shadow_colour;
char   _border_colour;
char   _title_colour;
String _title;

friend void draw_all_windows();
};

extern screen_pane desktop;

#endif
