#ifndef keyboard_object_header

#include "scancode.h"

#define shift_pressed           (right_shift_pressed|left_shift_pressed)

#define right_shift_pressed     0x0001
#define left_shift_pressed      0x0002
#define control_pressed         0x0004
#define alt_pressed             0x0008

#define scroll_lock_locked      0x0010
#define num_lock_locked         0x0020
#define caps_lock_locked        0x0040
#define insert_locked           0x0080

#define left_control_pressed    0x0100
#define left_alt_pressed        0x0200
#define right_control_pressed   0x0400
#define right_alt_pressed       0x0800

#define scroll_lock_pressed     0x1000
#define num_lock_pressed        0x2000
#define caps_lock_pressed       0x4000
#define sysreq_pressed          0x8000

class keyboard_object
{
public:
 keyboard_object();
~keyboard_object();

void set_repeat_rate( int rate = 0, int delay = 0 );

unsigned  pressed();
unsigned  get();
operator int () { return _scan_code; }

unsigned  scan_code();
char      ascii_code();
char      key_code();
unsigned  pure();

private:
unsigned _scan_code;
};

unsigned purify( unsigned scan_code );
unsigned shift_status_word();


extern keyboard_object key;

#define keyboard_object_header
#endif
