/* Simple JPEG Like Codec, v1.04 (Tom St Denis) */
#ifndef PIC_H_
#define PIC_H_

#include <math.h>
#include <stdlib.h>
#include <allegro.h>

/* This is the quality parameter 1=best, higher values = lower quality */
extern long jpg_quality;

#define HIGH_QUALITY    1
#define MED_QUALITY     3
#define LOW_QUALITY     7

/* Saves a picture, the picture must be a multiple of 8x8, i.e 32x32 is ok
 * while 32x17 is not.  Only truecolor pictures are used (pal is provided to
 * make the interface standard)
 */
int save_bitmap_pic(char *name, BITMAP *bmp, RGB *pal);

/* Loads a picture */
BITMAP *load_bitmap_pic(char *name, RGB *pal);

#define C8_1R   0.49039264020161522456
#define C8_1I   0.09754516100806413392
#define C8_2R   0.46193976625564337806
#define C8_2I   0.19134171618254488586
#define C8_3R   0.41573480615127261854
#define C8_3I   0.27778511650980111237
#define C8_4R   0.35355339059327376220
#define W8_4R   0.70710678118654752440

#endif
