/*
	Copyright (C) 2001 Achilleas Margaritis

	MX-Windows 2.0 window system for DJGPP + Allegro

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	Contact : axilmar@b-online.gr
*/


#include "allegro.h"


/* DJGPP stuff */
#ifdef __DJGPP__


/* locks events */
void _lock_events()
{
	asm("cli");
}


/* unlocks events */
void _unlock_events()
{
	asm("sti");
}


/* WIN32 stuff */
#elif WIN32


#include <stdio.h>
#include "winalleg.h"


/* a mutex to lock stuff */
static HANDLE _mutex = NULL;


/* clean up action */
static void _cleanup(void)
{
	if (_mutex) {
		ReleaseMutex(_mutex);
		CloseHandle(_mutex);
		_mutex = NULL;
	}
}


/* creates a mutex if needed */
static INLINE void _create_mutex()
{
	char name[40];

	if (_mutex) return;
	sprintf(name, "_mxwin_%p", GetCurrentProcess());
	_mutex = CreateMutex(NULL, FALSE, name);
	atexit(_cleanup);
}


/* locks events */
void _lock_events()
{
	_create_mutex();
	if (!_mutex) return;
	WaitForSingleObject(_mutex, INFINITE);
}


/* unlocks events */
void _unlock_events()
{
	ReleaseMutex(_mutex);
}


#endif

