//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Radio button object
//----------------------------------------------------------------------------
// Constructor
radio_button_object::radio_button_object (const char *tex, const int grou, const bool squa)
   :button_object(tex),
   group(grou),
   square(squa)
   {
   set_d1(group);

   // Setup the defaults
   set_x(100);
   set_y(100);
   set_h(text_height(font));
   set_w(text_length(font,(unsigned char*)text) + 2*h());
   }
//----------------------------------------------------------------------------
// Destructor
radio_button_object::~radio_button_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Tell the object to draw itself
void radio_button_object::msg_draw (void)
   {
   _draw_radio_button_object(text,
                             x(), y(), h(),
                             square,
                             selected(),
                             disabled(), has_focus(),
                             color ? color->fore() : degui_fore_color,
                             color ? color->back() : degui_back_color,
                             color ? color->select() : degui_select_color,
                             color ? color->deselect() : degui_deselect_color,
                             color ? color->disable() : degui_disable_color,
                             color ? color->light_shad() : degui_light_shad_color,
                             color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
   }
//----------------------------------------------------------------------------
// Tell the object that a shortcut key was pressed
void radio_button_object::msg_key (void)
   {
   parent()->dialog_message(MSG_RADIO,group);
   select();
   }
//----------------------------------------------------------------------------
// Tell the object that a shortcut key was pressed
void radio_button_object::msg_radio (const int c)
   {
   // Possible disable if another radio from our group has
   // been selected
   if(c==group) deselect();
   }
//----------------------------------------------------------------------------

