//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Simple object to draw a progress bar
//----------------------------------------------------------------------------
// Constructor
progress_bar_object::progress_bar_object (const bool showtext, const float sc = 100.)
   :
   _scale(sc),
   _progress(0),
   _showtext(showtext)
   {
   set_x(100);
   set_y(100);
   set_w(100);
   set_h(text_height(font)+4);
   }
//----------------------------------------------------------------------------
// Destructor
progress_bar_object::~progress_bar_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Draw the bitmap maybe
void progress_bar_object::msg_draw (void)
	{
   _draw_progressbar(x(),y(),w(),h(),
                     _showtext,
                     _progress,
                     _scale,
                     disabled(),
                     color ? color->fore() : degui_fore_color,
                     color ? color->select() : degui_select_color,
                     color ? color->deselect() : degui_deselect_color,
                     color ? color->disable() : degui_disable_color,
                     color ? color->light_shad() : degui_light_shad_color,
                     color ? color->dark_shad() : degui_dark_shad_color);
   _redraw = false;
	}

//----------------------------------------------------------------------------

