//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Base drawing stuff for button object
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Tell the button to draw itself
void _draw_button_object (const char* text,
                          const int selected,
                          const int x, const int y, const int w, const int h,
                          const int disabled, const int has_focus,
                          const int fore,
                          const int select, const int deselect,
                          const int disable,
                          const int light_shad, const int dark_shad)
   {
   int x1 = x;
   int y1 = y;
   int x2 = x1+w-1;
   int y2 = y1+h-1;
   int txtlen  = degui_strlen((char*)text);
   int text_x  = (x1+x2+1)/2-txtlen/2;
   int text_y  = (y1+y2+1)/2-text_height(font)/2;
   int c_left  = light_shad;
   int c_right = dark_shad;
   int c_mid   = deselect;
   int c_text  = fore;

   // Should the button be displayed as button down?
   if(selected)
      {
      c_left  = dark_shad;
      c_right = light_shad;
      c_mid   = select;
      text_x  += 1;
      text_y  += 1;
      }

   // Draw the button...
   draw_3d_frame(screen,x1+1,y1+1,x2-1,y2-1,c_mid,c_left,c_right);

   // Is the button disabled?
   if(disabled) c_text = disable;

   // Print the text
   text_mode(c_mid);
   degui_textout(screen,(char*)text,text_x,text_y,fore,0);

   // Display focus frame?
   if(has_focus) draw_dotted_rect(screen,text_x-2,text_y-2,text_x+txtlen+1,text_y+text_height(font)+1,fore);

   // Black frame around the button
   rect(screen,x1,y1,x2,y2,fore);
   }
//----------------------------------------------------------------------------

