//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"

//----------------------------------------------------------------------------
// Here are the main DEGUI default colors
int degui_fore_color = 0;
int degui_mid_color = 1;
int degui_back_color = 2;
int degui_light_shad_color = 3;
int degui_dark_shad_color = 4;
int degui_select_color = 5;
int degui_deselect_color = 6;
int degui_disable_color = 7;

// Here is a routine to set the default C object colors
void set_default_object_colors (const int fg, const int mi, const int bg, const int ls, const int ds, const int se, const int de, const int di)
   {
   // Set the default colors
   RGB cf  = DEFAULT_COLOR_FORE;
   RGB cm  = DEFAULT_COLOR_MID;
   RGB cb  = DEFAULT_COLOR_BACK;
   RGB cl  = DEFAULT_COLOR_LIGHT_SHAD;
   RGB cd  = DEFAULT_COLOR_DARK_SHAD;
   RGB cs  = DEFAULT_COLOR_SELECT;
   RGB cds = DEFAULT_COLOR_DESELECT;
   RGB cdi = DEFAULT_COLOR_DISABLE;

   set_color(fg,&cf);
   set_color(mi,&cm);
   set_color(bg,&cb);
   set_color(ls,&cl);
   set_color(ds,&cd);
   set_color(se,&cs);
   set_color(de,&cds);
   set_color(di,&cdi);

   degui_fore_color = fg;
   degui_mid_color = mi;
   degui_back_color = bg;
   degui_light_shad_color = ls;
   degui_dark_shad_color = ds;
   degui_select_color = se;
   degui_deselect_color = de;
   degui_disable_color = di;
   }
// Reset the default colors
void reset_default_object_colors (const int force)
   {
   RGB f  = DEFAULT_COLOR_FORE;
   RGB m  = DEFAULT_COLOR_MID;
   RGB b  = DEFAULT_COLOR_BACK;
   RGB l  = DEFAULT_COLOR_LIGHT_SHAD;
   RGB d  = DEFAULT_COLOR_DARK_SHAD;
   RGB s  = DEFAULT_COLOR_SELECT;
   RGB ds = DEFAULT_COLOR_DESELECT;
   RGB di = DEFAULT_COLOR_DISABLE;

   int fc = makecol8(f.r*4,f.g*4,f.b*4);
   int fm = makecol8(m.r*4,m.g*4,m.b*4);
   int fb = makecol8(b.r*4,b.g*4,b.b*4);
   int fl = makecol8(l.r*4,l.g*4,l.b*4);
   int fd = makecol8(d.r*4,d.g*4,d.b*4);
   int fs = makecol8(s.r*4,s.g*4,s.b*4);
   int fds = makecol8(ds.r*4,ds.g*4,ds.b*4);
   int fdi = makecol8(di.r*4,di.g*4,di.b*4);

   if(force)
      {
      set_color(fc,&f);
      set_color(fm,&m);
      set_color(fb,&b);
      set_color(fl,&l);
      set_color(fd,&d);
      set_color(fs,&s);
      set_color(fds,&ds);
      set_color(fdi,&di);
      }
   set_default_object_colors(fc,fm,fb,fl,fd,fs,fds,fdi);
   }
//----------------------------------------------------------------------------

