//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include <string.h>

//----------------------------------------------------------------------------
// Simple object draws a bitmap
//----------------------------------------------------------------------------
// Constructor
bitmap_object::bitmap_object (BITMAP* bit)
   :b(bit),
   allocated(false)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
	set_w(100);
   set_h(100);
   }
bitmap_object::bitmap_object (const char *filename)
   :b(NULL),
   allocated(false)
   {
   // Setup the defaults
   set_x(100);
   set_y(100);
	set_w(100);
   set_h(100);

   // Find the type of file it is and load it
  	PALETTE pal;
   b = load_bitmap((char*)filename,pal);

   // Remember if we have allocated the bitmap or not so we can delete it
   if(b!=NULL)
      {
      allocated = true;

      // The size of the bitmap
      set_w(b->w);
      set_h(b->h);
      }
   }
//----------------------------------------------------------------------------
// Destructor
bitmap_object::~bitmap_object (void)
   {
   if(allocated==true) destroy_bitmap(b);
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Draw the bitmap maybe
void bitmap_object::msg_draw (void)
	{
   if(b!=NULL) blit(b, screen, 0, 0, x(), y(), w(), h());
   _redraw = false;
	}

//----------------------------------------------------------------------------

