indexing
    description    : "Allegro con Eiffel: joystick_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : joystick_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class JOYSTICK_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        i : INTEGER
    do

--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if

        -- Check whether the mouse is installed
        if not joystick.installed then
            crash_with_message("No joystick detected.")
        end  -- if


--------------------------------------------------- Joystick routines

        -- Calibrate the centre position
        io.put_string("%NPlease move the joystick to the centre and press a button...")
        io.flush

        from
        until
            joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        from
        until
            not joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        joystick.calibrate_centre


        -- Calibrate the top left position
        io.put_string("%NPlease move the joystick to the top left and press a button...")
        io.flush

        from
        until
            joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        from
        until
            not joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        joystick.calibrate_top_left


        -- Calibrate the bottom right position
        io.put_string("%NPlease move the joystick to the bottom right and press a button...")
        io.flush

        from
        until
            joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        from
        until
            not joystick.button1_pressed
        loop
            joystick.poll
        end  -- from

        joystick.calibrate_bottom_right


        -- Now display the joystick coordinates
        from
            i := 0
        until
            i = num_iterations
        loop
            i := i + 1
            joystick.poll
            io.put_character('%N')
            io.put_integer(joystick.x_position)
            io.put_character(',')
            io.put_integer(joystick.y_position)

            if joystick.button1_pressed then
                io.put_string(" Btn1")
            end  -- if

            if joystick.button2_pressed then
                io.put_string(" Btn2")
            end  -- if

            io.flush
        end  -- from
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the allegro error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class JOYSTICK_TEST
