indexing
    description    : "Allegro con Eiffel: flic objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : flic
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class FLIC


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    make(flic_filename : STRING) is
    -- Create a new fli/flc animation from the specified file
    require
        ace_initialised      : info.ace_initialised
        filename_is_valid    : flic_filename /= Void and then
                               ace_file_tools.exists(flic_filename) and then
                               (ace_file_tools.extension(flic_filename).same_as("FLI") or
                                ace_file_tools.extension(flic_filename).same_as("FLC"))
    do
        if is_valid then
            discard
        end  -- if

        filename.copy(fli_filename)
    ensure
        is_valid          : is_valid
        filename_is_valid : filename /= Void and then
                            filename.is_equal(fli_filename)
        data_is_void      : data.is_void
    end  -- feature make


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a fli/flc from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid          : is_valid
        data_is_valid     : data.is_not_void
        filename_is_empty : filename.count = 0
    end  -- feature make_from_external


------------------------------------------------------ Internal features (FLIC)
feature { FLIC }

    data     : POINTER

    filename : STRING is
    -- Allocate a string to hold the filename of the FLI/FLC
    once
        !!Result.make(256)
    end  -- feature filename


------------------------------------------------------ Internal features (NONE)
feature { NONE }

    ace_file_tools : ACE_FILE_TOOLS


------------------------------------------------------ FLIC features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this flic is valid or not
    do
        Result := (filename.count /= 0 and data.is_void) or
                  (filename.count  = 0 and data.is_not_void)
    end  -- feature is_valid


    discard is
    -- Discard this FLIC
    require
        ace_initialised      : info.ace_initialised
        is_valid             : is_valid
    do
        filename.clear
        c_inline_c("if(C->_data){free(C->_data);C->_data=NULL;}")
    ensure
        not_valid         : not is_valid
        filename_is_empty : filename.count = 0
        data_is_not_valid : data.is_void
    end  -- feature discard


    play(bitmap : BITMAP) is
    -- Play this FLIC on the specified bitmap
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        is_valid             : is_valid
    local
        p1 : POINTER
        p2 : POINTER
    do
        if filename.count = 0 then
            p2 := bitmap.data
            c_inline_c("play_memory_fli(C->_data,_p2,0,NULL);")
        else
            p1 := filename.to_external
            p2 := bitmap.data
            c_inline_c("play_fli(_p1,_p2,0,NULL);")
        end  -- if
    end  -- feature play


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies (data.is_not_void or filename.count /= 0) and
                  not is_valid implies (data.is_void or filename.count = 0)


end  -- class FLIC
