indexing
    description    : "Allegro game programming library: keypress objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : keypress
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class KEYPRESS


creation { ANY }
    make


creation { KEYBOARD }
    make_from_readkey_code


------------------------------------------------------ Creation features (ANY)
feature { ANY }

    make(scode : SCANCODE; char : CHARACTER) is
    -- Create a new keypress from a character
    require
        scode_is_valid : scode /= Void
        consistency    : (character.code = 0 and scode.code /= 0) or
                         (scode.code = 0 and character.code /= 0) or
                         scode.to_character = character           or
                         scode.to_shifted_character = character
    do
        scancode  := scode
        character := char
    end  -- feature make_from_character


------------------------------------------------------ Creation features (KEYBOARD)
feature { KEYBOARD }

    make_from_readkey_code(readkey_code : INTEGER) is
    -- Create a new keypress object from the result of a call to readkey
    local
        scode : INTEGER
    do
        character := ' '

        c_inline_c("_scode=(a1&0x0000FF00)>>8;")
        c_inline_c("C->_character=(char)(a1&0x00FF);")

        !!scancode.make(scode)
    ensure
        scancode_is_valid : scancode /= Void
    end  -- feature make_from_readkey_code


------------------------------------------------------ Keypress features
feature { ANY }

    -- The scancode of the key that was pressed (may be 0)
    scancode : SCANCODE


    -- The ascii character that was pressed (may be 0)
    character : CHARACTER


------------------------------------------------------ Class invariant
invariant

    scancode_is_valid  : scancode /= Void
    scancode_is_action : scancode.is_action
--    consistency        : (character.code = 0 and scancode.code /= 0) or
--                         (scancode.code = 0 and character.code /= 0) or
--                         scancode.to_character = character           or
--                         scancode.to_shifted_character = character


end  -- class KEYPRESS
