indexing
    description    : "Allegro con Eiffel: font objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : font
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class FONT


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make

creation { DATAFILE }
    make_from_external


------------------------------------------------------ Creation features
feature { ANY }

    make is
    -- Create a new font (defaults to the 8x8 BIOS font)
    require
        ace_initialised        : info.ace_initialised
    do
        if is_valid then
            discard
        end  -- if

        c_inline_c("C->_data=font;")
    ensure
        is_valid : is_valid
    end  -- feature make


------------------------------------------------------ Creation features (DATAFILE)
feature { DATAFILE }

    make_from_external(p : POINTER) is
    -- Create a font from a C pointer
    require
        ace_initialised : info.ace_initialised
        p_is_valid      : p.is_not_void
    do
        if is_valid then
            discard
        end  -- if

        data := p
    ensure
        is_valid : is_valid
    end  -- feature make_from_external


------------------------------------------------------ Internal features (FONT)
feature { FONT, BITMAP }

    data : POINTER


------------------------------------------------------ Font features
feature { ANY }

    is_valid : BOOLEAN is
    -- Indicates whether this bitmap is valid or not
    do
        Result := data.is_not_void
    end  -- feature is_valid


    discard is
    -- Discard this font
    require
        ace_initialised : info.ace_initialised
        is_valid        : is_valid
    local
        p : POINTER
    do
        c_inline_c("_p=font;")

        if data /= p then
            c_inline_c("destroy_font((FONT *)(C->_data));")
        end  -- if

        c_inline_c("C->_data=NULL;")
    ensure
        not_valid : not is_valid
    end  -- feature discard


    length(string : STRING) : INTEGER is
    -- Calculate the length of the specified string in this font
    local
        p : POINTER
    do
        p := string.to_external
        c_inline_c("R=text_length(C->_data,_p);")
    end  -- feature length


    height : INTEGER is
    -- Calculate the height of the specified string in this font
    do
        c_inline_c("R=text_height(C->_data);")
    end  -- feature height


------------------------------------------------------ Class invariant
invariant

    consistency : is_valid implies data.is_not_void and
                  not is_valid implies data.is_void


end  -- class FONT
