/*
 * SERIAL.C - Contains serial I/O functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _SERIAL_CC_

#include "serial.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

#define ENTRIES 6

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 unsigned short serio[4];

 // Create output file.
 if ((fp = fopen("serial.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nSERIAL PORT(S) INFORMATION :\n\n");

 // Get Serial ports information.
 dosmemget(0x400, 8, (char *)serio);
 sprintf(output, "\tSerial Port 1 installed        : %s\n",
		(serio[0]) ? "Yes" : "No");
 writestring(output);
 if (serio[0]) {
	writestring("\tSerial Port Name               : COM1\n");
	sprintf(output, "\tPort ID                        : %Xh\n", serio[0]);
	writestring(output);
 }

 sprintf(output, "\tSerial Port 2 installed        : %s\n",
		(serio[1]) ? "Yes" : "No");
 writestring(output);
 if (serio[1]) {
	writestring("\tSerial Port Name               : COM2\n");
	sprintf(output, "\tPort ID                        : %Xh\n", serio[1]);
	writestring(output);
 }

 sprintf(output, "\tSerial Port 3 installed        : %s\n",
		(serio[2]) ? "Yes" : "No");
 writestring(output);
 if (serio[2]) {
	writestring("\tSerial Port Name               : COM3\n");
	sprintf(output, "\tPort ID                        : %Xh\n", serio[2]);
	writestring(output);
 }

 sprintf(output, "\tSerial Port 4 installed        : %s\n",
		(serio[3]) ? "Yes" : "No");
 writestring(output);
 if (serio[3]) {
	writestring("\tSerial Port Name               : COM4\n");
	sprintf(output, "\tPort ID                        : %Xh\n", serio[3]);
	writestring(output);
 }

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(&__dj_stdout);
	fclose(&__dj_stderr);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

// The main function.
int main()
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
