/*
 * INTRINFO.CPP - Contains interrupt information functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _INTRINFO_CC_

#include "intrinfo.h"

char intrinfo[][80] =
{
     "Divide error             ",
     "Debug Condition          ",
     "Non-Maskable Interrupt   ",
     "Breakpoint               ",
     "Overflow                 ",
     "Bounds Check/PrtSc.      ",
     "Invalid Opcode           ",
     "Reserved                 ",
     "IRQ0 (System Timer)      ",
     "IRQ1 (Keyboard)          ",
     "IRQ2 (Cascade to PIC-II) ",
     "IRQ3 (COM2)              ",
     "IRQ4 (COM1)              ",
     "IRQ5 (Reserved)          ",
     "IRQ6 (Diskette Control)  ",
     "IRQ7 (LPT1)              ",
     "Video                    ",
     "Equipment Configuration  ",
     "Base Memory Size         ",
     "FDD/HDD Routines         ",
     "Serial Communication     ",
     "Extended Services        ",
     "Keyboard                 ",
     "Parallel Printer(s)      ",
     "ROM Basic                ",
     "BootStrap loader         ",
     "RTC & other services     ",
     "BIOS Break Handler       ",
     "Timer Tick               ",
     "Video Parameter Table    ",
     "Diskette Parameter Table ",
     "Graphic Character Set    ",
     "Program Termination      ",
     "DOS Services             ",
     "Terminate Address        ",
     "DOS Break Handler        ",
     "Critical Error Handler   ",
     "Absolute Disk Read       ",
     "Absolute Disk Write      ",
     "Terminate & Stay Resident",
     "DOS Idle Interrupt       ",
     "Direct Character Echo    ",
     "DOS Network              ",
     "Reserved for DOS         ",
     "Cloaking                 ",
     "Alt. Multiplex Interrupt ",
     "COMMAND.COM Back Door    ",
     "Multiplex Interrupt      ",
     "Reserved for DOS         ",
     "Reserved for DOS         ",
     "Reserved for DOS         ",
     "Mouse Driver             ",
     "Floating Point Emulation ",
     "Overlay Manager          ",
     "Diskette BIOS Revector   ",
     "Fixed Disk Parameters    ",
     "Video BIOS Revector      ",
     "EGA/VGA Font Table       ",
     "Novell Netware API       ",
     "Reserved                 ",
     "Fixed Disk Parameters    ",
     "SQL Engine API           ",
     "Cordless KBD translation ",
     "Non-KBD translation table",
     "User Alarm Handler       ",
     "Virtual DMA Specification",
     "Reserved                 ",
     "Reserved for user        ",
     "Reserved for user        ",
     "Reserved for user        ",
     "Reserved for user        ",
     "Novell Netware           ",
     "Reserved for user        ",
     "Reserved for user        ",
     "Expanded Memory Manager  ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved for VGA         ",
     "Reserved                 ",
     "Reserved                 ",
     "IRQ8 (Real Time Clock)   ",
     "IRQ9 (Reserved)          ",
     "IRQ10 (Reserved)         ",
     "IRQ11 (Reserved)         ",
     "IRQ12 (Reserved)         ",
     "IRQ13 (Coprocessor)      ",
     "IRQ14 (Fixed Disk)       ",
     "IRQ15 (Reserved)         ",
     "Reserved                 ",
     "Reserved                 ",
     "Novell Netware           ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved                 ",
     "Reserved for BASIC       ",
     "Reserved for Interpreter ",
     "Reserved for user        "
};

int errflag = 0;
FILE *fp;
char cmdline[20];
char output[256];
unsigned short dossegs[10];

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

void writeintrinfo()
{
 union REGS regs;
 struct SREGS segs;
 int f,g,result;
 unsigned seg,off,emmseg;
 char owner[40], name[9], lastblock[9]="A:      ";
 int flags,i,temp;

 // To get device driver list.
 regs.h.ah = 0x52;
 segread(&segs);
 int86x(0x21, &regs, &regs, &segs);
  regs.x.bx += 0x22; // Assume DOS version > 2.

 do {
    flags = peek(segs.es, regs.x.bx + 4);
    for(i=0;i<=8;i++)
    name[i] = peekb(segs.es, regs.x.bx + 10 + i);
    name[8] = '\0';

    if (!(flags & 0x8000)) {
       if (lastblock[0] == 'A') dossegs[1] = segs.es;
       lastblock[0]++;
    }
    else {
	 if (!strnicmp(name, "nul", 3)) dossegs[0] = segs.es;
	 else if (!strnicmp(name, "con", 3)) dossegs[2] = segs.es;
	 else if (!strnicmp(name, "clock$", 6)) dossegs[3] = segs.es;
	 else if (!strnicmp(name, "com1", 4)) dossegs[4] = segs.es;
	 else if (!strnicmp(name, "lpt1", 4)) dossegs[5] = segs.es;
	 else if (!strnicmp(name, "prn", 3)) dossegs[6] = segs.es;
	 else if (!strnicmp(name, "aux", 3)) dossegs[7] = segs.es;
	 else if (!strnicmp(name, "config$", 7)) dossegs[8] = segs.es;
    }
    temp = segs.es;
    segs.es = peek(segs.es, regs.x.bx + 2);
    regs.x.bx = peek(temp, regs.x.bx);

 } while (regs.x.bx != 0xffff);

 emmseg = peek(0, 0x67 * 4 + 2);
 writestring("Interrupt #         Explanation             ISR Offset     Owner\n");
 writestring("===========         ===========             ==========     =====\n\n");

 for(f=0;f<=255;f++)
 {
  off = peek(0, f * 4);
  seg = peek(0, f * 4 + 2);

  for(g = 0; g <= 8; g++)
  {
   if ((dossegs[g] == seg) && (seg)) {
      strcpy(owner, "DOS");
      break;
   }
  }
  if (g == 9) {
     if ((!seg) && (!off)) strcpy(owner, "Unused");
     else if (((unsigned long)seg * 0x10 + off) >= 0xa0000)
						strcpy(owner, "BIOS");
     else strcpy(owner, "Unknown");
     if ((emmseg) && (seg == emmseg)) strcpy(owner, "EMM386");
  }
  if (f <= 0x33) sprintf(output, " INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[f], seg, off, owner);
  else if (f <= 0x3e) sprintf(output," INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[0x34], seg, off, owner);
  else if (f <= 0x4b) sprintf(output, " INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[f - 0x3f + 0x35], seg, off, owner);
  else if (f <= 0x5f) sprintf(output, " INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[0x42], seg, off, owner);
  else if (f <= 0x7f) sprintf(output," INT %02Xh         %s  %04X:%04X      %s",
     f,intrinfo[f - 0x60 + 0x43], seg, off, owner);
  else if (f <= 0x85) sprintf(output, " INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[0x63], seg, off, owner);
  else if (f <= 0xf0) sprintf(output, " INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[0x64], seg, off, owner);
  else sprintf(output," INT %02Xh         %s  %04X:%04X      %s",
     f, intrinfo[0x65], seg, off, owner);
  writestring(output);
  writestring("\n");
 }
}

int sysinfo()
{
 // Create output file.
 if ((fp = fopen("intrinfo.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 // Get Interrupts information.
 writeintrinfo();

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

int main(int argc, char **argv)
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}