/*
 * IDECD.CPP - Contains CDROM functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _IDECD_CC_

#include "idecd.h"

int errflag = 0;
FILE *fp;
char cmdline[20];
char output[256];
char idename[256];
unsigned long cd_info;
unsigned short portid, select;
char *ata_info_ptr = (char  *)&ata_info;

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

void writecdinfo()
{
	int i, temp;
	unsigned char *ptr = (unsigned char *)&idecd_info_block;
	unsigned short *bufptr;

	// Write a newline to indicate new IDE CD.
	writestring("\n");

	// Convert the reverse order names.
	for(i = 0x14; i < 0x5d; i += 2)
	{
		temp = ptr[i + 1];
		ptr[i + 1] = ptr[i];
		ptr[i] = temp;
	}

	// Write information only if IDE CDROM is installed.
	for(i = 0x36; i <= 0x5d; i++)
	idename[i - 0x36] = ptr[i];
	idename[i - 0x36] = 0;
	sprintf(output, "\tIDE CDROM Identification                : %s\n",
		idename);
	writestring(output);

	// Close tray.
	ata_info_ptr[0] = 00;
	ata_info_ptr[1] = 0xff;
	ata_info_ptr[2] = 0xff;
	ata_info_ptr[3] = 0x1b;
	ata_info_ptr[4] = 0;
	ata_info_ptr[5] = 0;
	ata_info_ptr[6] = 0;
	ata_info_ptr[7] = 3;
	ata_info_ptr[8] = 0;
	ata_info_ptr[9] = 0;
	ata_info_ptr[10] = 0;
	ata_info_ptr[11] = 0;
	ata_info_ptr[12] = 0;
	ata_info_ptr[13] = 0xf4;
	ata_info_ptr[14] = 1;
	cd_info = get_ide_cd_ata_info(portid, select);

	delay(2000);

	// Write out internal name.
	// Setup ATAPI information.
	ata_info_ptr[0] = 0;
	ata_info_ptr[1] = 0x24;
	ata_info_ptr[2] = 0;
	ata_info_ptr[3] = 0x12;
	ata_info_ptr[4] = 0;
	ata_info_ptr[5] = 0;
	ata_info_ptr[6] = 0;
	ata_info_ptr[7] = 0x24;
	ata_info_ptr[8] = 0;
	ata_info_ptr[9] = 0;
	ata_info_ptr[10] = 0;
	ata_info_ptr[11] = 0;
	ata_info_ptr[12] = 0;
	ata_info_ptr[13] = 0;
	ata_info_ptr[14] = 0;
	cd_info = get_ide_cd_ata_info(portid, select);
	if (!cd_info) return;
	for(i = 8; i <= 15; i++)
	idename[i - 8] = ptr[i];
	idename[i - 8] = 0;
	sprintf(output, "\tCDROM Vendor Name                       : %s\n",
		idename);
	writestring(output);

	for(i = 16; i <= 31; i++)
	idename[i - 16] = ptr[i];
	idename[i - 16] = 0;
	sprintf(output, "\tCDROM Internal Name                     : %s\n",
		idename);
	writestring(output);

	for(i = 32; i <= 35; i++)
	idename[i - 32] = ptr[i];
	idename[i - 32] = 0;
	sprintf(output, "\tHardware Revision                       : %s\n",
		idename);
	writestring(output);
	writestring("\n");

	// Setup ATAPI information.
	ata_info_ptr[0] = 0;
	ata_info_ptr[1] = 0x1d;
	ata_info_ptr[2] = 0;
	ata_info_ptr[3] = 0x5a;
	ata_info_ptr[4] = 0;
	ata_info_ptr[5] = 0xaa;
	ata_info_ptr[6] = 0;
	ata_info_ptr[7] = 0;
	ata_info_ptr[8] = 0;
	ata_info_ptr[9] = 0;
	ata_info_ptr[10] = 0;
	ata_info_ptr[11] = 0x1d;
	ata_info_ptr[12] = 0;
	ata_info_ptr[13] = 0;
	ata_info_ptr[14] = 0;
	cd_info = get_ide_cd_ata_info(portid, select);
	if (!cd_info) return;

	// We have more information.
	sprintf(output, "\tAudio Play                              : %s\n",
		(ptr[12] & 1) ? "Supported" : "Not Supported");
	writestring(output);
	sprintf(output, "\tXA Commands                             : %s\n",
		(ptr[12] & 2) ? "Supported" : "Not Supported");
	writestring(output);
	sprintf(output, "\tMode 2 Form 1 Sector                    : %s\n",
		(ptr[12] & 0x10) ? "Supported" : "Not Supported");
	writestring(output);
	sprintf(output, "\tMode 2 Form 2 Sector                    : %s\n",
		(ptr[12] & 0x20) ? "Supported" : "Not Supported");
	writestring(output);
	sprintf(output, "\tMulticompression CD                     : %s\n",
		(ptr[12] & 0x40) ? "Supported" : "Not Supported");
	writestring(output);
	sprintf(output, "\tLoad/Eject                              : %s\n",
		(ptr[14] & 8) ? "Supported" : "Not Supported");
	writestring(output);

	temp = (ptr[14] >> 5) & 7;
	sprintf(output, "\tLoading Mechanism                       : %s\n",
				(!temp) ? "Caddy type" :
				(temp == 1) ? "Tray type" :
				(temp == 2) ? "Popup type" :
				(temp == 3) ? "Reserved" :
				(temp == 4) ? "Changer(Individual)" :
				(temp == 5) ? "Changer(Cartridge)" :
				(temp == 6) ? "Reserved" :
				"Reserved");
	writestring(output);
	sprintf(output, "\tCDROM Data Transfer rate (Max)          : %u KB/sec\n",
		((unsigned)ptr[16] * 256 + (unsigned)ptr[17]));
	writestring(output);
/*	printf("Current data transfer rate : %u KB/sec\n",
		((unsigned)ptr[22] * 256 + (unsigned)ptr[23]));
	sprintf(output, "\tCurrent Data Transfer Rate              : %u KB/sec\n",
		((unsigned)ptr[22] * 256 + (unsigned)ptr[23]));
	writestring(output);*/
}

int sysinfo()
{
 // Create output file.
 if ((fp = fopen("idecd.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 // Get IDE CDROM information.
 writestring("\nIDE CDROM DRIVE(S) INFORMATION :\n\n");

 // Write to file.
 memset(&idecd_info_block, 0, 256);
 portid = 0x1f0; select = 0xa0;
 cd_info = get_ide_cd_info(0x1f0, 0xa0);
 sprintf(output,
	"\tIDE CDROM installed at Primary Master   : %s\n",
	(cd_info) ? "Yes" : "No");
 writestring(output);
 if (cd_info) writecdinfo();

 memset(&idecd_info_block, 0, 256);
 portid = 0x1f0; select = 0xb0;
 cd_info = get_ide_cd_info(0x1f0, 0xb0);
 sprintf(output,
	"\tIDE CDROM installed at Primary Slave    : %s\n",
	(cd_info) ? "Yes" : "No");
 writestring(output);
 if (cd_info) writecdinfo();

 memset(&idecd_info_block, 0, 256);
 portid = 0x170; select = 0xa0;
 cd_info = get_ide_cd_info(0x170, 0xa0);
 sprintf(output,
	"\tIDE CDROM installed at Secondary Master : %s\n",
	(cd_info) ? "Yes" : "No");
 writestring(output);
 if (cd_info) writecdinfo();

 memset(&idecd_info_block, 0, 256);
 portid = 0x170; select = 0xb0;
 cd_info = get_ide_cd_info(0x170, 0xb0);
 sprintf(output,
	"\tIDE CDROM installed at Secondary Slave  : %s\n",
	(cd_info) ? "Yes" : "No");
 writestring(output);
 if (cd_info) writecdinfo();

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

int main(int argc, char **argv)
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}