; * EXCEPTNA.ASM - Contains low level functions to act upon exceptions.
; * Copyright (C) 1998, 1999 Prashant TR
; *
; * This program is free software; you can redistribute it and/or modify
; * it under the terms of the GNU General Public License as published by
; * the Free Software Foundation; either version 2 of the License, or
; * (at your option) any later version.
; *
; * See the file COPYING.TR for more details.

_TEXT	SEGMENT	BYTE	PUBLIC	'CODE'
ASSUME	CS:_TEXT, DS:_TEXT
.386P

EXTRN 	_oldint9:FAR

HEXCODE	DB	'0123456789ABCDEF'
MESS1	DB	'ERROR OCCURRED AT CS:IP = ', 0
MESS2	DB	', FLAGS = ', 0
MESS3	DB	13, 10, 'PRESS ANY KEY TO REBOOT', 0

_cnvt	PROC

	MOV  	CX, 4
_cnvt_loop:
	ROL	AX, 4
	PUSH	AX
	MOV	BX, AX
	AND	BX, 0FH
	MOV	AL, CS:[BX + HEXCODE]
	MOV	AH, 0EH
	INT	10H
	POP	AX
	LOOP	_cnvt_loop
	RET

_cnvt	ENDP

_printmessage	PROC

_printmessage_loop:
	MOV	AH, 0EH
	XOR	BX, BX
	LODSB
	OR	AL, AL
	JZ	_printmessage_over
	INT	10H
	JMP	_printmessage_loop

_printmessage_over:
	RET

_printmessage	ENDP

_exception_handler	PROC	FAR
	PUBLIC	_exception_handler

	PUSH	BP
	MOV	BP, SP

	MOV	AX, 7
	INT	10H
	MOV	AX, 3
	INT	10H

	MOV	BX, SEG _oldint9
	MOV	ES, BX
	MOV	BX, OFFSET _oldint9
	LES	BX, ES:[BX]
	MOV	AX, ES
	SHL	EAX, 16
	MOV	AX, BX
	XOR	BX, BX
	MOV	ES, BX
	MOV	ES:[09H * 4], EAX

	MOV	AX, CS
	MOV	DS, AX
	MOV    	SI, OFFSET MESS1
	CALL    _printmessage
	MOV	AX, [BP + 4]
	CALL	_cnvt
	MOV	AH, 0EH
	MOV	AL, ':'
	XOR	BX, BX
	INT	10H
	MOV	AX, [BP + 2]
	CALL	_cnvt
	MOV    	SI, OFFSET MESS2
	CALL    _printmessage
	MOV	AX, [BP + 6]
	CALL	_cnvt
	MOV    	SI, OFFSET MESS3
	CALL    _printmessage
	XOR	AX, AX
	INT	16H

	MOV	AL, 0FEH
	OUT	64H, AL
	CLI
_halt:
	HLT
	JMP	_halt

_exception_handler	ENDP

_TEXT	ENDS
	END