/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _COMMDLG_C_

#include "editor.h"

extern unsigned video_base;

void sngbox_direct(int left, int top, int right, int bottom,
			int color, int bkcolor)
{
	unsigned short offset = (top - 1) * 160 + (left - 1) * 2;
	unsigned short f, g;
	unsigned char attrib = color | (bkcolor << 4);

	/* Top left corner. */
	_farpokeb(_dos_ds, video_base + offset++, '');
	_farpokeb(_dos_ds, video_base + offset++, attrib);

	/* The top. */
	for(f = 1; f <= (right - left - 1); f++)
	{
		_farpokeb(_dos_ds, video_base + offset++, '');
		_farpokeb(_dos_ds, video_base + offset++, attrib);
	}

	/* Top right corner. */
	_farpokeb(_dos_ds, video_base + offset++, '');
	_farpokeb(_dos_ds, video_base + offset++, attrib);

	/* Vertical. */
	for(f = 1; f <= (bottom - top - 1); f++)
	{
		offset = (top + f - 1) * 160 + (left - 1) * 2;
		_farpokeb(_dos_ds, video_base + offset++, '');
		_farpokeb(_dos_ds, video_base + offset++, attrib);
		offset = (top + f - 1) * 160 + (right - 1)* 2;
		_farpokeb(_dos_ds, video_base + offset++, '');
		_farpokeb(_dos_ds, video_base + offset++, attrib);
	}

	/* Bottom left corner. */
	offset = (bottom - 1) * 160 + (left - 1) * 2;
	_farpokeb(_dos_ds, video_base + offset++, '');
	_farpokeb(_dos_ds, video_base + offset++, attrib);

	/* The bottom. */
	for(f = 1; f <= (right - left - 1); f++)
	{
		_farpokeb(_dos_ds, video_base + offset++, '');
		_farpokeb(_dos_ds, video_base + offset++, attrib);
	}

	/* Bottom right corner. */
	_farpokeb(_dos_ds, video_base + offset++, '');
	_farpokeb(_dos_ds, video_base + offset++, attrib);

	/* Fill screen area. */
	for(f = 1; f <= (bottom - top - 1); f++)
	{
		offset = (top + f - 1) * 160 + left * 2;
		for(g = 1; g <= (right - left - 1); g++)
		{
			_farpokeb(_dos_ds, video_base + offset++, ' ');
			_farpokeb(_dos_ds, video_base + offset++, attrib);
		}
	}
}
