/* setfiledate.c -- set file date
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_set_date_time(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		IN  WORD nAction,	
		IN  WORD nDate,
		IN  WORD nTime)
{
	HANDLE handle;
	WORD	result;

	PROLOG(process_set_date_time);
	ISNULL(ppSFT);
	ISNULL(ppJFT);
	DBGVALUE(hFile,"%d");
	DBGVALUE(nAction,"%d");
	DBGVALUE(nDate,"%d");
	DBGVALUE(nTime,"%d");

	handle = VDDRetrieveNtHandle (pPDB, hFile, ppSFT, ppJFT);
	if (handle == INVALID_HANDLE_VALUE) {
		DBGMSG("invalid handle retrieved");
		result = ERROR_INVALID_HANDLE;
	} else 
		result = process_set_date_time_nt(handle, nAction, nDate, nTime);

	EPILOG(process_set_date_time, TRUE);			
	return result ;
}

WORD	process_set_date_time_nt(
		IN  HANDLE handle,				
		IN  WORD nAction,	
		IN  WORD nDate,
		IN  WORD nTime)
{
	WORD	result;
	FILETIME DosTime, Used;

	PROLOG(process_set_date_time_nt);
	DBGVALUE(nAction,"%d");
	DBGVALUE(nDate,"%d");
	DBGVALUE(nTime,"%d");

	if (!DosDateTimeToFileTime(nDate, nTime, &DosTime)) {
		result = (WORD)GetLastError();
		DBGMSG("wrong dosdatetime");
		EPILOG(process_set_date_time_nt, TRUE);			
		return result;
	}

	if (!LocalFileTimeToFileTime(&DosTime, &Used)) {
		result = (WORD)GetLastError();
		DBGMSG("wrong localfiletime");
		EPILOG(process_set_date_time_nt, TRUE);	
		return result;
	}

	result = ERROR_SUCCESS;

	switch (nAction)
	{
  		case SET_LAST_WRITE_DATE:
			if(!SetFileTime(handle, NULL, NULL, &Used))
				result = (WORD)GetLastError();
			break;
		case SET_LAST_ACCESS_DATE:
			if(!SetFileTime(handle, NULL, &Used, NULL))
				result = (WORD)GetLastError(); 
			break;
		case SET_CREATION_DATE:	 
			if(!SetFileTime(handle, &Used, NULL, NULL))
				result = (WORD)GetLastError();
			break;		
		default:
			result = ERROR_INVALID_FUNCTION; 
	}

	EPILOG(process_set_date_time_nt, TRUE);			
	return result ;
}
