/*****************************************************************************

  This code is copyrighted by Salvador Eduardo Tropea. (c) 1996.

  You can use, distribute and modify this code with the following
restrictions:

1) You can't remove this text.
2) You must say who is the original author.
3) You can't receive money for this files, this includes the binarys
generated with this sources, without my consent. (only a minimal amount for
the media is allowed without my consent (floppy disk <= 5 U$S, CD <= U$S 35)).
4) You can't modify the copyrights inside inflibc.spa and inflibc.eng, and
if you generate a convertion from libc.inf this convertion must include
inflibc.spa or inflibc.eng.

  The following aren't restictions but requests:

1) If you find any bug please inform it to me.
2) If you make enhacements or derivated work share it with me.
3) If you use this code or the files generated e-mail, or send a letter,
to me.

  Some of the projects i have in mind are the followings:

1) A FAQ's to NG coverter (seems to be easy)
2) A TEX to NG converter (not so easy)
3) A generic NG compiler.

  If you plan to do some of these, e-mail to me.

  Share and enjoy, but not abuse.

E-Mail: ice@inti.edu.ar

Telephone: (+541) 759-0013

Postal Address:
Salvador E. Tropea
Curapalige 2124
(1678) Caseros - 3 de Febrero
Prov: Buenos Aires
Argentina

*****************************************************************************/

// Uncomment this line if you want more memory free, but less speed
//#define TEXTO_EN_DISCO

#define ID_LARGO_CENTRADO 0x1000
#define ID_LARGO_MENU     0x1001


#define ID_MEMORIA       0x0000
#define ID_ASIGNA_NULL   0x0001
#define ID_AGREGA_NO_INI 0x0002
#define ID_CREAR_SALIDA  0x0003
#define ID_GRABAR_INCORRECTO 0x0004
#define ID_ATACHO_1      0x0005
#define ID_SEEALSO       0x0006


#define NG_ID 18254
#define NIL -1

/***************************************************************************

  Estructura del header del archivo.

***************************************************************************/

#pragma pack(1)

typedef struct
{
 WORD ID;
 WORD Version;
 WORD Dummy1;
 WORD NumeroMenues;
 char Nombre[40];
 char CopyR[5][66];
} hNG;

#pragma pack()

/***************************************************************************

  Estructura NodoLista

  Define todo para poder armar una lista de Objetos.

***************************************************************************/

// forward
class ObjNG;

struct stNodoLista
{
 ObjNG *o;
 stNodoLista *p;
};

typedef struct stNodoLista  NodoLista;

/***************************************************************************

  Estructura NodoStr

  Define todo para poder armar una lista de strings.

***************************************************************************/

struct stNodoStr
{
 char *s;
 stNodoStr *p;
};

typedef struct stNodoStr NodoStr;

/***************************************************************************

  Clase ListaStr

  Pour la gallery or some thing like this. Clases clases clases ...

***************************************************************************/

class ListaStr
{
 public:
 ListaStr() { Pos=Cola=Base=NULL; Cantidad=0; };
 ~ListaStr();
 int Cantidad;
 void Agregar(char *s);
 void Rebobinar() { Pos=Base; };
 char *Avanzar();

 private:
 NodoStr *Base;
 NodoStr *Cola;
 NodoStr *Pos;
};

/***************************************************************************

  Estructura NodoStrOff

  Define todo para poder armar una lista de strings + su offset.

***************************************************************************/

struct stNodoStrOff
{
 char *s;
 long Pos;
 stNodoStrOff *p;
};

typedef struct stNodoStrOff NodoStrOff;

/***************************************************************************

  Clase ListaStrOff

  Pour la gallery or some thing like this. Clases clases clases ...

***************************************************************************/

class ListaStrOff
{
 public:
 ListaStrOff() { Cola=Base=NULL; Cantidad=0; };
 ~ListaStrOff();
 int Cantidad;
 void Agregar(char *s);

 NodoStrOff *Base;
 NodoStrOff *Cola;
};

/***************************************************************************

  Clase ObjNG

  Es pure virtual, contiene la base para todas las otras clases, esta es la
que permite que se pueda armar una lista con objetos de distinta clase, pero
todos provenientes de esta.

***************************************************************************/

class ObjNG
{
 public:
 // Constructor base llamado por todas las otras clases
 ObjNG() { lPosBase=0; iObjContiene=0; Lista=Ultimo=NULL; Nombre=NULL;
           iPadreInd=iLargoNombre=NIL; lProximo=lPrevio=lPadrePos=NIL; };
 virtual void Agregar(ObjNG& o) = 0;    // pure virtual
 virtual int  Tipo() = 0;               // pure virtual
 virtual long ResolverPosiciones(long lPosIni,long lPos2) = 0; // pure virtual
 virtual void Grabar(int Accion,FILE *f) = 0; // pure virtual

 long lPosBase;        // OffSet en la NG
 long lLargo;
 int  iLargoNombre;
 int  iObjContiene;    // Cantidad de objetos atachados
 NodoLista *Lista;     // Base de la lista
 NodoLista *Ultimo;    // Cola
 long lProximo;
 long lPrevio;
 int  iPerteH;
 int  iPerteV;
 int  iPadreInd;
 long lPadrePos;
 char *Nombre;
};

//   Para el mtodo Guardar, de manera tal que sea posible 'romper' el rbol
// acumulando los menes al principio del archivo
#define ID_GUARDAR_SOLO_MENU  5
#define ID_GUARDAR_COMPLETO   6


/***************************************************************************

  Clase ObjNGElemento

  Define como se agrega un elemento a otro y como se resuelven las
posiciones.

***************************************************************************/

class ObjNGElemento : public ObjNG
{
 public:
 void Agregar(ObjNG& o);
};


/***************************************************************************

  Clase NGListaPura

  Es solo una lista de elementos, su objetivo es acumular referencias a
todos los tipo 1 para poder resolver los SeeAlso.

***************************************************************************/

class NGShort;

class NGListaPura : public ObjNGElemento
{
 public:
 int Tipo() { return -2; };
 void Grabar(int Accion,FILE *f) {};
 long ResolverPosiciones(long lPosIni=0,long dummy=0);
 NGShort *Buscar(char *NomBus);
};


/***************************************************************************

  Clase NGArchivo

  Es el archivo en si

***************************************************************************/

class NGArchivo : public ObjNGElemento
{
 public:
 NGArchivo(char *s,char *nom);
 NGArchivo::~NGArchivo();
 void AgregarCopy(char *Cp);
 int Tipo() { return -1; };
 long ResolverPosiciones(long lPosIni,long dummy=0);
 void Grabar(int Accion,FILE *f);

 private:
 hNG h;
 int NumCopy;
};

/***************************************************************************

  Clase NGMenu

  Entrada tipo 2 en las NG.
  Nombre es una opcin en el pull-down horizontal, las opciones verticales
se adicionan con Agregar (Objetos NGVariosShort y NGShort).

***************************************************************************/

#pragma pack(1)

typedef struct
{
 WORD Tipo;
 WORD Largo;    // Solo de la parte variable (-26)
 WORD Opciones;
 WORD LargoListaPunts;
 char Dummy[18];
} NGMenuStruct;

typedef struct
{
 WORD Fin;
 char Dummy[6];
} NGMenuFinOps;

#pragma pack()

class NGMenu : public ObjNGElemento
{
 public:
 NGMenu(char *nom);
 ~NGMenu();
 void Agregar(ObjNG& o,char *Nombre,NGListaPura& oLista);
 int Tipo() { return 2; };
 long ResolverPosiciones(long lPosDeEste,long lPosResto);
 void Grabar(int Accion,FILE *f);

 private:
 static int NumeroDeMenues;
 int  Numero;
 ListaStr Strs;
 NGMenuStruct hElem;
};

/***************************************************************************

  Clase NGVariosShort

  Entrada tipo 0 en las NG.
  En la NG:
  Contiene punteros a entradas que pueden ser tipo 0 o 1, si son tipo 0 se
sigue abriendo el rbol, si son tipo 1 son el texto directamente.
  Los primeros tipo 0 (que se desprenden directo del men) no poseen un
nombre, pero los restantes si ya que son vistos como un tipo 1 que al
elegirlo se ramifica en ms tipo 0 o 1.

***************************************************************************/

#pragma pack(1)

typedef struct
{
 WORD Tipo;
 WORD Largo;    // Solo de la parte variable (-26)
 WORD Puntos;
 WORD Dummy1;
 WORD IndPadre;
 long PosPadre;
 WORD IndMenuH;
 WORD IndMenuV;
 char Dummy2[8];
} NGVariosShortStr;

typedef struct
{
 WORD PosNom;
 long Punt;
} NGVariosShortNomPun;

#pragma pack()


class NGVariosShort : public ObjNGElemento
{
 public:
 NGVariosShort(char *nom);
 ~NGVariosShort();
 int Tipo() { return 0; };
 void Agregar(ObjNG& o,NGListaPura& oLista);
 // Solo vlido cuando se desprende de otro tipo 0 y no de un men
 // char *Nombre; es de la base
 long ResolverPosiciones(long lPosIni,long dummy);
 void Grabar(int Accion,FILE *f);

 private:
 NGVariosShortStr hElem;
};

/***************************************************************************

  Clase NGShort

  Entrada tipo 1 en las NG.
  Son el extremo final del ovillo, contienen texto, son las opciones
horizontales en la pantalla.

***************************************************************************/

#pragma pack(1)

typedef struct
{
 WORD Tipo;
 WORD Largo;    // Solo de la parte variable (-26)
 WORD Lineas;
 WORD OffSeeAlso;
 WORD IndPadre;
 long PosPadre;
 WORD IndMenuH;
 WORD IndMenuV;
 long Prev;
 long Next;
} NGShortStruct;

#pragma pack()

class NGShort : public ObjNGElemento
{
 public:
 #ifdef TEXTO_EN_DISCO
 NGShort(char *nom,char *alias,FILE *f);
 NGShort(char *nom,FILE *f); { NGShort(char *nom,NULL,FILE *f); };
 #else
 NGShort(char *nom,char *alias=NULL);
 #endif
 ~NGShort();
 void PonerTexto(char *Buf,int Cant);
 void Grabar(int Accion,FILE *f);
 int Tipo() { return 1; };
 void AgregarSeeAlso(char *nom);
 ListaStrOff SeeAlso;
 long ResolverPosiciones(long lPosIni,long dummy);
 char *Alias;

 private:
 unsigned int  TamanTexto;
 int Lineas;
 NGShortStruct hElem;
 #ifdef TEXTO_EN_DISCO
 long lPosEnDisco;      // Donde guard el texto
 FILE *BufDisco;
 #else
 char *Texto;
 #endif
};

/***************************************************************************

  Clase NGShortDummy

  Entrada tipo 1 en las NG, pero que ya existe en el rbol.
  Son el extremo final del ovillo, contienen texto, son las opciones
horizontales en la pantalla.

***************************************************************************/

class NGShortDummy : public ObjNGElemento
{
 public:
 NGShortDummy(char *nom,char *alias,NGShort *oReal);
 ~NGShortDummy();
 void Grabar(int Accion,FILE *f) {};
 int Tipo() { return 4; };
 long ResolverPosiciones(long lPosIni,long dummy);
 char *Alias;

 private:
 NGShort *Real;
};

