#!/bin/ksh

export PATH=$PATH:/usr/local/bin

seg=

p()
{
  pnmpaste blanks/$1.ppm $2 $3 < $IMG.ppm > $IMG.ppmt
  if [ "$seg" ]
  then
    pnmpaste blanks/$seg-b.ppm $4 $3 < $IMG.ppmt > $IMG.ppm
    rm $IMG.ppmt
    seg=
  else
    mv $IMG.ppmt $IMG.ppm
  fi
}

IMG=$1

  cp blanks/base.ppm $IMG.ppm
  
  for reg in `echo $IMG | tr + ' '`
  do
    case "$reg" in
      C)   seg=cs ;;
      D)   seg=ds ;;
      E)   seg=es ;;
      F)   seg=fs ;;
      G)   seg=gs ;;
      S)   seg=ss ;;

      al)  p al-b   68  0  0 ;;
      ah)  p ah-b   51  0  0 ;;
      ax)  p ax-w   51  0  0 ;;
      eax) p eax-l  17  0  0 ;;
      bl)  p bl-b   68 15  0 ;;
      bh)  p bh-b   51 15  0 ;;
      bx)  p bx-w   51 15  0 ;;
      ebx) p ebx-l  17 15  0 ;;
      cl)  p cl-b   68 30  0 ;;
      ch)  p ch-b   51 30  0 ;;
      cx)  p cx-w   51 30  0 ;;
      ecx) p ecx-l  17 30  0 ;;
      dl)  p dl-b   68 45  0 ;;
      dh)  p dh-b   51 45  0 ;;
      dx)  p dx-w   51 45  0 ;;
      edx) p edx-l  17 45  0 ;;

      si)  p si-w  140  0 89 ;;
      esi) p esi-l 106  0 89 ;;
      di)  p di-w  140 15 89 ;;
      edi) p edi-l 106 15 89 ;;
      bp)  p bp-w  140 30 89 ;;
      ebp) p ebp-l 106 30 89 ;;
      sp)  p sp-w  140 45 89 ;;
      esp) p esp-l 106 45 89 ;;

      cs)  p cs-w  178  0 ;;
      ds)  p ds-w  178 15 ;;
      es)  p es-w  178 30 ;;
      fs)  p fs-w  212  0 ;;
      gs)  p gs-w  212 15 ;;
      ss)  p ss-w  212 30 ;;

      c)  p c-f  178 45 ;;

    esac
  done
  
  ppmtogif < $IMG.ppm 2>/dev/null | giftrans -t '#0fff0f' > $IMG.gif
  rm $IMG.ppm
