/* xdirent.h -- dirent declarations wrapper
   Copyright (C) 1996 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _xdirent_h_
#define _xdirent_h_

#if HAVE_DIRENT_H
# include <dirent.h>
#endif
#if HAVE_NDIR_H
# include <ndir.h>
#endif
#if HAVE_SYS_DIR_H
# include <sys/dir.h>
#endif
#if HAVE_SYS_NDIR_H
# include <sys/ndir.h>
#endif

/* Interpret `HAVE_LINK' as meaning `UN*X style' directory structure
   (e.g., A single root called `/', with `/' separating links), and
   !HAVE_LINK as `DOS|OS/2|Windows style' (e.g., Multiple root volumes
   named `x:', with `\' separating links).  */

#if HAVE_LINK
# ifdef __DJGPP__
/* DJGPP has `link' in libc and prefers forward slashes, but
   also has DOS-style directory structure.  It also makes sense
   to include the link-related code in the DJGPP version, since
   SUBST'ed and JOIN'ed drives behave on MS-DOS exactly like
   links on UN*X, i.e. they create alias names for the same files.
   The DJGPP version of `stat' will return the same inode for
   such aliases.  */
#  define DRIVE_LETTER_IN_PATH 1
#  define PATH_SEP ";"
#  define IS_ABSOLUTE(_dir_) ((_dir_)[0] && (_dir_)[1] == ':')
#  define SLASH_STRING "/\\"
#  define SLASH_CHAR '/'
#  define DOT_DOT_SLASH "../"
#  define MAKE_PATH_EXPLICIT(_path_) \
	  do { \
	       char *expath = ALLOCA (char, PATH_MAX); \
	       _fixpath (_path_, expath); \
	       _path_ = expath; \
	     } while (0)
# else
#  define DRIVE_LETTER_IN_PATH 0
#  define PATH_SEP ":"
#  define IS_ABSOLUTE(_dir_) ((_dir_)[0] == '/')
#  define SLASH_STRING "/"
#  define SLASH_CHAR '/'
#  define DOT_DOT_SLASH "../"
# endif
#else
/* NEEDSWORK: prefer forward-slashes as a user-configurable option.  */
# define DRIVE_LETTER_IN_PATH 1
# define PATH_SEP ";"
# define IS_ABSOLUTE(_dir_) ((_dir_)[0] && (_dir_)[1] == ':')
# define SLASH_STRING "\\/"
# define SLASH_CHAR '\\'
# define DOT_DOT_SLASH "..\\"
#endif

#endif /* not _xdirent_h_ */
