Tue Jun  3 10:49:44 2000  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Array.st: #isArray returned false instead of true

Tue Jun 1 20:11:28 2000  Paolo Bonzini (bonzini@gnu.org)

	* examples/Buffers.st: removed stray double quote

Tue Apr 27 11:32:14 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/LargeInt.st: fixed bug in #~=

Thu Apr 12 17:06:32 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.4 released

Thu Apr 12 17:03:24 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/Behavior.st: added private method #sharedPoolDictionaries
	* kernel/Class.st: added private method #sharedPoolDictionaries
	* kernel/Metaclass.st: added private method #sharedPoolDictionaries,
	used it to fix bug with redefinition of classes with pool dictionaries

Fri Mar 24 18:22:48 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.3 released (fixes packaging problem in 1.7.2)

Mon Mar 13 18:29:03 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.2 released

Thu Feb 24 10:25:16 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/Delay.st: fixed race condition when garbage collection
	suspended the interpreter and Delay class>>#timeout: was called
	when the process should have been already resumed.

Tue Feb 22 18:29:03 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7.1 released

Mon Feb 22 18:27:57 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/File.st: added methods to test file accessing modes.

Mon Feb 21 10:32:16 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/Builtins.st: added a few time-zone related methods.
	* kernel/Time.st: added a few time-zone related methods.

Tue Feb 15 09:48:25 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Version 1.7 released

Tue Feb 1  09:17:43 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/CompildCode.st: print bytecode 132 according to the new
	coding

Mon Jan 31 14:48:04 2000  Paolo Bonzini (bonzini@gnu.org)

	*** Sixth beta of 1.7 (labeled 1.6.85) released

Wed Dec 31 14:37:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STFileInParser.st: split between STParser.st and
	StartCompiler.st (so that the class itself is loaded together with
	the Parser package, even though it is not activated).
	* compiler/STSymTable.st: use an IdentitySet for storing pool
	dictionaries.
	* kernel/Builtins.st: use identity for RootNamespaces' equality
	and the #identityHash for hashing
	* kernel/Symbol.st: sending #copy, #shallowCopy or #deepCopy to
	a symbol was actually answering a String!!

Fri Jan 28 09:07:18 2000  Paolo Bonzini (bonzini@gnu.org)

	* kernel/BlkContext.st: fixed #initBlock: for CompiledBlocks
	* kernel/Builtins.st: removed declarations of #adjPtrBy: and
	#ptrDiff:... as primitives
	* kernel/CObject.st: implemented #adjPtrBy: and #ptrDiff:... in
	Smalltalk

Mon Jan 24 08:16:50 2000  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkClosure.st: access lots of things through CompiledBlocks.
	* kernel/CompiledBlk.st: created.
	* kernel/CompildCode.st: created from CompildMeth.st.
	* kernel/CompildMeth.st: removed `class' and `selector'
	variables, which are now accessed indirectly through the
	descriptor (`MethodInfo') object.  Moved lots of code to
	kernel/CompildCode.st
	* kernel/MethodInfo.st: added `class' and `selector' variables

Thu Jan 20 09:50:14 2000  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: Integer primitives now defined in
	SmallInteger.
	* kernel/Integer.st: moved part to SmallInt.st
	* kernel/LargeInt.st: removed #isIdentity and #isSmallInteger
	(now they are not defined anymore in Integer, but rather in
	SmallInteger which is not a superclass of LargeInteger).
	* kernel/Number.st: added abstract #asFloat method.
	* kernel/SmallInt.st: created from Integer.st
	* test/intmath.st: `Integer largest' --> `SmallInteger largest';
	`Integer smallest' --> `SmallInteger smallest';

Sat Jan 15 10:05:26 2000  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ByteArray.st: C-like accessors (e.g. #intAt:) had
	sizeof(long) hardcoded as 4. Fixed.
	* kernel/Behavior.st: fixed problem with #allInstances, when
	instances of the class are created during its execution.
	* kernel/CompildMeth.st: use ByteArray literal in #accesses:
	just to show that it is possible.
	* kernel/Date.st: use ByteArray literal in
	#daysInMonthIndex:forYear: just to show that it is possible.

Sat Jan  8 08:47:20 2000  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkContext.st: added #isEnvironment
	* kernel/ContextPart.st: use #isEnvironment in #environment,
	added #isEnvironment as an abstract method
	* kernel/MthContext.st: added #isEnvironment

	* kernel/CompildMeth.st: print new bytecode 143

Wed Dec 29 14:37:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ContextPart.st: set to nil the stack slots that become
	accessible because of sending #sp: to a context.
	* kernel/FileStream.st: added #stdin/#stdout/#stderr accessors
	for global variables.
	* kernel/Transcript.st: class name changed to TextCollector
	for consistency with other environments

Tue Dec 28 12:17:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Fifth beta of 1.7 (labeled 1.6.84) released

Mon Dec 27 20:15:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: new way of compiling blocks.
	* examples/Debugger.st: new implementation of #blockCopy: (bytecode
	200).
	* kernel/Builtins.st: primitive 80 (blockCopy:) is now used by
	BlockClosure.

Mon Dec 27 10:05:10 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkClosure.st: new `method' instance variable
	* kernel/ContextPart.st: removed methodClass variable,
	replaced implementation of the accessor to retrieve the class
	from the method.
	* kernel/MthContext.st: new implementation of #selector.

Sat Dec 26 16:49:17 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: support for the new `class' and `selector'
	variables in CompiledMethods.
	* kernel/ClassDesc.st: support for the new `class' and `selector'
	variables in CompiledMethods.
	* kernel/CompildMeth.st: new `class' and `selector' variables in
	CompiledMethods.
	* kernel/MethodDict.st: encapsulated #removeAssociation: which
	can be dangerous just like #removeKey:ifAbsent:.

Tue Dec 21 18:54:03 1999  Paolo Bonzini  (bonzini@gnu@org)

	* compiler/STParser.st: added STPluggableParser, derivated from
	the syntax highlighter.

Sun Dec 19 10:38:43 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkContext.st: removed home, moved receiver to ContextPart.
	* kernel/ContextPart.st: removed hasBlock, made the structure of
	contexts more uniform (only two variables lie in the subclasses)
	* kernel/MthContext.st: moved method, methodClass, receiver to
	ContextPart.

Mon Dec 6 18:00:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: hacked Float>>#hash so that '2 hash = 2.0 hash'
	* kernel/CompildMeth.st: bit 30 is now part of the method flags.

Fri Dec 10 21:02:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/WordMemory.st: added accessor for the `Bigendian' global
	variable.

Sun Dec 5 18:54:57 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STTok.st: parse stuff like 1.0d53 and 1.0q212 correctly
	even though FloatD/FloatE/FloatQ is not supported yet.
	* kernel/Behavior.st: ANSI asks for 65535 instance variables, so I
	shifted the instance specification's `number of instance vars' field
	right by three bits (now 262143 variables are possible).
	* kernel/Directory.st: added methods to manage file names.
	* kernel/ExcHandling.st: neater implementation of #pass and
	#signalWithArguments:, more encapsulation in the
	ExceptionHandler class.
	* kernel/File.st: added methods to manage file names; plus,
	use the strerror C function.

Fri Nov 26 20:59:16 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Fourth beta of 1.7 (labeled 1.6.83) released

Tue Nov 23 11:42:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: fixes for Texinfo 4.0 (which produces
	HTML too, not just TeX and Info).
	* kernel/Class.st: GNU Smalltalk's #variableWordSubclasses:
	are actually IBM Smalltalk's #variableLongSubclasses: (fix
	to the compatibility methods).

Sun Nov 21 11:51:27 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/bench.st: fixes to make measurements more constant.
	See `e)' in the discussion of the results at the top of the
	file.
	* kernel/ClassDesc.st: #fileOutCategory:toStream: was ending
	a category with `!!' instead of `! !'
	* kernel/FileStream.st: added #nextPutAllFlush:
	* kernel/Transcript.st: use #nextPutAllFlush: when stdout is
	the transcript.

Fri Nov 19 19:46:50 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Prolog.st: added

Thu Nov 18 16:34:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: better handling of mutation -- create
	a lightweight class with the old representation, change the
	object to it and forget #specialBasicAt:.
	* kernel/Object.st: better handling of mutation -- see above.

Wed Nov 17 20:06:07 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Lisp.st: added
	* kernel/CharArray.st: moved implementation of #asNumber to
	Number>>#readFrom:
	* kernel/Number.st: #readFrom: reads a Number from the current
	stream position, not from its start (correct semantics)

Sun Nov 14 15:42:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Bench.st: more comparisons added
	* kernel/CompildMeth.h: move flag bits to high end, so that there is
	place for two additional bits if needed
	* kernel/BlkContext.c: BlockContexts now hold the receiver and the
	BlockClosure instead of the number of arguments and temporaries.

Thu Nov 11 22:02:17 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: added another delegation method for warnings.
	* compiler/STParser.st: added warnings (nothing is done with them yet,
	but the methods are there).
	* compiler/STSymTable.st: duplicate var names produce a warning.

Sat Nov 6 17:08:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: support for namespaces

Mon Nov 1 20:07:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ClassDesc.st: moved #nameIn: from Class.
	* kernel/Class.st: moved #nameIn: to ClassDescription.

Sun Oct 31 11:12:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Third beta of 1.7 (labeled 1.6.82) released

Sat Oct 30 12:31:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: save the last STParseNode that was generated
	* compiler/STParseNode.st: added the `comments' variable

Mon Oct 25 17:56:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/SeqCollect.st: added optimized version of #anyOne

Fri Oct 22 10:15:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: use the last decimal digit as a guard digit
	when printing
	* kernel/SeqCollect.st: added #do:separatedBy:
	* compiler/STSymTable.st: fixed bug with undeclared variables (error
	when the undeclared variable's name had not been interned as a symbol)
	* compiler/STVisitor.st: created
	* compiler/Load.st: load STVisitor.st

Thu Oct 21 17:44:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: moved a few String primitives to CharacterArray
	* kernel/Object.st: added #isCharacterArray
	* kernel/String.st: moved most code to CharArray.st
	* kernel/CharArray.st: created by refactoring of String.

Wed Oct 20 19:05:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Object.st: added #display* methods.
	* kernel/String.st: added #displayOn: and #displayString methods.
	* kernel/Symbol.st: added #displayOn: and #displayString methods.
	* kernel/Character.st: added #displayOn: methods.

Wed Oct 13 17:38:49 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: added ability to read comment tokens and
	removed methods that test for particular kinds of tokens
	(#isBinaryOperator: and #isSymbolId:)
	* compiler/STTok.st: now passes comment tokens to STParser
	* compiler/STToken.st: reworked token hierarchy to add polymorphic
	methods that replace STParser's old #isBinaryOperator: and
	#isSymbolId:. Hope to get not only elegance, but also a bit of
	speed.

	* examples/Buffers.st: created from tcp/ReadBuffer.st and
	tcp/WriteBuffer.st

	* kernel/Builtins.st: Set's #primXXX methods moved here
	* kernel/Float.st: #hash was not always returning integers
	* kernel/Set.st: removed #primXXX

Mon Oct 11 09:23:01 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STSymTable.st: added code to handle `Undeclared'.
	* compiler/STFileInParser.st: tell STSymbolTable to recognize
	`Undeclared' inside file-ins.
	* kernel/Float.st: added missing #integerPart (`num := self
	integerPart' was `num := self') in code to print the Float's
	integer part -- the solution to the printing bug that I had
	tried on Oct 2nd was wrong.
	* kernel/WeakObjects.st: added #postLoad to WeakArray to make
	the array weak again.

Sun Oct 10 10:57:37 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Association.st: parts moved to kernel/LookupKey.st.
	* kernel/Builtins.st: added comment for the new behavior of file-ins
	regarding undeclared globals (usage of the `Undeclared' dictionary).
	* kernel/FileStream.st: same as above.
	* kernel/LookupKey.st: recreated from parts of kernel/Association.st.
	* kernel/PkgLoader.st: added ability to ignore undeclared call-outs
	(useful for producing documentation without recompiling the VM).

Sat Oct 9 09:14:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Second beta of 1.7 (labeled 1.6.81) released

	* kernel/Builtins.st: added primitive to flush the dynamic
	translator's code cache. Fail on `anInteger asOop'.
	* kernel/CompildMeth.st: use the primitive above.

Thu Oct 7 18:07:46 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: use MethodDictionaries; removed calls to
	#flushCache since they are in MethodDict.st
	* kernel/Builtins.st: removed definition of primitives in
	Array that were there to minimize the possibility that removals
	inside the MethodDictionary of a class crashed the system.
	* kernel/MethodDict.st: created

Tue Oct 5 22:25:32 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: added helper class ActiveHandlersList
	to avoid messy usage of ReadStreams and #copy.
	* kernel/Float.st: added #ln10 class method to answer 2.302...
	* kernel/Number.st: added #log.
	* kernel/ObjDumper.st: fixed bugs in namespace handling.

Mon Oct 4 18:11:59 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: remove subclasses of CStruct from
	the manual.
	* kernel/CompildMeth.st: #literals was erroneously going
	into an infinite loop (^self literals).

Sat Oct 2 14:53:46 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: fixed \\ (was returning the floor of
	the result) and printing (the last integer digit of numbers
	with a large decimal part, such as 4.999, was misprinted --
	5.999 in this case)
	* kernel/Number.st: fixed rounded (was using `truncated'
	instead of `floor')
	* test/intmath.st: added more // and \\ tests.
	* test/floatmath.st: added // and \\ tests.

Thu Sep 30 18:00:14 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkClosure.st: added #repeat
	* kernel/Date.st: added #shortNameOfMonth
	* kernel/Stream.st: moved methods that traditionally were in
	PositionableStream, but which I implemented without using
	PositionableStream protocol, here; added #splitAt:
	* kernel/PosStream.st: opposite of above

Sat Sep 25 12:32:23 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** First beta of 1.7 (labeled 1.6.80) released

Thu Sep 23 17:31:42 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Set.st: initialize in new method #initialize:
	* kernel/LookupTbl.st: initialize in #initialize:
	* kernel/WeakObjs.st: initialize hashed collections in #initialize:
	* kernel/RootNamespc.st: initialize #Super key in #setSuperspace:

Sun Sep 19 14:00:50 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: use a WeakArray in #allInstances
	* kernel/Builtins.st: moved all `Smalltalk at: #... put: nil' declarations
	here.  Fixed missing dot in Behavior>>#basicNew:
	* kernel/CType.st: CArrayCType subclass of CPtrCType
	* kernel/LookupTbl.st: created from IdentDict.st
	* kernel/IdentDict.st: mostly moved to LookupTbl.st
	* kernel/SeqCollect.st: moved #swap:with: to SortedCollection -- it was
	used just there, and meant to be used just there.
	* kernel/SortCollect.st: #swap:with: moved here.
	* kernel/WeakObjects.st: created

Sat Sep 18 14:33:28 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Bag.st: added #sortedByCount.
	* kernel/BlockClosure.st: don't make copies (answer the original object)
	* kernel/Character.st: added #isPunctuation
	* kernel/UndefObj.st: nil should not have dependents

Wed Sep 15 18:39:41 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Directory.st: added #create:
	* kernel/Object.st: added #broadcast:with:with:
	* oodb/*: added
	* test/chars.st: made more comprehensive
	* test/exceptions.st: added
	* test/sets.st: added
	* test/*.base: renamed to *.ok for easier life on 14-char systems.

Tue Sep 14 10:02:55 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Case.st: added #ifEqualTo:do:
	* examples/SortCriter.st: added
	* kernel/ObjDumper.st: uses preStore and postLoad.
	* kernel/Object.st: definition of preStore and postLoad.
	* kernel/SortCollect.st: Added DefaultSortBlock to SortedCollection;
	uses preStore and postLoad.
	* xml/XWalker.st: added
	* xml/DOM.st: added

Sun Sep 12 12:00:11 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: variable instanceVariables came here from
	ClassDescription.
	* kernel/Class.st: variables name/comment/category/environment
	moved to Class (they make no sense in Metaclass, so why were they
	in ClassDescription?)
	* kernel/ClassDesc.st: combination of the two above.

Sat Sep 11 18:26:14 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STSymTable.st: implementation of namespaces
	* kernel/ClassDesc.st: implementation of namespaces
	* kernel/Class.st: implementation of namespaces
	* kernel/Namespace.st: created from Behavior.st and SysDict.st
	* kernel/Object.st: Smalltalk is no longer a pool dictionary.
	* kernel/RootNamespc.st: created from Behavior.st and SysDict.st
	* kernel/SysDict.st: moved something to Namespace.st and RootNamespc.st
	* kernel/UndefObject.st: implementation of namespaces

Fri Sep 10 13:29:48 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Queens.st: added #do: to NullQueen.
	* kernel/BlkClosure.st: BlockClosures are now variableWordSubclasses
	since the previous encoding was incompatible with the code to switch
	the endianness in a saved image.
	* kernel/PosStream.st: added support for Cr/Lf terminators in #nextLine.

Mon Sep  6 11:07:16 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Delay.st: #idle method now lies in ProcessorScheduler.
	* kernel/ProcSched.st: added support for idle block registration.

Wed Sep  2 11:52:58 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: added support for [ :a :b || temp1 temp2 | ].

Tue Aug 31 14:41:31 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Collection.st: added #with:collect:
	* kernel/ArrayColl.st: added #with:collect:, removed duplicate definition
	of #copyWith:

Sun Aug 29 11:23:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.6.2 released.

Thu Aug 26 19:43:41 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: finally got hierarchy tree formatting to work.
	* kernel/DLD.st: don't define the `DLD' feature since DLD.st is always
	loaded now.  The feature is defined in lib/dict.c if the DLD functions
	are not stubs.
	* kernel/Float.st: use CDoubleMin and CDoubleMax.
	* kernel/PkgLoader.st: more meaningful error messages (`package
	not available' instead of `key not found').

Sun Aug 8 14:37:21 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: `Smalltalk snapshot' primitive (250) removed
	-- the new ImageFileName global makes it redundant.
	* kernel/File.st: added polite accessor to the ImageFileName global
	(File class>>#image).
	* kernel/SysDict.st: `Smalltalk snapshot' primitive (250) is now
	implemented in terms of the new ImageFileName global.

Sat Aug 7 23:56:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/File.st: declare `unlink' (valid only for files) instead of
	`remove' (which works for directories too) to be used to implement
	File class>>#primRemove:

Sat Aug 7 11:23:38 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Case.st: provided by Ulf Dambacher.
	* examples/EditStream.st: provided by Ulf Dambacher.
	* examples/Watchdog.st: provided by Ulf Dambacher.
	* kernel/Date.st: handle dates like 0-Feb-1989.
	* kernel/MappedColl.st: added `domain' and `map' accessors.
	* kernel/Transcript.st: in #next:put:, #new:withAllPut: (which does not
	exist) was sent to String instead of #new:withAll:
	* kernel/ValueAdapt.st: added NullValueHolder.

Wed Jul 14 09:24:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: removed conditional code so that images produced
	by computers with different endianness can be used.
	* test/delays.st: created from test/processes.st since it is the
	only part that fails under some architectures (e.g. SunOS)

Fri Jun 25 12:53:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Bug-fixing version 1.6.1 released.

Thu Jun 17 11:38:53 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.6 released.

Wed Jun 9  12:48:21 1999  Pahi Andras  (pahi@mozart.eet.bme.hu)

	* kernel/DLD.st: fixed lots of stupid bugs (misspelled method names
	and more)
	* test/arrays.st: renamed (used to be array.st) so that it works
	in case-insensitive filesystems.
	* test/classes.st: renamed (used to be class.st) for same reason.
	* test/processes.st: renamed (used to be process.st) for same reason.

Thu Jun  3 13:33:34 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: #at:put: for C strings and aggregates
	(arrays/ptrs) can take both a smalltalk object and a CObject.
	* kernel/CObject.st: moved some primitives to Builtins.st
	* kernel/CompildMeth.st: #storeOn: stored bytecodes as an
	Array (not a ByteArray).
	* kernel/Object.st: #storeOn: now uses the Object's validSize.

Mon May 31 21:12:31 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CompildMeth.st: added #stripSourceCode.
	* kernel/Date.st: some bug fixes.
	* kernel/MethodInfo.st: added #stripSourceCode.

Mon May 24 20:48:43 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Date.st: Removed iterative algorithms, replaced with numerical
	ones proposed by Jeff Rosenwald (JeffRose@acm.org).

Sun May 23 11:32:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Debugger.st: Added new bytecodes

Thu May 13 11:11:29 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: Finished revamped Floats -- added #hash
	* compiler/STCompLit.st: First changes to support loop optimization
	* compiler/STCompiler.st: First changes to support loop optimization
	* compiler/STParseNodes.st: First changes to support loop optimization

Sat May 8 18:25:39 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Transcript.st: Moved here from blox. Modified to initially
	set up a Transcript on stdout.
	* kernel/Object.st: Changed #print and #store to work with the Transcript
	object.

Thu May  6 12:55:03 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: exception handlers are now per process.
	* kernel/Fraction.st: added code to test for NaNs in #asFloat.  Also, now
	I use #quo: in #reduced.
	* kernel/LargeInt.st: misc bug fixes.
	* kernel/Process.st: added exceptionHandlers variable.
	* kernel/Object.st: added #ifNil:, #ifNotNil: and companions.
	* kernel/UndefObject.st: added #ifNil:, #ifNotNil: and companions.

Wed May  5 20:12:52 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: added stuff to print/store infinite values and NaNs
	* kernel/LargeInt.st: changed divide:using: and reverseStringBase:on:
	to special case divisions by small (< 256) divisors.
	* kernel/WriteStream.st: fixed #size -- was returning 1 more than the
	correct value. For example, "String new writeStream size" returned 1.

Mon May  3 19:36:45 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: changed the system message #booleanRequired to
	#mustBeBoolean for coherence with the Blue Book (I had not noted
	that passage).

Sun May  2 19:31:48 1999  Luciano Esteban Notarfrancesco  (lnotarfr@dc.uba.ar)

	* kernel/SortCollect.st: new algorithm for includes: and
	occurrencesOf:
	* kernel/Number.st: new algorithm for raisedToInteger: and
	raisedTo:.  Added isRational.
	* kernel/Fraction.st: added isRational.  Generality multiplied by 100.
	* kernel/Integer.st: gcd: and lcm: always return positive numbers.
	Added isRational.  Generality multiplied by 100.
	* kernel/Float.st: generality multiplied by 100.
	* kernel/LargeInt.st: generality multiplied by 100.

Thu Apr 29 14:56:51 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CompildMeth.st: added code to handle the 142 (replace stack
	top) bytecode in the #accesses: method.

Tue Apr 27 20:01:18 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta3 released.

Thu Apr 22 00:43:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: modified to support recent changes in the
	bytecode set.
	* compiler/STCompLit.st: same as above.
	* kernel/ArrayColl.st: added #new:withAll: .
	* kernel/Builtins.st: added #at:/#at:put:/#basicAt:/#basicAt:put: to
	Array.  They are needed so that, when updating method dictionaries,
	GST doesn't look for methods inherited by Array and defined in
	method dictionaries that are still in a semi-updated state (e.g.
	this happens when removing Collection's #inspect method, during Blox's
	load).  Thanks to Christopher Painter-Wakefield for signaling this.

Tue Apr 20 18:45:38 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CompildMeth.st: added code to print the nop bytecode (139)

Thu Apr 16 20:05:11 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ContextPart.st: added hasBlock instance variable, moved
	its accessor here (used to be in the subclasses)
	* kernel/MthContext.st: removed hasBlock instance variable and
	its accessor
	* kernel/BlkContext.st: same as above
	* kernel/Builtins.st: moved in (as methods in SystemDictionary) the
	two primitives that were in examples/PerfMonitor.st
	* examples/PerfMonitor.st: nuked; its contents are now part of
	Builtins.st
	* cxtnsn/DLD.st: Modified so that if you use defineCFunc:... and
	DLD is used, unresolved functions are searched in dynamically linked
	libraries.  One day I'll make it use dlopen and dlsym.

Sat Apr 10 23:22:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta2 released.
	* kernel/Time.st: remove GMT from printOn: (see changes in sysdep.c).

Fri Apr  8 18:45:01 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: added some comment guessing.
	* kernel/CObject.st: merged CPtr and CArray into CAggregate at last.
	* kernel/SortCollect.st: fixed implementation of pivot selection.
	* kernel/File.st: fixed file times to be returned relative to 1/1/2000
	to avoid possible overflows (which would have happened around 2004
	on 32-bit machine, and around 8.000.000.000 AD on 64-bit ones...).

Mon Mar 15 21:00:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	*** Version 1.5.beta1 released.
	* examples/Publish.st: some bug fixes now that we use it to generate
	GST's manual.

Sat Mar 13 14:32:12 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: added DocumentationClassPublisher (refactored
	from HTMLClassPublisher) and TexinfoClassPublisher.

Wed Mar 3 18:19:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: added stack depth tracing.

Sat Feb 27 10:07:26 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: Added ProcessorScheduler>>#isTimeoutProgrammed
	as part of the changes below for Delay.
	* kernel/Delay.st: Added backgroundProcess in Delay's
	#startDelayLoop class method, and added #idle class method.
	Fixed so that delays across two evaluations (i.e. an evalua-
	tion starts, a delay is pending when it ends, and then another
	evaluation starts which must discard that delay and accept
	new ones) works.
	* examples/Dinner.st: ditto

Fri Feb 26 18:07:19 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Class.st: #removeClassVarName: referred to non-
	existent method #classVariables (instead of #classPool)

Tue Feb 23 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Symbol.st: Changed storeOn: to properly handle #'ab cd'
	symbols and printOn: to use the version inherited from String

Mon Feb 22 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Bag.st: printOn: sent `print: ($ )' instead of `space'
	* examples/Dinner.st: created.
	* kernel/Process.st: Added various accessors for the regression
	tests, changed many things because of changes in the VM,
	new experimental interrupt mechanism.
	* kernel/ProcSched.st: Added various accessors to account for the
	changes in Process.
	* kernel/Builtins.st: Moved #blockCopy:... to ContextPart

Fri Feb 19 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Queens.st: created.

Wed Feb 17 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/SysDict.st: Added class accessors (eg allBehaviorsDo:)

Tue Feb 16 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CompildMeth.st: Changed for new representation of
	literals
	* compiler/STCompLit.st: added support for > 64 literals
	(BigLiteral)
	* compiler/STCompiler.st: added support for > 64 literals
	(compileBigLiteral:)

Mon Feb 15 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/PosStream.st: Fixed #reset to use #position:
	* kernel/FileStream.st: Added selectors for new style opening
	modes (FileStream open: 'foo' mode: FileStream read)

Sun Feb 14 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: Selectors stay Strings. The compiler
	turns them to Symbols.
	* kernel/ContextPart.st: finally got the unwinding system to
	work.

Sat Feb 13 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STSymTable.st: changed to use new #isSymbolString:
	method for Symbol
	* kernel/Symbol.st: Added isSymbolString:
	* kernel/CType.st: Great! Factored out everything in CScalarCType!
	C*Type are now instances of CScalarCType. So we save a source of
	confusion (is it CByteCType or CByteType?!?) and ten classes which
	were carbon copies.

Fri Feb 12 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: added HTML output

Tue Feb  9 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: Removed usage of Tokenizer's recording
	capability, since Tokenizer no more has that capability...
	* examples/Tokenizer.st: Removed recording, which was way too
	slow and in fact not even needed by the compiler.
	* kernel/Behavior.st: Fixed bug in #extractEvalChunk: not
	handling unterminated string literals.
	* kernel/Collection.st: Added #removeAll:ifAbsent:

Mon Feb  8 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: fixed bug with unwind mechanism: in
	code like [ [ 1/0 ] valueWithUnwind ] on: ExAll do: [ :sig | ... ]
	the exception handler must NOT be used - in other words, if we
	are inside a #valueWithUnwind, outer exception handlers are
	momentarily disabled.
	* kernel/PkgLoader.st: created.
	* Load.st: created.
	* Reload.st: created.

Fri Feb  5 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: added ExUserBreak.
	* kernel/LinkedList.st: Fixed missing dot problem - probably I
	had introduced it earlier.

Thu Feb  4 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ContextPart.st: fixed bug in the unwinding system
	(using SystemDictionary>>#halt did not work properly)

Wed Feb  3 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/Load.st: created.
	* compiler/STParser.st: Fixed bug in parsing binary message
	declarations.
	* compiler/STCompiler.st: fixed #compileString: to work with
	metaclasses.

Mon Feb  1 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: 'self perform: <a Message>' now acts
	like '<a Message> sendTo: self' - stole from Dolphin Smalltalk:
	not particularly useful, but makes GST more `universal'
	* kernel/Symbol.st: Added with:...
	* kernel/ObjDumper.st: Changed superclass to Stream. Added proxy
	feature.
	* kernel/IdentDict.st: Created a separate version of growBy:
	which does not involve Associations (which are not used by
	IdentityDictionaries).  This halved the execution time for
	Andreas Klimas' little torture test (examples/mixed/torture.st),
	performing half the GCs.
	* kernel/FileStream.st: Fixed open and popen to use basicNew
	instead of new. new is now disabled.
	* compiler/STFileInParser.st: created.

Sun Jan 31 12:34:56 1999  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Switched FileStream to returning nil on
	failure only if errno = 0. If not, it is probably better to check
	the errno. Things like search paths, etc, can be still implemented
	(from the highest level to the lowest)
	a) by using methods like open:mode:ifFail:
	b) by using new exception handling mechanisms
	c) by using methods like fileOp:ifFail: - see open:mode:ifFail:

Fri Jan 29 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CObject.st: Added CBoolean.
	* kernel/CType.st: Added CBooleanCType
	* kernel/Boolean.st: Added `self subclassResponsibility' methods
	* kernel/True.st: Added asCBooleanValue
	* kernel/Browser.st: Changed the BrowserClassesValid global
	(brrr!!!!) to a more sedate-sounding class variable.

Thu Jan 28 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/FileStream.st: #close now sets the `file' instance variable
	to nil, to prevent multiple closes of the same file. At least under
	Win32 this does not usually cause SIGSEGV or similar: however you
	might end up closing the file descriptor for some other open file,
	resulting in difficult to catch bugs
	* kernel/Behavior.st: Added a few goodies needed to make lightweight
	classes work a little better (#new class method, #name instance method)
	* kernel/LargeInt.st: Added ~=

Wed Jan 27 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Date.st: Changed now that assignment to argument is invalid.
	Fixed asSeconds to answer seconds from 1/1/1901 - with LargeIntegers,
	there's no reason to answer seconds from 1/1/1970.

Tue Jan 26 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/File.st: Changed now that assignment to argument is invalid
	* kernel/CompildMeth.st: also
	* kernel/Integer.st: also
	* kernel/ObjDumper.st: also
	* kernel/OrderColl.st: also
	* kernel/Point.st: also
	* kernel/Rectangle.st: also
	* kernel/SeqCollect.st: also
	* kernel/Set.st: also
	* kernel/String.st: also
	* kernel/LargeInt.st: also
	* kernel/Collection.st: Changed now that assignment to argument is
	invalid. Switched to quicksort for implementing #asSortedCollection:.
	* kernel/SortCollect.st: Changed now that assignment to argument is
	invalid. Switched to quicksort for implementing #asSortedCollection:.
	* compiler/STVariable.st: created to detect storing in an argument
	* compiler/STCompiler.st: in sync with the C compiler, storing into
	an argument is now detected as an error.  Thanks to Andreas Klimas
	for signaling this to me!!

Mon Jan 18 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: Fixed up floating point printing to round
	correctly. It should work now...
	* kernel/LargeInt.st: Implemented a faster way to print
	LargeIntegers: I split them into small parts which stay into a
	small integer: this usually results in executing a lot fewer
	bytecodes (650,000 instead of 5,500,000 to print 1e36)!!
	* kernel/Integer.st: Added special floorLog: implementation. Added
	largest/smallest.

Sat Jan 16 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Tokenizer.st: Added line counting
	* kernel/ByteStream.st: Created.
	* kernel/ByteArray.st: Added Memory-style accessors. Very
	interesting!!

Fri Jan 15 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/WriteStream.st: Removed maxSize instance variable

Wed Jan 13 12:34:56 1999  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/SysDict.st: Added access to the command line arguments.
	* kernel/CFuncs.st: Added getArgc and getArgv

Tue Dec 15 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Publish.st: added class hierarchy (previously methods
	laid in ClassDescription).

Thu Dec 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ObjDumper.st: Added support for byte objects with fixed
	instance variables.

Wed Dec  9 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/File.st: Changed struct Stat format for portability.
	* kernel/LargeInt.st: fixed bug in basicRightShift:

Tue Dec  1 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Object.st: Added postCopy

Sun Nov 29 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Metaclass.st: Finished integration of class-instance
	variables

Fri Nov 27 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Character.st: Added lookup table for speed

Wed Nov 25 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Rectangle.st: Changed #intersect to make it work ;-)
	* kernel/Builtins.st: Added String>>hash and ByteArray>>hash

Tue Nov 24 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: now uses ContextPart class>>#unwind
	mechanism
	* compiler/STSymTable.st: perfected treating of class pools (now
	they're exactly the same as a shared pool dictionary)
	* examples/PushBack.st: Added #position and #position:
	* kernel/Metaclass.st: Added methods for class pool/shared pools,
	which delegate their work to Class

Mon Nov 23 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: added STDoitCompiler
	* kernel/BlkContext.st: switched superclass to ContextPart.
	* kernel/MthContext.st: switched superclass to ContextPart.
	* kernel/ContextPart.st: created.

Wed Nov 18 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* examples/Debugger.st: added experimental bytecode simulator.

Sat Nov 14 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CStruct.st: Changed to subclass of CObject and changed
	implementation of inspection for easier port to Blox.

Tue Nov 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/UndefObject.st: Added class creation methods.
	* kernel/Object.st: Added class declaration now that nil defines
	class creation statements
	* kernel/Autoload.st: Class directly created as subclass of nil.

Fri Nov  6 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STToken.st: Added code that supports new methods to
	find out the class of a token.
	* compiler/STParser.st: Switched most uses to isMemberOf: to
	special and faster methods.  Split into STParser and STFileInParser
	to support other cases when parsing is necessary

Thu Nov  5 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Metaclass.st: Added instanceVariableNames: for class-instance
	variables. Modified mutation policy to be a bit more restrictive but
	logical.

Wed Oct 21 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* examples/CompFileSeg.st: created.

Thu Oct 15 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/CObject.st: Added CSmalltalk.  Turned to a variable word
	subclass to make access to the address simpler and not cause SIGSEGVs
	on trying to access the address instance variable as an object
	* kernel/CType.st: Added various storeOn: methods, and classes
	CScalarCType and CSmalltalkCType

Tue Oct 13 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Float.st: Changed to a variable byte subclass.
	* kernel/Number.st: Added #zero and #unity

Mon Oct 12 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkClosure.st: created from BlkContext.st.
	* kernel/SeqCollect.st: Switched to copyEmpty: about a week ago.
	Now tried to change to:do: to whileTrue: in a desperate attempt
	at gaining more speed ;-)
	* kernel/BlkContext.st: Changed to support blocks as closures

Sun Oct 11 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Collection.st: Added copyEmpty:, copyEmpty now uses it.
	* kernel/Dictionary.st: Changed growing mechanism and other methods
	to use #copyEmpty: Also, now #keyAtValue:ifAbsent: uses	identity
	to compare objects. This was marked as a 'questionable' change in
	Brad Diller's extras.st file, but it turns out that most Smalltalks
	implement this method this way.
	* kernel/OrderColl.st: Switched to using copyEmpty: when growing.
	* kernel/Set.st: Switched to using copyEmpty: when growing.

Sat Oct 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/LargeInt.st: removed 'self sign = 0' tests, replaced
	with overridden methods in LargeZeroInteger.

Thu Oct  8 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ArrayColl.st: Moved here the growing methods that used to
	be in SequenceableCollection. Why weren't they
	here? OrderedCollection has a different growing
	system...

Sun Oct  4 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Behavior.st: Fixed symbol that was being printed instead of
	nextPutAll:'d in definition of C functions.

Thu Oct  1 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STParser.st: Added byte array constants
	* compiler/STTok.st: Fixed number parsing, changed parseError: to
	error:

Wed Sep 30 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Rectangle.st: Made #origin, #corner, #bottomRight and
	#topLeft return copies of the origin and corner. This is for
	consistency with #bottomLeft, #topCenter, etc.
	* kernel/TokenStream.st: Removed a few methods whose implementation
	was the same as Stream's.

Tue Sep 29 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Object.st: Switched dependancy mechanism to use IdentitySets.
	Also declared Dependencies as part of Smalltalk.

Mon Sep 28 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Set.st: Changed storeOn: to avoid hard coding Set as the
	class name.
	* kernel/CStruct.st: Changed to a fixed subclass. Added 'put'
	methods.
	* kernel/IdentitySet.st: Created.
	* kernel/Directory.st: Promoted to kernel from cxtnsn.
	* kernel/File.st: Promoted to kernel from cxtnsn.

Fri Sep 25 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ValueAdapt.st: created.

Fri Sep 18 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Time.st: Fixed possible secondClock overflow.
	Added #asSeconds
	* kernel/Date.st: Fixed possible secondClock overflow. Now it
	will overflow somewhen in 2038. Hope 64-bit machines are
	widespread enough by that time... I'll be 58.

Tue Sep 15 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: Added CObject>>free, String>>valueAt:,
	String>>valueAt:put:
	* kernel/Random.st: Changed algorithm.  Needed because, with new
	LargeInteger support, the old algorithm created a lot of temporary
	objects and caused a lot of GCs. This algorithm uses Floats; it
	has approximately the same chisquare as the old one. The performance
	is not as good as when it used small Integers, but better than
	LargeIntegers. There are algorithms which use small Integers without
	overflowing; I know about one of them, but it only works with 32 bit
	words and ours only have 30 bits.  Tell me if you can find one!

Mon Sep 14 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/BlkContext.st: Added accessr functions; there didn't seem to be a
	good reason why they weren't there in the first place.
	* kernel/MthContext.st: oops... methodClass instance variable was missing!
	* kernel/BlkContext.st: Added printOn: and backtrace methods
	* kernel/PosStream.st: Modified so that upTo:, upToAll:, skipTo:, upToEnd,
	skipToAll: operate unidirectionally on the receiver.  This is needed to
	make them work with special streams such as stdin.
	* kernel/MthContext.st: added printOn:, home and backtrace methods

Thu Sep 10 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: Added support for LargeIntegers. This
	included adding a 'fail' section to Integer>>asFloat. Also changed
	asObjectNoFail to return nil if bad OOP index.
	* kernel/WordMemory.st: Added LargeInteger support (well, actually
	just removed 'sorry, no LargeIntegers yet' errors); shifted to
	to bitShift: instead of * and // (which are slow with LargeIntegers).
	Also now #at:put: returns the stored value (which is what it was
	always supposed to do, like any other #at:put:).  Finally, the size
	of a word is now CLongSize instead of always 4 bytes.
	* kernel/Time.st: Fixed secondClock to use LargeIntegers.

Wed Sep  9 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/initialize.st: modified to initialize LargeInteger.

Tue Sep  8 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Builtins.st: Added Behavior>>#flushCache.
	* compiler/STParser.st: Fixed bugs which jumped out while testing the
	compiler (e.g. parseArrayLit returned OrderedCollections)
	* examples/Tokenizer.st: Created from Tok
	* compiler/STTok.st: Now subclass of Tokenizer; renamed to STTok
	* examples/PushBack.st: Removed recording capability, which was too
	expensive in terms of performance, and moved it to Tokenizer.
	* kernel/LargeInt.st: created.

Mon Sep  7 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/WriteStream.st: Changed the growing policy so that
	WriteStreams are more efficient at concatenating data.

Sun Sep  6 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/MethodInfo.st: Added setSourceCode: to support compiler.

Sat Sep  5 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* compiler/STCompiler.st: moved compilation policy to subclasses
	of STParseNode.  Now compile (which is called compile:) returns a
	CompiledMethod.  Added STFakeCompiler.
	* compiler/STCompLit.st: merged VMStorageLocations and VMSpecialIndices
	into VMOtherConstants, added VMSpecialMethods
	* compiler/STParseNodes.st: switched to a single node (STConstNode)
	for constants, cleaned up unused classes, renamed Selector to
	SelectorNode.  Added support for storing source code.

Thu Sep  3 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Set.st: Merged changes by Brad Diller to solve rehash bug.
	Added primAt:/primAt:put: to support subclasses that for example
	store data on disk or on a separate instance variable.
	* kernel/Float.st: Added #asFraction using a continued fractions
	algorithm (ugh!)
	* kernel/Date.st: Extended to make it more flexible.
	* kernel/Interval.st: Fixed bug in #size, returning negative sizes
	if step < 0.  Changed superclass to ArrayedCollection.
	* kernel/Fraction.st: Integrated changes.st
	* kernel/Behavior.st: Merged changes by Brad Diller
	* kernel/Builtins.st: Merged changes by Brad Diller
	* kernel/ClassDesc.st: Merged changes by Brad Diller
	* kernel/Metaclass.st: Merged changes by Brad Diller
	* kernel/Object.st: Merged changes by Brad Diller
	* kernel/IdentDict.st: Merged changes by Brad Diller to solve rehash
	bug
	* kernel/Dictionary.st: Merged changes by Brad Diller to solve rehash
	bug.  Also modified add: to resuse the existing Association if there
	is one, rather than always using the parameter.  Changed hashing so
	that hashing a dictionary that contains itself is not a problem.
	* kernel/Class.st: Merged corrections by Brad Diller
	* kernel/Association.st: Switched superclass to be Magnitude.  Added
	class equality test to Association>>#=
	* compiler/STParser.st: Switched to a single node for constants
	(STConstNode), two separate nodes for identifiers (STIdentifierNode
	and STSpecialIdentifierNode), changed pools quite a bit, prefixed
	ST to everything.
	* kernel/RunArray.st: created around January 97.
	* kernel/DirMessage.st: created.
	* kernel/ObjDumper.st: created around March 97.
	* compiler/STSymTable.st: modified heavily to support new code in
	STCompiler
	* kernel/ExcHandling.st: now uses SystemDictionary>>#halt. Thanks
	Brad Diller

Thu Sep  2 12:34:56 1998  Paolo Bonzini  (bonzini@gnu.org)

	*** Began development of version 1.6

Wed Jul 23 12:34:56 1997  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/ExcHandling.st: created.

Tue Apr 15 12:34:56 1996  Paolo Bonzini  (bonzini@gnu.org)

	* kernel/Set.st: Refactored to reduce duplicated code
	in Dictionary and IdentityDictionary.

Thu Sep 30 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	*** Version 1.1.5 released.

Sat Sep 16 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CType.st: Removed separate valueType defintion for
	pointers and arrays (returning eltCType); using the inherited
	version instead.
	* kernel/Fraction.st: Added storeOn:, cleaned up formatting a bit.
	* kernel/Class.st: Fixed a bug in subClass:... was saying 'words: true',
	which means that the object consists of non-gc'ed words.  subClass is
	pointers which are GC'ed, and saying word: true was just plain 100%
	wrong.

Sat Sep  9 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CType.st: Adjusted sizes of scalar types to use actual
	values for the platform instead of constant values that	Smalltalk
	made up.

Mon Sep  4 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* compiler/STParseNodes.st: Switched to being externally accessible
	instead of supporting internal access only.
	* kernel/Class.st: Incorporated (finally) Jim Fulton's fix to the =
	operator.
	* kernel/Object.st: Incorporated (finally) Jim Fulton's fixes to
	removeDependent:

Sun Sep  3 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* compiler/STCompLit.st: created.
	* compiler/STCompiler.st: created.
	* compiler/STSymTable.st: created.

Sat Aug 26 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Modified Behavior #new & friends (primitives
	70 & 71) to issue errors when they are used inappropriately
	(such as sending #new to an indexable class).

Sun Jul 23 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CStruct.st: Added struct datatypes int and uInt.

Sun Jul 16 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/Behavior.st: Fixed instsize to correctly shift by 4, now
	that bit 0 (st) is reserved for the hasFinalize flag.

Fri Jul 14 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/Metaclass.st: Fixed so that invalid variable names cannot
	be declared.

Mon May 29 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/Boolean.st: Fixed to have a simple deep copy and shallow
	copy.

Sun May  7 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CObject.st: Added usage of more machine size constants
	(float,long, ptr, double).

Sat May  6 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CStruct.st: Updated for new C type system.

Mon May  1 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CType.st: Changed CType>>cObjectType to return CObject
	instead of subclass responsibility.

Sat Apr 29 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CType.st: Added cObjectType -- may be replacing
	what the baseType method was, but this is more
	descriptive. Also added a new operation on CType
	instances to create a new CObject subclass from the
	CType instance.
	* kernel/CObject.st: Moved the creation of CType instances into
	CType. Removed forward declaring of CType instances from this
	file and changed the load order to load CObject first
	since it now has no dependencies on the CType symbols.
	* kernel/CType.st: Moved the creation of the instances of CType
	subclasses into this file -- makes more sense here.
	* kernel/CType.st: Removed baseType -- it appears to have no function
	now.

Sun Jan  8 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CObject.st: Converted to new types.
	* kernel/CObject.st: Fixed some bugs with pointer subtraction.

Mon Jan  2 12:34:56 1995  Steve Byrne  (sbb@gnu.org)

	* kernel/CType.st: Hacked for new type architecture.

Sat Oct  8 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added SystemDictionary>>growTo:

Thu Sep 15 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	*** Version 1.2.alpha1 released.

Tue Aug 30 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* examples/MemUsage.st: added header stuff
	* examples/PrtHier.st: added header stuff.

Sun Aug 21 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/Behavior.st: Adjusted tests for low bit int marking.
	* kernel/CompildMeth.st: Fixed for low bit int marking

Sun Aug 14 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Fixed ~~ on integers to return true (the
	objects did not match) if the primitve failed.

Sun Jul 24 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Added class>>require:

Sun Jul 10 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/ClassDesc.st: Fixed instVarNames to deal properly with
	classes which have no instance variables.
	* kernel/MthContext.st: Added accessr functions; there didn't seem
	to be a good reason why they weren't there in the first place.
	* kernel/Class.st: Fixed allClassVarNames and allSharedPools to
	properly deal with nil collections of class variables or
	pool dictionaries.

Sat Jul  2 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/SysDict.st: Fixed dependenciesAt: to return nil if there
	was no dependency already present.

Sun Jun 12 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/CObject.st: added adjPtrBy:, derefAt:, etc. (finally).

Sat Apr 30 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added incrBy:

Sat Apr  9 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/CObject.st: Added CScalar, value: methods on scalar
	instances as a shorthand notation for instance creation, started
	folding in the effects of the CType new method.
	* kernel/CType.st: Added alloc:type:

Tue Apr  5 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added CObject>>alloc:type:

Sat Mar 26 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/WordMemory.st: Added little endian support.

Sun Feb  6 12:34:56 1994  Steve Byrne  (sbb@gnu.org)

	* kernel/ProcSched.st: Fixed the 'symbolic constants' for priority to
	actually return their values, instead of returning
	self (duh!).

Sun Oct 17 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* kernel/Message.st: Added accessors for the components.

Sat Oct 16 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* kernel/ProcSched.st: Fixed yield to operate correctly in the
	presence of repeated higher priority interrupts.
	* kernel/ClassDesc.st: Fixed addInstVarName: specially treat meta
	classes and grow their single class instances when new instance
	variables are added to the class.

Sun Oct  3 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* kernel/ArrayColl.st: Put in #copy, to use replace from to get the
	nice efficient copy that we can have if we are an array.

Fri Oct  1 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Fixed removeKey:ifAbsent: to evaluate the
	ifAbsent block if the key actually was absent.  Previously,
	this was being evaludated only if the entire dictionary was full
	and the key was not found.

Sun Sep 26 12:34:56 1993  Steve Byrne  (sbb@gnu.org)

	* kernel/Collection.st: Made exceptionBlock's value in
	detect:ifNone: be returned, so the exception handler could just
	yield a value if it wanted.
	* kernel/String.st: fixed some methods to check its second
	operand's type before calling into primitives which don't check type.

Fri Nov 27 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* kernel/Class.st: Fixed variableSubclass:... to correctly mark new
	subclasses as being pointers and indexable, but not words (words
	implies unscanned raw data).
	* cxtnsn/DLD.st: Added support to DLD for searching through a list of
	libraries to resolve references, with the default being libc.

Mon May 25 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* kernel/Browser.st: Added support for Emacs caching class names

Sun Feb 23 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* kernel/String.st: Added asInteger and asByteArray.

Sun Feb 16 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* kernel/Autoload.st: Created in the 1.1 timeframe
	* kernel/Fraction.st: Created in the 1.1 timeframe
	* examples/Publish.st: created  Feb  92.
	* kernel/Browser.st: created a while ago
	* kernel/CType.st: created summer 90
	* kernel/CObject.st: created summer 90.
	* kernel/CStruct.st: created summer 90.

Sat Feb 15 12:34:56 1992  Steve Byrne  (sbb@gnu.org)

	* kernel/Collection.st: Switched the collection creating enumerators
	to use the copyEmpty message, so it can be overridden by subclasses
	(like SortedCollection) when copying empty involves more than
	just doing a new.

Sat Dec 14 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/ByteArray.st: Added asString -- generally useful functionality,
	but especially for STIX.

Thu Nov 28 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added SystemDictionary byteCodeCounter.
	* kernel/ByteArray.st: Added growSize method -- 10 wasn't right, and
	we should probably base the grow size on the size of the object in
	question.
	* kernel/ByteArray.st: Switched shallowCopy to use faster primitives.

Sat Nov  2 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Fixed == and ~~ definitions for Integer to fail
	if the integers aren't = (including the case where they aren't both
	integers).  Used to retry:coercing: which lost badly.

Sun Oct 20 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added support for user level control of GC growth
	rate flags.

Sun Sep 22 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Added #popen:dir:ifFail: and #open:mode:ifFail:
	so that open failures can be explicitly handled.
	Thanks to Michael Richardson for the brilliant idea!
	* kernel/Builtins.st: Switched FileStream to returning nil on failure,
	so that higher level methods can chose to deal with failure.  This was
	due to a brilliant observation by Michael Richardson.  Now that higher
	level functions can handle failure, things like search paths, etc,
	can be trivially implemented.

Sun Sep 15 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/CompildMeth.st: Adjusted to account for larger numbers of
	primitives, literals, and temporaries.

Sun Jul 28 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Fixed #= to check argument class.  Also
	fixed printing and storing to use cascaded messages.
	* kernel/Set.st: checks argument type better.
	* kernel/Bag.st: now checks args better.
	* kernel/IdentDict.st: Fixed #= to check argument class.  Converted
	to use cascaded printing.

Fri Jul 19 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* cxtnsn/DLD.st: created

Fri Jul 12 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Date.st: Added methods for comparing, and for hashing
	dates. Also fixed storing to use cascaded messages.
	* kernel/Time.st: Added methods for comparing, including #= and #hash.

Wed Jul 10 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Rectangle.st: Added #= and #hash methods.
	* kernel/Point.st: Added = for Points (= from Object isn't right)
	* kernel/Stream.st: Added store: for streams (can't imagine why it
	wasn't here before).
	* kernel/Rectangle.st: Altered the printing and storing to use
	cascaded messages.

Fri Jul  5 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Added fileIn:line:from:at: so that when
	Emacs sends out an expression or a method definition to Smalltalk
	the error messages accurately report the line number.
	* kernel/Builtins.st: Added fileInLine:fileName:at: to improve error
	reporting and recording of file position information for later
	browsing.

Wed Jun 26 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/False.st: Fixed ifFalse: to send value to falseBlock

Thu Jun  6 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Fixed open and popen to use self new instead
	of FileStream explicitly.
	* kernel/Builtins.st: Switched declare and execution tracing from
	being direct primitives to a more general primitive mechanism.

Sat May 18 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Delay.st: Actually implemented the thing.

Sat Apr 20 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/SysDict.st: Added some methods for testing and modifying
	implementation specific features.
	* kernel/Behavior.st: added methodsFor:ifFeatures:

Mon Mar 25 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Object.st: Added -> operator.

Sun Mar 24 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Float.st: Fixed up floating point printing to take account of
	the number of digits printed in the integer part when
	printing the fractional part.

Sat Mar 23 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added Integer primitives == and ~~ for more
	efficient operation.

Sat Mar 16 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Array.st: Fixed class creation to be separate statement from
	class commenting.
	* kernel/ArrayColl.st: Class creation now separate statement.
	* kernel/Association.st: Class creation now separate statement.
	* kernel/Bag.st: Class creation now separate statement.
	* kernel/Behavior.st: Class creation now separate statement.
	* kernel/BlkContext.st: Class creation now separate statement.
	* kernel/Boolean.st: Class creation now separate statement.
	* kernel/ByteArray.st: Class creation now separate statement.
	* kernel/ByteMemory.st: Class creation now separate statement.
	* kernel/Character.st: Class creation now separate statement.
	* kernel/Class.st: Class creation now separate statement.
	* kernel/ClassDesc.st: Class creation now separate statement.
	* kernel/Collection.st: Class creation now separate statement.
	* kernel/CompildMeth.st: Class creation now separate statement.
	* kernel/Date.st: Class creation now separate statement.
	* kernel/Dictionary.st: Class creation now separate statement.
	* kernel/False.st: Class creation now separate statement.
	* kernel/FileSegment.st: Class creation now separate statement.
	* kernel/Float.st: Class creation now separate statement.
	* kernel/IdentDict.st: Class creation now separate statement.
	* kernel/Integer.st: Class creation now separate statement.
	* kernel/Interval.st: Class creation now separate statement.
	* kernel/Link.st: Class creation now separate statement.
	* kernel/LinkedList.st: Class creation now separate statement.
	* kernel/Magnitude.st: Class creation now separate statement.
	* kernel/MappedColl.st: Class creation now separate statement.
	* kernel/Memory.st: Class creation now separate statement.
	* kernel/Message.st: Class creation now separate statement.
	* kernel/MethodInfo.st: Class creation now separate statement.
	* kernel/MthContext.st: Class creation now separate statement.
	* kernel/Number.st: Class creation now separate statement.
	* kernel/PosStream.st: Class creation now separate statement.
	* kernel/ProcSched.st: Class creation now separate statement.
	* kernel/Process.st: Class creation now separate statement.
	* kernel/RWStream.st: Class creation now separate statement.
	* kernel/Random.st: Class creation now separate statement.
	* kernel/ReadStream.st: Class creation now separate statement.
	* kernel/Semaphore.st: Class creation now separate statement.
	* kernel/SeqCollect.st: Class creation now separate statement.
	* kernel/Set.st: Class creation now separate statement.
	* kernel/SortCollect.st: Class creation now separate statement.
	* kernel/Stream.st: Class creation now separate statement.
	* kernel/String.st: Class creation now separate statement.
	* kernel/SymLink.st: Class creation now separate statement.
	* kernel/Symbol.st: Class creation now separate statement.
	* kernel/SysDict.st: Class creation now separate statement.
	* kernel/Time.st: Class creation now separate statement.
	* kernel/TokenStream.st: Class creation now separate statement.
	* kernel/True.st: Class creation now separate statement.
	* kernel/UndefObject.st: Class creation now separate statement.
	* kernel/WordMemory.st: Class creation now separate statement.
	* kernel/WriteStream.st: Class creation now separate statement.

Mon Mar  4 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Added verbose flag.

Sat Feb 16 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Override the #new method from builtins when
	this file is loaded so that subclasses of Dictionary have a proper
	#new method instead of the built-in one that only creates Dictionary instances.

Thu Feb  7 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/Collection.st: Fixed detect: to return the value
	that detect:ifNone: returns.

Mon Feb  4 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/String.st: Fixed duplicate fileName definition to
	be filePos

Tue Jan 22 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/CFuncs.st: Added putenv.

Tue Jan  1 12:34:56 1991  Steve Byrne  (sbb@gnu.org)

	* kernel/WriteStream.st: Added print: and store: so that printing
	and storing can be cascaded.

Sat Dec 29 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/SeqCollect.st: Added = test to check sub elements for equality.
	* kernel/SeqCollect.st: Added hash function.
	* kernel/ArrayColl.st: Removed = and hash (put them into
	SequenceableCollection).

Sat Nov 10 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/ClassDesc.st: Implemented compile:classified: and
	compile:classified:notifying:.
	* kernel/Behavior.st: Implemented compile:notifying:

Fri Nov  9 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Integer.st: Converted to use fractions.
	* kernel/Number.st: Put in changes for fractions.

Mon Nov  5 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Object.st: Fixed bug with addDependent: -- syntax error.

Thu Nov  1 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Behavior.st: Fixed isBytes to return true only if the
	object is not pointers and not words.

Sat Sep 22 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/False.st: Changed printOn: to reflect changes in
	String>>#printOn:.
	* kernel/True.st: Changed printOn: to reflect new String printOn:
	(so we can't use it any more).
	* kernel/Date.st: Changed to reflect the changes required by
	String>>#printOn:.
	* kernel/Character.st: Changed character to always print with a
	leading $.
	* kernel/CompildMeth.st: Fixed printOn method to account for change to
	String printOn:.
	* kernel/Class.st: Implemented classVarNames and allClassVarNames.
	Implemented sharedPools and allSharedPools.

Fri Sep 21 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Bag.st: Removed printOn: method; the one from Collection does
	the right thing.
	* kernel/Set.st: Removed printOn: method; the one from Collection
	is fine.
	* kernel/LinkedList.st: Removed printOn: method; the one from
	Collection should be ok.  Also, the storeOn: method from Collection
	should be ok.
	* kernel/ArrayColl.st: Removed storeOn: method; doesn't seem to be the
	right thing.
	* kernel/Integer.st: Fixed printOn: to reflect the fact that String
	printOn: no longer "does the right thing".
	* kernel/Collection.st: Fixed store: to be storeOn:
	* kernel/ClassDesc.st: Fixed the implementation of instVarNames to just
	return the variables defined by the current class,
	and added implementatinos of allInstVarNames and
	subclassInstVarNames.
	* kernel/Array.st: Added printOn: and storeOn: methods.
	* kernel/Symbol.st: Added printOn: to print the un-sharped version of
	the symbol, since string printOn: changed.
	* kernel/Behavior.st: Changed allSubclassesDo: to use ALL subclasses,
	both direct and indirect.
	* kernel/Dictionary.st: Changed printOn: to print the associations directly.
	* kernel/String.st: Changed printOn: to print with quote marks.
	On re-reading the documentation it appears as if this
	is the proper behavior (sigh).
	* kernel/UndefObject.st: Fixed due to String printOn: change.

Thu Sep 20 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/SeqCollect.st: Fixed indexOfSubCollection (it was off by one and
	did too much computation.
	* kernel/Float.st: Fixed storeOn: to not be recursive.

Sun Sep 16 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Behavior.st: Implemented whichSelectorsReferTo: and
	scopeHas:ifTrue:.

Fri Aug  3 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added definition of CObject class alloc:.

Tue May 22 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	*** Version 1.1.1 released (I think. I added this on May 10th, 1999... --- pb)

Sun May 20 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/WriteStream.st: Fixed semantics of write streams so that they return
	only the characters that have been written to them.
	* kernel/RWStream.st: Fixed to accomodate changes in WriteStream.

Sat May 19 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: Rewrite contents to take advantage of the new
	FileStream>>size method.
	* kernel/Stream.st: Added print: for streams.

Wed May 16 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Character.st: Changed from being variableSubclass to
	variableWordSubclass.
	* kernel/Metaclass.st: Changed the implementation of name:... to
	try to preserve an existing class (if possible).
	The original code exists in newMeta:...
	* kernel/Class.st: Improved error checking: you now cannot create a
	subclass of a class whose type is not compatible
	(i.e. non-variable subclass of a variable byte class).
	* kernel/Class.st: Minor changes to support preserving class
	definitions as long as possible (i.e. if you re-invoke the class
	definition method, it tries to re-use the existing class if
	possible).

Mon May 14 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/TokenStream.st: removed isWhiteSpace:;replaced uses with
	Character isSeparator.

Sat Apr  7 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Modified at:put: to resuse the existing
	Association if there is one, rather than create a new one all
	the time.  This was causing lossage when setting global variables
	in Smalltalk that previous usages weren't being changed.

Sun May  6 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Fixed grow method to preserve associations
	in use in the dictionary instead of making new ones.  This should
	be faster, and doesn't break compiled methods that reference global
	variables when Smalltalk grows.

Thu Apr 26 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Object.st: Fixed shallowCopy to send new messages to the
	object's class instead of the object itself.

Wed Apr 25 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Integer.st: Fixed (oh...happy birthday, Integer.st!)
	bitInvert.  After fixing the lexer to be pickier about integer
	literals that were too large to be represented as Smalltalk
	literals, the previous code (which xored with 7fffffff) broke,
	so we xor -1.

Tue Apr 24 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Dictionary.st: Fix at:ifAbsent: to deal with failure
	better (and be a tad more efficient).  Kudos (or BarNone's,
	depending on preference) to Andy Valencia.

Sun Apr 22 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/SysDict.st: Fixed Dependencies to be an IdentityDictionary
	instead of a regular Dictionary.  This has better semantics and
	is faster.

Thu Apr 19 12:34:56 1990  dougm

	* kernel/Rectangle.st: Initial definitions for Rectangle
	class (needs Point)

Mon Apr 16 12:34:56 1990  dougm

	* kernel/Point.st: Created basic Point class.

Sun Apr 15 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added sqrt primitive (I'm sure this was here
	before) must have got lost during breaking out from builtins.

Sat Apr  7 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added declare tracing primitive.

Sun Apr 15 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Float.st: Added asFloat...I could have sworn this was
	already here...must have been lost in an edit.

Fri Apr 20 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added SystemDictionary debug to help out
	with DBX level debugging.

Sun Feb 11 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Boolean.st: Converted to printOn: representation.

Sat Jan 13 12:34:56 1990  Steve Byrne  (sbb@gnu.org)

	* kernel/Class.st: Began experimental addition of actual class
	definitions.
	* kernel/Builtins.st: Experimental Class self-definition.

Wed Dec 27 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/CompildMeth.st: Added real print method for compiled
	methods.

Mon Dec 25 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* examples/Debugger.st: created.

Fri Dec 22 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/SymLink.st: Created.

Tue Dec 19 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added filein primitive.
	* kernel/FileStream.st: added fileIn: and primitive file in.

Sat Sep 23 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/ClassDesc.st: fileOutCategory: is dangerous, so I make it
	write to a subdirectory called './categories'.

Tue Sep 19 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/SortCollect.st: Changed to use real method categories.
	* kernel/Stream.st: Changed to use real method categories.
	* kernel/Symbol.st: Changed to use real method categories.
	* kernel/Time.st: Changed to use real method categories.
	* kernel/TokenStream.st: Changed to use real method categories.
	* kernel/True.st: Changed to use real method categories.
	* kernel/UndefObject.st: Changed to use real method categories.
	* kernel/WriteStream.st: Changed to use real method categories.
	* kernel/Number.st: Converted to use real category strings.
	* kernel/PosStream.st: Converted to use real method categories
	* kernel/Process.st: Converted to use real method categories
	* kernel/Object.st: Converted to use real method categories.
	* kernel/OrderColl.st: Converted to use real method categories.
	* kernel/Random.st: Converted to use real method categories.
	* kernel/ReadStream.st: Converted to use real method categories.
	* kernel/Semaphore.st: Converted to use real method categories.
	* kernel/SeqCollect.st: Converted to use real method categories.
	* kernel/Set.st: Converted to use real method categories.

Wed Sep  6 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/CompildMeth.st: Added lots of methods: inspect, =, hash,
	methodCateogry, methodSourceCode, methodSourceString,
	and some private accessors such as bytecodeAt:.

Sun Sep  3 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/String.st: added asString for method source package
	* kernel/FileSegment.st: created.
	* kernel/MethodInfo.st: created.

Sat Aug 12 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Added process and semaphore builtins.
	* kernel/Time.st: Implemented many methods.  The book is
	exceptionally vague here, so please feel free to change the behavior
	to something which is more correct.

Wed Jul 12 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/TokenStream.st: created.

Sat Jul  8 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/CFuncs.st: Created.

Tue Jul  4 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Object.st: Added support for dependence relationships. (-:
	how appropriate: on INdependence day :-)
	* kernel/SysDict.st: added initBlocks methods.

Mon Jul  3 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Random.st: created.

Sun Jun  4 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Stream.st: Made more of the methods defined here, but the
	class itself stays abstract; no implementations are given
	for next, nextPut:, etc.

Mon May 29 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/ByteMemory.st: created.
	* kernel/Memory.st: created.
	* kernel/WordMemory.st: created.

Wed May 24 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/initialize.st: created.

Sun May 21 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/FileStream.st: created.

Tue Apr 25 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Array.st: created.
	* kernel/ArrayColl.st: created.
	* kernel/Association.st: created.
	* kernel/Bag.st: created.
	* kernel/Behavior.st: created.
	* kernel/BlkContext.st: created.
	* kernel/Boolean.st: created.
	* kernel/ByteArray.st: created.
	* kernel/Character.st: created.
	* kernel/Class.st: created.
	* kernel/ClassDesc.st: created.
	* kernel/Collection.st: created.
	* kernel/CompildMeth.st: created.
	* kernel/Date.st: created.
	* kernel/Delay.st: created.
	* kernel/Dictionary.st: created.
	* kernel/False.st: created.
	* kernel/Float.st: created.
	* kernel/IdentDict.st: created.
	* kernel/Integer.st: created.
	* kernel/Interval.st: created.
	* kernel/Link.st: created.
	* kernel/LinkedList.st: created.
	* kernel/Magnitude.st: created.
	* kernel/MappedColl.st: created.
	* kernel/Message.st: created.
	* kernel/Metaclass.st: created.
	* kernel/MthContext.st: created.
	* kernel/Number.st: created.
	* kernel/Object.st: created.
	* kernel/OrderColl.st: created.
	* kernel/PosStream.st: created.
	* kernel/ProcSched.st: created.
	* kernel/Process.st: created.
	* kernel/RWStream.st: created.
	* kernel/ReadStream.st: created.
	* kernel/Semaphore.st: created.
	* kernel/SeqCollect.st: created.
	* kernel/Set.st: created.
	* kernel/SharedQueue.st: created.
	* kernel/SortCollect.st: created.
	* kernel/Stream.st: created.
	* kernel/String.st: created.
	* kernel/Symbol.st: created.
	* kernel/SysDict.st: created.
	* kernel/Time.st: created.
	* kernel/True.st: created.
	* kernel/UndefObject.st: created.
	* kernel/WriteStream.st: created.

Mon Feb  6 12:34:56 1989  Steve Byrne  (sbb@gnu.org)

	* kernel/Builtins.st: Created.

