/*    EPZip - the simple free distribution preparing tool
**    Copyright (C) 1997  Esa Peuha

**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation; either version 2 of the License, or
**    (at your option) any later version.

**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.

**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include "epzip.h"

void deflate(char *in_buffer, char **out_buffer,
	     unsigned int in_bytes, unsigned int *out_bytes)
{
  struct file_el substfile;
  FILE *codefile;
  if(in_buffer == NULL || in_bytes == 0)
    return;

  /* find matching strings and substitute them */
  substitute(in_buffer, in_bytes, &substfile);

  /* replace everything with Huffman codes */
  codefile = codify(&substfile);

  if(codefile != NULL)
    {

      /* read data into memory */

      *out_bytes = ftell(codefile);
      if((signed) *out_bytes == -1)
	{
	  perror("epzip: codefile error");
	  exit(1);
	}

      if(*out_bytes == 0)
	{
	  fprintf(stderr, "epzip: internal error: deflation failure\n");
	  exit(1);
	}

      *out_buffer = malloc(*out_bytes);
      if(*out_buffer == NULL)
	{
	  fprintf(stderr, "epzip: can't allocate deflated file buffer\n");
	  exit(1);
	}

      fseek(codefile, 0, SEEK_SET);
      fread(*out_buffer, 1, *out_bytes, codefile);
      fclose(codefile);

    }
}
