// MakeDialog.cpp : implementation file
//

#include "stdafx.h"
#include "DFE32.h"
#include "MakeDialog.h"
#include "mainfrm.h"
#include "messageview.h"
#include "postmessage.h"
#include <direct.h>
#include "extern.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
UINT MakeProc2(LPVOID);
CString WorkingDir(CString str);
HANDLE ForkProcess(char *cmd, PHANDLE inH, PHANDLE outH, PHANDLE errH);
/////////////////////////////////////////////////////////////////////////////
// CMakeDialog dialog


CMakeDialog::CMakeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMakeDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMakeDialog)
	m_Makefile = _T("");
	//}}AFX_DATA_INIT
}


void CMakeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMakeDialog)
	DDX_Text(pDX, IDC_EDIT1, m_Makefile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMakeDialog, CDialog)
	//{{AFX_MSG_MAP(CMakeDialog)
	ON_BN_CLICKED(IDC_MAKEBROWSE_BUTTON, OnMakebrowseButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMakeDialog message handlers

void CMakeDialog::OnMakebrowseButton() 
{
	CFileDialog filedialog(TRUE, NULL, NULL, OFN_HIDEREADONLY | 
		OFN_OVERWRITEPROMPT, 
		"Makefiles (*.*)|*.*||");
	if (filedialog.DoModal() == IDOK)
	{
		m_Makefile = filedialog.GetPathName();
		UpdateData(FALSE);
	}	
}

BOOL CMakeDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CMainFrame *frame = (CMainFrame *)AfxGetMainWnd();
	m_Makefile = frame->lastmake;
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMakeDialog::OnOK() 
{
	UpdateData(TRUE);
	CMainFrame *frame = (CMainFrame *)AfxGetMainWnd();
	frame->lastmake = m_Makefile;
	CString *make = new CString; 
	*make = m_Makefile;
	AfxBeginThread(MakeProc2, make);
	CDialog::OnOK();
}

UINT MakeProc2(LPVOID make)
{
	CString *makefile = (CString *)make;
	_chdir(WorkingDir(*makefile).GetBuffer(500));
	CString output, temp;
	char buffer[5000];
	memset(buffer, '\0', 4000);
	HANDLE threadhandle, inp, out, err;
	DWORD number;
	CString commandline = makepath;
	commandline += " -f ";
	commandline += *makefile;
	threadhandle = 
		ForkProcess(commandline.GetBuffer(1000),&inp,&out,&err);
	WaitForSingleObject(threadhandle, INFINITE);
	PeekNamedPipe(out,NULL,NULL,NULL,&number,NULL);
	if (number != 0)
	{
		output = "Output from make:";
		PostOutput(output, TRUE);
		ReadFile(out, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	memset(buffer, '\0', 4000);
	PeekNamedPipe(err,NULL,NULL,NULL,&number,NULL);
	if (number == 0)
	{
		output = "No errors recieved from make";
		PostOutput(output, TRUE);
	}
	else
	{
		output = "Errors recieved from make:";
		PostOutput(output, TRUE);
		ReadFile(err, buffer, 4000, &number, NULL);
		temp = buffer;
		while (1)
		{
			if (temp.Find('\n') != -1)
			{
				output = temp.Left(temp.Find('\n') - 1);
				temp = temp.Right(temp.GetLength() - (temp.Find('\n') + 1));
				PostOutput(output, FALSE);
				if (temp.Find('\n') == -1)
				{
					PostOutput(temp, FALSE);
					break;
				}
			}
			else
			{
				PostOutput(temp, FALSE);
				break;
			}
		}
	}
	output = "Ending make";
	PostOutput(output, TRUE);
	delete make;
	return TRUE; 
}

HANDLE ForkProcess(char *cmd, PHANDLE inH, PHANDLE outH, PHANDLE errH) 
{
	SECURITY_ATTRIBUTES lsa;
	STARTUPINFO si;
	PROCESS_INFORMATION pi; 
	HANDLE ChildIn;
	HANDLE ChildOut;
	HANDLE ChildErr;
	lsa.nLength = sizeof(SECURITY_ATTRIBUTES);
	lsa.lpSecurityDescriptor = NULL;
	lsa.bInheritHandle = TRUE;
	CreatePipe(&ChildIn, inH, &lsa, 0);
	CreatePipe(outH, &ChildOut, &lsa, 0);
	CreatePipe(errH, &ChildErr, &lsa, 0);
	si.cb=sizeof(STARTUPINFO);
	si.lpReserved = NULL;
	si.lpTitle = NULL;
	si.lpDesktop = NULL;
	si.dwX = si.dwY = si.dwYSize = si.dwXSize = 0;
	si.dwFlags = STARTF_USESTDHANDLES |  STARTF_USESHOWWINDOW;
	si.hStdInput = ChildIn;
	si.hStdOutput= ChildOut;
	si.hStdError = ChildErr;
	si.wShowWindow = SW_HIDE;
	si.lpReserved2 = NULL;
	si.cbReserved2 = 0;
	CreateProcess(NULL, cmd, NULL, NULL, TRUE,
		NORMAL_PRIORITY_CLASS, NULL,
		NULL, &si, &pi);
	CloseHandle(ChildIn);
	CloseHandle(ChildOut);
	CloseHandle(ChildErr);
	return(pi.hProcess);
}
