/* $Id: specpath.c,v 1.3 2003/03/02 18:44:09 richdawe Exp $ */

/*
 * specpath.c - Test program for libpakke's isspecialpath function
 * Copyright (C) 2002, 2003 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libpakke/util.h>

typedef struct {
  const char *path;
  const int   special;
} testcase_t;

static testcase_t testcases[] = {
#ifdef __DJGPP__
  /* Path components that don't map to real paths */
  { "/dev", 1 },
  { "/dev/", 1 },
  { "/dev/something", 1 },
  { "/dev/something/", 1 },
  { "/dev/env", 1 },
  { "/dev/env/", 1 },

  /* Paths that map to real paths */
  { "/dev/env/DJDIR", 0 },
  { "/dev/env/DJDIR/", 0 },
  { "/dev/c", 0 },
  { "/dev/c/", 0 },
  { "/develop", 0 },
  { "/develop/", 0 },
#endif /* __DJGPP__ */
  { NULL, 0 }
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  int verbose = 0;
  int ok = 1; /* Succeed by default */
  int i, ret;

  /* Verbose operation, for manual testing. */
  if (   (getenv("VERBOSE") != NULL)
      && (strcmp(getenv("VERBOSE"), "n") != 0))
    verbose = 1;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Verbose operation, for manual testing. */
    if (   (strcmp(argv[i], "--verbose") == 0)
	|| (strcmp(argv[i], "-v") == 0))
      verbose = 1;
  }

  /* Run the test cases */
  for (i = 0; testcases[i].path != NULL; i++) {
    ret = isspecialpath(testcases[i].path);

    if (verbose)
      printf("Test case %d: %s: ", i, testcases[i].path);

    if (ret == testcases[i].special) {
      if (verbose)
	printf("OK - found %s\n", ret ? "special" : "non-special");
    } else {
      if (verbose) {
	printf("FAILED - found %s, expected %s\n",
	       ret                  ? "special" : "non-special",
	       testcases[i].special ? "special" : "non-special");
      }

      /* Failed */
      ok = 0;
    }
  }

  if (!ok)
    return(EXIT_FAILURE);

  return(EXIT_SUCCESS);
}
