/* Copyright (C) 2008 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2003 DJ Delorie, see COPYING.DJ for details */
#include <libc/stubs.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <io.h>

#include "../include/libc/fd_props.h"
#include "libsupp.h"

int libsupp_fchdir_2_03(int _fd);
int libsupp___chdir_2_03(const char *_mydirname);


int
libsupp_fchdir_2_03(int fd)
{
  const char *filename = libsupp___get_fd_name(fd);
  const int   flags    = libsupp___get_fd_flags(fd);

  /* Check that it's a valid file descriptor. */
  if (_get_dev_info(fd) == -1)
    return (-1);

  /* Is it actually a directory? */
  if (((flags & FILE_DESC_DIRECTORY) == 0) || (filename == NULL))
  {
    errno = ENOTDIR;
    return (-1);
  }

  return (libsupp___chdir_2_03(filename));
}
