/* Copyright (C) 2009 DJ Delorie, see COPYING.DJ for details */
#include <stdlib.h>
#include "libsupp.h"

size_t
libsupp_mbrtowc(wchar_t *pwc, const char *s, size_t n, libsupp_mbstate_t *ps)
{
  int ret_val = (s == NULL) ? libsupp_mbtowc(NULL, "", 1) : libsupp_mbtowc(pwc, s, n);


  if (ret_val == -1)
  {
    ps->__count = 0;
    return (size_t)(-1);
  }
  else
    return (size_t)ret_val;
}
