/* downloads-directory-provider.c generated by valac 0.38.8, the Vala compiler
 * generated from downloads-directory-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_DOWNLOADS_DIRECTORY_MONITOR (downloads_directory_monitor_get_type ())
#define DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor))
#define DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))
#define IS_DOWNLOADS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define IS_DOWNLOADS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOWNLOADS_DIRECTORY_MONITOR))
#define DOWNLOADS_DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorClass))

typedef struct _DownloadsDirectoryMonitor DownloadsDirectoryMonitor;
typedef struct _DownloadsDirectoryMonitorClass DownloadsDirectoryMonitorClass;
typedef struct _DownloadsDirectoryMonitorPrivate DownloadsDirectoryMonitorPrivate;
enum  {
	DOWNLOADS_DIRECTORY_MONITOR_0_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY,
	DOWNLOADS_DIRECTORY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _DownloadsDirectoryMonitorProcessEventData DownloadsDirectoryMonitorProcessEventData;

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _DownloadsDirectoryMonitor {
	DataProvider parent_instance;
	DownloadsDirectoryMonitorPrivate * priv;
};

struct _DownloadsDirectoryMonitorClass {
	DataProviderClass parent_class;
};

struct _DownloadsDirectoryMonitorPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	gchar* downloads_path;
	GFile* downloads_directory;
	GFileMonitor* monitor;
	gchar** ignored_actors;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
};

struct _DownloadsDirectoryMonitorProcessEventData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	DownloadsDirectoryMonitor* self;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event_type;
	GFileMonitorEvent _tmp0_;
	gchar* uri;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	GFileInfo* subject_info;
	GFileInfo* _tmp8_;
	GFile* _tmp9_;
	GFileInfo* _tmp10_;
	GFileInfo* _tmp11_;
	gboolean _tmp12_;
	GFileInfo* _tmp13_;
	gboolean _tmp14_;
	GFileInfo* _tmp15_;
	gboolean _tmp16_;
	GError* err;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	gchar* mimetype;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* origin;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* basename;
	GFile* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ZeitgeistSubject* subject;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	ZeitgeistSubject* _tmp40_;
	gchar* actor;
	gchar* _tmp41_;
	ZeitgeistEvent* event;
	const gchar* _tmp42_;
	ZeitgeistEvent* _tmp43_;
	ZeitgeistEvent* _tmp44_;
	ZeitgeistSubject* _tmp45_;
	ZeitgeistEvent* _tmp46_;
	GPtrArray* events;
	GPtrArray* _tmp47_;
	GPtrArray* _tmp48_;
	ZeitgeistEvent* _tmp49_;
	GPtrArray* _tmp50_;
	GError * _inner_error_;
};


static gpointer downloads_directory_monitor_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType downloads_directory_monitor_get_type (void) G_GNUC_CONST;
#define DOWNLOADS_DIRECTORY_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitorPrivate))
#define DOWNLOADS_DIRECTORY_MONITOR_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP ","
DownloadsDirectoryMonitor* downloads_directory_monitor_new (DataHub* datahub, GError** error);
DownloadsDirectoryMonitor* downloads_directory_monitor_construct (GType object_type, DataHub* datahub, GError** error);
static void downloads_directory_monitor_real_start (DataProvider* base);
DataHub* data_provider_get_datahub (DataProvider* self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
static void downloads_directory_monitor_process_event (DownloadsDirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void downloads_directory_monitor_process_event_finish (DownloadsDirectoryMonitor* self, GAsyncResult* _res_);
static void _downloads_directory_monitor_process_event_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void downloads_directory_monitor_real_stop (DataProvider* base);
static void downloads_directory_monitor_process_event_data_free (gpointer _data);
static void downloads_directory_monitor_process_event_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean downloads_directory_monitor_process_event_co (DownloadsDirectoryMonitorProcessEventData* _data_);
static void downloads_directory_monitor_process_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static GObject * downloads_directory_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void downloads_directory_monitor_finalize (GObject * obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_downloads_directory_monitor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_downloads_directory_monitor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


DownloadsDirectoryMonitor* downloads_directory_monitor_construct (GType object_type, DataHub* datahub, GError** error) {
	DownloadsDirectoryMonitor * self = NULL;
	DataHub* _tmp0_;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (DownloadsDirectoryMonitor*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,downloads-monitor", "name", "Downloads Directory Monitor", "description", "Logs files in the XDG downloads directory", "datahub", _tmp0_, NULL);
	return self;
}


DownloadsDirectoryMonitor* downloads_directory_monitor_new (DataHub* datahub, GError** error) {
	return downloads_directory_monitor_construct (TYPE_DOWNLOADS_DIRECTORY_MONITOR, datahub, error);
}


static void _downloads_directory_monitor_process_event_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	downloads_directory_monitor_process_event ((DownloadsDirectoryMonitor*) self, file, other_file, event_type, NULL, NULL);
}


static void downloads_directory_monitor_real_start (DataProvider* base) {
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->downloads_path;
	if (_tmp0_ != NULL) {
		DataHub* _tmp1_;
		DataHub* _tmp2_;
		gint _tmp3_;
		gchar** _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp1_ = data_provider_get_datahub ((DataProvider*) self);
		_tmp2_ = _tmp1_;
		_tmp4_ = data_hub_get_data_source_actors (_tmp2_, TRUE, &_tmp3_);
		self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
		self->priv->ignored_actors = _tmp4_;
		self->priv->ignored_actors_length1 = _tmp3_;
		self->priv->_ignored_actors_size_ = self->priv->ignored_actors_length1;
		_tmp5_ = self->priv->monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _downloads_directory_monitor_process_event_g_file_monitor_changed, self, 0);
	}
}


static void downloads_directory_monitor_real_stop (DataProvider* base) {
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->downloads_path;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _downloads_directory_monitor_process_event_g_file_monitor_changed, self);
	}
}


static void downloads_directory_monitor_process_event_data_free (gpointer _data) {
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->other_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (DownloadsDirectoryMonitorProcessEventData, _data_);
}


static void downloads_directory_monitor_process_event_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	DownloadsDirectoryMonitorProcessEventData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void downloads_directory_monitor_process_event (DownloadsDirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DownloadsDirectoryMonitorProcessEventData* _data_;
	DownloadsDirectoryMonitor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileMonitorEvent _tmp5_;
	_data_ = g_slice_new0 (DownloadsDirectoryMonitorProcessEventData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, downloads_directory_monitor_process_event_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, downloads_directory_monitor_process_event_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_tmp3_ = other_file;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->other_file);
	_data_->other_file = _tmp4_;
	_tmp5_ = event_type;
	_data_->event_type = _tmp5_;
	downloads_directory_monitor_process_event_co (_data_);
}


static void downloads_directory_monitor_process_event_finish (DownloadsDirectoryMonitor* self, GAsyncResult* _res_) {
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void downloads_directory_monitor_process_event_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DownloadsDirectoryMonitorProcessEventData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	downloads_directory_monitor_process_event_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gboolean downloads_directory_monitor_process_event_co (DownloadsDirectoryMonitorProcessEventData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->event_type;
	if (_data_->_tmp0_ != G_FILE_MONITOR_EVENT_CREATED) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->file;
	_data_->_tmp2_ = g_file_get_uri (_data_->_tmp1_);
	_data_->uri = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->uri;
	_data_->_tmp5_ = g_str_has_suffix (_data_->_tmp4_, ".part");
	if (_data_->_tmp5_) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp6_ = _data_->uri;
		_data_->_tmp7_ = g_str_has_suffix (_data_->_tmp6_, ".crdownload");
		_data_->_tmp3_ = _data_->_tmp7_;
	}
	if (_data_->_tmp3_) {
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp9_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp9_, DOWNLOADS_DIRECTORY_MONITOR_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, downloads_directory_monitor_process_event_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = g_file_query_info_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp8_ = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
		_data_->_tmp11_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_g_object_unref0 (_data_->subject_info);
		_data_->subject_info = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->subject_info;
		_data_->_tmp14_ = g_file_info_get_is_hidden (_data_->_tmp13_);
		if (_data_->_tmp14_) {
			_data_->_tmp12_ = TRUE;
		} else {
			_data_->_tmp15_ = _data_->subject_info;
			_data_->_tmp16_ = g_file_info_get_is_backup (_data_->_tmp15_);
			_data_->_tmp12_ = _data_->_tmp16_;
		}
		if (_data_->_tmp12_) {
			_g_object_unref0 (_data_->_tmp8_);
			_g_object_unref0 (_data_->subject_info);
			_g_free0 (_data_->uri);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (_data_->_task_complete_ != TRUE) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->_tmp8_);
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp17_ = _data_->file;
		_data_->_tmp18_ = g_file_get_path (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = _data_->err;
		_data_->_tmp21_ = _data_->_tmp20_->message;
		g_warning ("downloads-directory-provider.vala:120: Couldn't process %s: %s", _data_->_tmp19_, _data_->_tmp21_);
		_g_free0 (_data_->_tmp19_);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->subject_info);
		_g_free0 (_data_->uri);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally16:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->subject_info);
		_g_free0 (_data_->uri);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp22_ = _data_->subject_info;
	_data_->_tmp23_ = g_file_info_get_attribute_string (_data_->_tmp22_, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
	_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
	_data_->mimetype = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->uri;
	_data_->_tmp26_ = g_path_get_dirname (_data_->_tmp25_);
	_data_->origin = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->file;
	_data_->_tmp28_ = g_file_get_path (_data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = g_path_get_basename (_data_->_tmp29_);
	_data_->_tmp31_ = _data_->_tmp30_;
	_g_free0 (_data_->_tmp29_);
	_data_->basename = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->uri;
	_data_->_tmp33_ = _data_->mimetype;
	_data_->_tmp34_ = zeitgeist_interpretation_for_mimetype (_data_->_tmp33_);
	_data_->_tmp35_ = _data_->uri;
	_data_->_tmp36_ = zeitgeist_manifestation_for_uri (_data_->_tmp35_);
	_data_->_tmp37_ = _data_->mimetype;
	_data_->_tmp38_ = _data_->origin;
	_data_->_tmp39_ = _data_->basename;
	_data_->_tmp40_ = zeitgeist_subject_new_full (_data_->_tmp32_, _data_->_tmp34_, _data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, "");
	_data_->subject = _data_->_tmp40_;
	_data_->_tmp41_ = g_strdup ("");
	_data_->actor = _data_->_tmp41_;
	_data_->_tmp42_ = _data_->actor;
	_data_->_tmp43_ = zeitgeist_event_new_full (ZEITGEIST_ZG_CREATE_EVENT, ZEITGEIST_ZG_WORLD_ACTIVITY, _data_->_tmp42_, NULL, NULL, NULL);
	_data_->event = _data_->_tmp43_;
	_data_->_tmp44_ = _data_->event;
	_data_->_tmp45_ = _data_->subject;
	zeitgeist_event_add_subject (_data_->_tmp44_, _data_->_tmp45_);
	_data_->_tmp46_ = _data_->event;
	if (_data_->_tmp46_ != NULL) {
		_data_->_tmp47_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_data_->events = _data_->_tmp47_;
		_data_->_tmp48_ = _data_->events;
		_data_->_tmp49_ = _data_->event;
		_data_->event = NULL;
		g_ptr_array_add (_data_->_tmp48_, _data_->_tmp49_);
		_data_->_tmp50_ = _data_->events;
		g_signal_emit_by_name ((DataProvider*) _data_->self, "items-available", _data_->_tmp50_);
		_g_ptr_array_unref0 (_data_->events);
	}
	_g_object_unref0 (_data_->event);
	_g_free0 (_data_->actor);
	_g_object_unref0 (_data_->subject);
	_g_free0 (_data_->basename);
	_g_free0 (_data_->origin);
	_g_free0 (_data_->mimetype);
	_g_object_unref0 (_data_->subject_info);
	_g_free0 (_data_->uri);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* downloads_directory_monitor_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_unique_id (DataProvider* base, const gchar* value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (g_strcmp0 (value, downloads_directory_monitor_real_get_unique_id (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_unique_id);
		self->priv->_unique_id = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY]);
	}
}


static const gchar* downloads_directory_monitor_real_get_name (DataProvider* base) {
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_name (DataProvider* base, const gchar* value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (g_strcmp0 (value, downloads_directory_monitor_real_get_name (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY]);
	}
}


static const gchar* downloads_directory_monitor_real_get_description (DataProvider* base) {
	const gchar* result;
	DownloadsDirectoryMonitor* self;
	const gchar* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_description (DataProvider* base, const gchar* value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (g_strcmp0 (value, downloads_directory_monitor_real_get_description (base)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY]);
	}
}


static DataHub* downloads_directory_monitor_real_get_datahub (DataProvider* base) {
	DataHub* result;
	DownloadsDirectoryMonitor* self;
	DataHub* _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_datahub (DataProvider* base, DataHub* value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (downloads_directory_monitor_real_get_datahub (base) != value) {
		DataHub* _tmp0_;
		DataHub* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_datahub);
		self->priv->_datahub = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY]);
	}
}


static gboolean downloads_directory_monitor_real_get_enabled (DataProvider* base) {
	gboolean result;
	DownloadsDirectoryMonitor* self;
	gboolean _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_enabled (DataProvider* base, gboolean value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (downloads_directory_monitor_real_get_enabled (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_enabled = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY]);
	}
}


static gboolean downloads_directory_monitor_real_get_register (DataProvider* base) {
	gboolean result;
	DownloadsDirectoryMonitor* self;
	gboolean _tmp0_;
	self = (DownloadsDirectoryMonitor*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void downloads_directory_monitor_real_set_register (DataProvider* base, gboolean value) {
	DownloadsDirectoryMonitor* self;
	self = (DownloadsDirectoryMonitor*) base;
	if (downloads_directory_monitor_real_get_register (base) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_register = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY]);
	}
}


static GObject * downloads_directory_monitor_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DownloadsDirectoryMonitor * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (downloads_directory_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->downloads_path);
	self->priv->downloads_path = _tmp1_;
	_tmp2_ = self->priv->downloads_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = self->priv->downloads_path;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (self->priv->downloads_directory);
		self->priv->downloads_directory = _tmp4_;
		{
			GFileMonitor* _tmp5_ = NULL;
			GFile* _tmp6_;
			GFileMonitor* _tmp7_;
			GFileMonitor* _tmp8_;
			_tmp6_ = self->priv->downloads_directory;
			_tmp7_ = g_file_monitor_directory (_tmp6_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch17_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (self->priv->monitor);
			self->priv->monitor = _tmp8_;
			_g_object_unref0 (_tmp5_);
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* err = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = err;
			_tmp10_ = _tmp9_->message;
			g_warning ("downloads-directory-provider.vala:66: Couldn't set up monitor on Downl" \
"oads directory: %s", _tmp10_);
			_g_error_free0 (err);
		}
		__finally17:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	return obj;
}


static void downloads_directory_monitor_class_init (DownloadsDirectoryMonitorClass * klass) {
	downloads_directory_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DownloadsDirectoryMonitorPrivate));
	((DataProviderClass *) klass)->start = (void (*) (DataProvider *)) downloads_directory_monitor_real_start;
	((DataProviderClass *) klass)->stop = (void (*) (DataProvider *)) downloads_directory_monitor_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = downloads_directory_monitor_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = downloads_directory_monitor_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = downloads_directory_monitor_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = downloads_directory_monitor_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = downloads_directory_monitor_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = downloads_directory_monitor_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = downloads_directory_monitor_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = downloads_directory_monitor_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = downloads_directory_monitor_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = downloads_directory_monitor_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = downloads_directory_monitor_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = downloads_directory_monitor_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_downloads_directory_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_downloads_directory_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = downloads_directory_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = downloads_directory_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY] = g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY] = g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY, downloads_directory_monitor_properties[DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY] = g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void downloads_directory_monitor_instance_init (DownloadsDirectoryMonitor * self) {
	self->priv = DOWNLOADS_DIRECTORY_MONITOR_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
}


static void downloads_directory_monitor_finalize (GObject * obj) {
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	_g_free0 (self->priv->downloads_path);
	_g_object_unref0 (self->priv->downloads_directory);
	_g_object_unref0 (self->priv->monitor);
	self->priv->ignored_actors = (_vala_array_free (self->priv->ignored_actors, self->priv->ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (downloads_directory_monitor_parent_class)->finalize (obj);
}


GType downloads_directory_monitor_get_type (void) {
	static volatile gsize downloads_directory_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&downloads_directory_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DownloadsDirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) downloads_directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DownloadsDirectoryMonitor), 0, (GInstanceInitFunc) downloads_directory_monitor_instance_init, NULL };
		GType downloads_directory_monitor_type_id;
		downloads_directory_monitor_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "DownloadsDirectoryMonitor", &g_define_type_info, 0);
		g_once_init_leave (&downloads_directory_monitor_type_id__volatile, downloads_directory_monitor_type_id);
	}
	return downloads_directory_monitor_type_id__volatile;
}


static void _vala_downloads_directory_monitor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	switch (property_id) {
		case DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_downloads_directory_monitor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DownloadsDirectoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOWNLOADS_DIRECTORY_MONITOR, DownloadsDirectoryMonitor);
	switch (property_id) {
		case DOWNLOADS_DIRECTORY_MONITOR_UNIQUE_ID_PROPERTY:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_NAME_PROPERTY:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DESCRIPTION_PROPERTY:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_DATAHUB_PROPERTY:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_ENABLED_PROPERTY:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case DOWNLOADS_DIRECTORY_MONITOR_REGISTER_PROPERTY:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



