/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLTableCellElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLTableCellElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLTableCellElement* kit(WebCore::HTMLTableCellElement* obj)
{
    return WEBKIT_DOM_HTML_TABLE_CELL_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLTableCellElement* core(WebKitDOMHTMLTableCellElement* request)
{
    return request ? static_cast<WebCore::HTMLTableCellElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLTableCellElement* wrapHTMLTableCellElement(WebCore::HTMLTableCellElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_TABLE_CELL_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_TABLE_CELL_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLTableCellElement, webkit_dom_html_table_cell_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CELL_INDEX,
    PROP_ABBR,
    PROP_ALIGN,
    PROP_AXIS,
    PROP_BG_COLOR,
    PROP_CH,
    PROP_CH_OFF,
    PROP_COL_SPAN,
    PROP_HEADERS,
    PROP_HEIGHT,
    PROP_NO_WRAP,
    PROP_ROW_SPAN,
    PROP_SCOPE,
    PROP_V_ALIGN,
    PROP_WIDTH,
};

static void webkit_dom_html_table_cell_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableCellElement* self = WEBKIT_DOM_HTML_TABLE_CELL_ELEMENT(object);
    WebCore::HTMLTableCellElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ABBR: {
        coreSelf->setAttribute(WebCore::HTMLNames::abbrAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_AXIS: {
        coreSelf->setAttribute(WebCore::HTMLNames::axisAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setAttribute(WebCore::HTMLNames::bgcolorAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH: {
        coreSelf->setAttribute(WebCore::HTMLNames::charAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CH_OFF: {
        coreSelf->setAttribute(WebCore::HTMLNames::charoffAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_COL_SPAN: {
        coreSelf->setColSpan((g_value_get_long(value)));
        break;
    }
    case PROP_HEADERS: {
        coreSelf->setAttribute(WebCore::HTMLNames::headersAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::heightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NO_WRAP: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::nowrapAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_ROW_SPAN: {
        coreSelf->setRowSpan((g_value_get_long(value)));
        break;
    }
    case PROP_SCOPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::scopeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_V_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::valignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_cell_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLTableCellElement* self = WEBKIT_DOM_HTML_TABLE_CELL_ELEMENT(object);
    WebCore::HTMLTableCellElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CELL_INDEX: {
        g_value_set_long(value, coreSelf->cellIndex());
        break;
    }
    case PROP_ABBR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::abbrAttr)));
        break;
    }
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_AXIS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::axisAttr)));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr)));
        break;
    }
    case PROP_CH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charAttr)));
        break;
    }
    case PROP_CH_OFF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charoffAttr)));
        break;
    }
    case PROP_COL_SPAN: {
        g_value_set_long(value, coreSelf->colSpan());
        break;
    }
    case PROP_HEADERS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::headersAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::heightAttr)));
        break;
    }
    case PROP_NO_WRAP: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::nowrapAttr));
        break;
    }
    case PROP_ROW_SPAN: {
        g_value_set_long(value, coreSelf->rowSpan());
        break;
    }
    case PROP_SCOPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::scopeAttr)));
        break;
    }
    case PROP_V_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::valignAttr)));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_table_cell_element_class_init(WebKitDOMHTMLTableCellElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_table_cell_element_set_property;
    gobjectClass->get_property = webkit_dom_html_table_cell_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CELL_INDEX,
                                    g_param_spec_long("cell-index", /* name */
                                                           "html_table_cell_element_cell-index", /* short description */
                                                           "read-only  glong HTMLTableCellElement.cell-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ABBR,
                                    g_param_spec_string("abbr", /* name */
                                                           "html_table_cell_element_abbr", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.abbr", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_table_cell_element_align", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_AXIS,
                                    g_param_spec_string("axis", /* name */
                                                           "html_table_cell_element_axis", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.axis", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_table_cell_element_bg-color", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH,
                                    g_param_spec_string("ch", /* name */
                                                           "html_table_cell_element_ch", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.ch", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CH_OFF,
                                    g_param_spec_string("ch-off", /* name */
                                                           "html_table_cell_element_ch-off", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.ch-off", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COL_SPAN,
                                    g_param_spec_long("col-span", /* name */
                                                           "html_table_cell_element_col-span", /* short description */
                                                           "read-write  glong HTMLTableCellElement.col-span", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEADERS,
                                    g_param_spec_string("headers", /* name */
                                                           "html_table_cell_element_headers", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.headers", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_string("height", /* name */
                                                           "html_table_cell_element_height", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NO_WRAP,
                                    g_param_spec_boolean("no-wrap", /* name */
                                                           "html_table_cell_element_no-wrap", /* short description */
                                                           "read-write  gboolean HTMLTableCellElement.no-wrap", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ROW_SPAN,
                                    g_param_spec_long("row-span", /* name */
                                                           "html_table_cell_element_row-span", /* short description */
                                                           "read-write  glong HTMLTableCellElement.row-span", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCOPE,
                                    g_param_spec_string("scope", /* name */
                                                           "html_table_cell_element_scope", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.scope", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_V_ALIGN,
                                    g_param_spec_string("v-align", /* name */
                                                           "html_table_cell_element_v-align", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.v-align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_table_cell_element_width", /* short description */
                                                           "read-write  gchar* HTMLTableCellElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_table_cell_element_init(WebKitDOMHTMLTableCellElement* request)
{
}

glong
webkit_dom_html_table_cell_element_get_cell_index(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    glong result = item->cellIndex();
    return result;
}

gchar*
webkit_dom_html_table_cell_element_get_abbr(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::abbrAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_abbr(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::abbrAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_align(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_align(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_axis(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::axisAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_axis(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::axisAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_bg_color(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_bg_color(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::bgcolorAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_ch(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_ch(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_ch_off(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_ch_off(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charoffAttr, convertedValue);
}

glong
webkit_dom_html_table_cell_element_get_col_span(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    glong result = item->colSpan();
    return result;
}

void
webkit_dom_html_table_cell_element_set_col_span(WebKitDOMHTMLTableCellElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    item->setColSpan(value);
}

gchar*
webkit_dom_html_table_cell_element_get_headers(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::headersAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_headers(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::headersAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_height(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_height(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::heightAttr, convertedValue);
}

gboolean
webkit_dom_html_table_cell_element_get_no_wrap(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), FALSE);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::nowrapAttr);
    return result;
}

void
webkit_dom_html_table_cell_element_set_no_wrap(WebKitDOMHTMLTableCellElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::nowrapAttr, value);
}

glong
webkit_dom_html_table_cell_element_get_row_span(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    glong result = item->rowSpan();
    return result;
}

void
webkit_dom_html_table_cell_element_set_row_span(WebKitDOMHTMLTableCellElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    item->setRowSpan(value);
}

gchar*
webkit_dom_html_table_cell_element_get_scope(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::scopeAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_scope(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::scopeAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_v_align(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_v_align(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::valignAttr, convertedValue);
}

gchar*
webkit_dom_html_table_cell_element_get_width(WebKitDOMHTMLTableCellElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self), 0);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_table_cell_element_set_width(WebKitDOMHTMLTableCellElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_TABLE_CELL_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLTableCellElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

