/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMStyleSheet.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMMediaListPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStyleSheetPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_STYLE_SHEET_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_STYLE_SHEET, WebKitDOMStyleSheetPrivate)

typedef struct _WebKitDOMStyleSheetPrivate {
    RefPtr<WebCore::StyleSheet> coreObject;
} WebKitDOMStyleSheetPrivate;

namespace WebKit {

WebKitDOMStyleSheet* kit(WebCore::StyleSheet* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_STYLE_SHEET(ret);

    return wrap(obj);
}

WebCore::StyleSheet* core(WebKitDOMStyleSheet* request)
{
    return request ? static_cast<WebCore::StyleSheet*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMStyleSheet* wrapStyleSheet(WebCore::StyleSheet* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_STYLE_SHEET(g_object_new(WEBKIT_TYPE_DOM_STYLE_SHEET, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMStyleSheet, webkit_dom_style_sheet, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_DISABLED,
    PROP_OWNER_NODE,
    PROP_PARENT_STYLE_SHEET,
    PROP_HREF,
    PROP_TITLE,
    PROP_MEDIA,
};

static void webkit_dom_style_sheet_finalize(GObject* object)
{
    WebKitDOMStyleSheetPrivate* priv = WEBKIT_DOM_STYLE_SHEET_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMStyleSheetPrivate();
    G_OBJECT_CLASS(webkit_dom_style_sheet_parent_class)->finalize(object);
}

static void webkit_dom_style_sheet_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMStyleSheet* self = WEBKIT_DOM_STYLE_SHEET(object);
    WebCore::StyleSheet* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setDisabled((g_value_get_boolean(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_style_sheet_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMStyleSheet* self = WEBKIT_DOM_STYLE_SHEET(object);
    WebCore::StyleSheet* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->disabled());
        break;
    }
    case PROP_OWNER_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->ownerNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PARENT_STYLE_SHEET: {
        RefPtr<WebCore::StyleSheet> ptr = coreSelf->parentStyleSheet();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_HREF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->href()));
        break;
    }
    case PROP_TITLE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->title()));
        break;
    }
    case PROP_MEDIA: {
        RefPtr<WebCore::MediaList> ptr = coreSelf->media();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_style_sheet_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_style_sheet_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMStyleSheetPrivate* priv = WEBKIT_DOM_STYLE_SHEET_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::StyleSheet*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_style_sheet_class_init(WebKitDOMStyleSheetClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMStyleSheetPrivate));
    gobjectClass->constructor = webkit_dom_style_sheet_constructor;
    gobjectClass->finalize = webkit_dom_style_sheet_finalize;
    gobjectClass->set_property = webkit_dom_style_sheet_set_property;
    gobjectClass->get_property = webkit_dom_style_sheet_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "style_sheet_type", /* short description */
                                                           "read-only  gchar* StyleSheet.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "style_sheet_disabled", /* short description */
                                                           "read-write  gboolean StyleSheet.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OWNER_NODE,
                                    g_param_spec_object("owner-node", /* name */
                                                           "style_sheet_owner-node", /* short description */
                                                           "read-only  WebKitDOMNode* StyleSheet.owner-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PARENT_STYLE_SHEET,
                                    g_param_spec_object("parent-style-sheet", /* name */
                                                           "style_sheet_parent-style-sheet", /* short description */
                                                           "read-only  WebKitDOMStyleSheet* StyleSheet.parent-style-sheet", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_SHEET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREF,
                                    g_param_spec_string("href", /* name */
                                                           "style_sheet_href", /* short description */
                                                           "read-only  gchar* StyleSheet.href", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TITLE,
                                    g_param_spec_string("title", /* name */
                                                           "style_sheet_title", /* short description */
                                                           "read-only  gchar* StyleSheet.title", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MEDIA,
                                    g_param_spec_object("media", /* name */
                                                           "style_sheet_media", /* short description */
                                                           "read-only  WebKitDOMMediaList* StyleSheet.media", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_MEDIA_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_style_sheet_init(WebKitDOMStyleSheet* request)
{
    WebKitDOMStyleSheetPrivate* priv = WEBKIT_DOM_STYLE_SHEET_GET_PRIVATE(request);
    new (priv) WebKitDOMStyleSheetPrivate();
}

gboolean
webkit_dom_style_sheet_get_disabled(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), FALSE);
    WebCore::StyleSheet* item = WebKit::core(self);
    gboolean result = item->disabled();
    return result;
}

void
webkit_dom_style_sheet_set_disabled(WebKitDOMStyleSheet* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self));
    WebCore::StyleSheet* item = WebKit::core(self);
    item->setDisabled(value);
}

WebKitDOMNode*
webkit_dom_style_sheet_get_owner_node(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), 0);
    WebCore::StyleSheet* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->ownerNode());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMStyleSheet*
webkit_dom_style_sheet_get_parent_style_sheet(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), 0);
    WebCore::StyleSheet* item = WebKit::core(self);
    RefPtr<WebCore::StyleSheet> gobjectResult = WTF::getPtr(item->parentStyleSheet());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_style_sheet_get_href(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), 0);
    WebCore::StyleSheet* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->href());
    return result;
}

gchar*
webkit_dom_style_sheet_get_title(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), 0);
    WebCore::StyleSheet* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->title());
    return result;
}

WebKitDOMMediaList*
webkit_dom_style_sheet_get_media(WebKitDOMStyleSheet* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_SHEET(self), 0);
    WebCore::StyleSheet* item = WebKit::core(self);
    RefPtr<WebCore::MediaList> gobjectResult = WTF::getPtr(item->media());
    return WebKit::kit(gobjectResult.get());
}

