/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPropertyNodeList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMPropertyNodeListPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#if ENABLE(MICRODATA)

namespace WebKit {

WebKitDOMPropertyNodeList* kit(WebCore::PropertyNodeList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PROPERTY_NODE_LIST(ret);

    return wrapPropertyNodeList(obj);
}

WebCore::PropertyNodeList* core(WebKitDOMPropertyNodeList* request)
{
    return request ? static_cast<WebCore::PropertyNodeList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPropertyNodeList* wrapPropertyNodeList(WebCore::PropertyNodeList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PROPERTY_NODE_LIST(g_object_new(WEBKIT_TYPE_DOM_PROPERTY_NODE_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(MICRODATA)

G_DEFINE_TYPE(WebKitDOMPropertyNodeList, webkit_dom_property_node_list, WEBKIT_TYPE_DOM_NODE_LIST)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_property_node_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(MICRODATA)
    WebKitDOMPropertyNodeList* self = WEBKIT_DOM_PROPERTY_NODE_LIST(object);
    WebCore::PropertyNodeList* coreSelf = WebKit::core(self);
#endif // ENABLE(MICRODATA)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(MICRODATA)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
#endif /* ENABLE(MICRODATA) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_property_node_list_class_init(WebKitDOMPropertyNodeListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_property_node_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "property_node_list_length", /* short description */
                                                           "read-only  gulong PropertyNodeList.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_property_node_list_init(WebKitDOMPropertyNodeList* request)
{
}

WebKitDOMNode*
webkit_dom_property_node_list_item(WebKitDOMPropertyNodeList* self, gulong index)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PROPERTY_NODE_LIST(self), 0);
    WebCore::PropertyNodeList* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return 0;
#endif /* ENABLE(MICRODATA) */
}

gulong
webkit_dom_property_node_list_get_length(WebKitDOMPropertyNodeList* self)
{
#if ENABLE(MICRODATA)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PROPERTY_NODE_LIST(self), 0);
    WebCore::PropertyNodeList* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Microdata")
    return static_cast<gulong>(0);
#endif /* ENABLE(MICRODATA) */
}

