/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMSelection.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMSelectionPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMRangePrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_SELECTION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_SELECTION, WebKitDOMDOMSelectionPrivate)

typedef struct _WebKitDOMDOMSelectionPrivate {
    RefPtr<WebCore::DOMSelection> coreObject;
} WebKitDOMDOMSelectionPrivate;

namespace WebKit {

WebKitDOMDOMSelection* kit(WebCore::DOMSelection* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_SELECTION(ret);

    return wrapDOMSelection(obj);
}

WebCore::DOMSelection* core(WebKitDOMDOMSelection* request)
{
    return request ? static_cast<WebCore::DOMSelection*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMSelection* wrapDOMSelection(WebCore::DOMSelection* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_SELECTION(g_object_new(WEBKIT_TYPE_DOM_DOM_SELECTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMDOMSelection, webkit_dom_dom_selection, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ANCHOR_NODE,
    PROP_ANCHOR_OFFSET,
    PROP_FOCUS_NODE,
    PROP_FOCUS_OFFSET,
    PROP_IS_COLLAPSED,
    PROP_RANGE_COUNT,
    PROP_BASE_NODE,
    PROP_BASE_OFFSET,
    PROP_EXTENT_NODE,
    PROP_EXTENT_OFFSET,
    PROP_TYPE,
};

static void webkit_dom_dom_selection_finalize(GObject* object)
{
    WebKitDOMDOMSelectionPrivate* priv = WEBKIT_DOM_DOM_SELECTION_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMSelectionPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_selection_parent_class)->finalize(object);
}

static void webkit_dom_dom_selection_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMSelection* self = WEBKIT_DOM_DOM_SELECTION(object);
    WebCore::DOMSelection* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ANCHOR_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->anchorNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_ANCHOR_OFFSET: {
        g_value_set_long(value, coreSelf->anchorOffset());
        break;
    }
    case PROP_FOCUS_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->focusNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_FOCUS_OFFSET: {
        g_value_set_long(value, coreSelf->focusOffset());
        break;
    }
    case PROP_IS_COLLAPSED: {
        g_value_set_boolean(value, coreSelf->isCollapsed());
        break;
    }
    case PROP_RANGE_COUNT: {
        g_value_set_long(value, coreSelf->rangeCount());
        break;
    }
    case PROP_BASE_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->baseNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_BASE_OFFSET: {
        g_value_set_long(value, coreSelf->baseOffset());
        break;
    }
    case PROP_EXTENT_NODE: {
        RefPtr<WebCore::Node> ptr = coreSelf->extentNode();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_EXTENT_OFFSET: {
        g_value_set_long(value, coreSelf->extentOffset());
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_selection_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_selection_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMSelectionPrivate* priv = WEBKIT_DOM_DOM_SELECTION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMSelection*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_selection_class_init(WebKitDOMDOMSelectionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMSelectionPrivate));
    gobjectClass->constructor = webkit_dom_dom_selection_constructor;
    gobjectClass->finalize = webkit_dom_dom_selection_finalize;
    gobjectClass->get_property = webkit_dom_dom_selection_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ANCHOR_NODE,
                                    g_param_spec_object("anchor-node", /* name */
                                                           "dom_selection_anchor-node", /* short description */
                                                           "read-only  WebKitDOMNode* DOMSelection.anchor-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ANCHOR_OFFSET,
                                    g_param_spec_long("anchor-offset", /* name */
                                                           "dom_selection_anchor-offset", /* short description */
                                                           "read-only  glong DOMSelection.anchor-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FOCUS_NODE,
                                    g_param_spec_object("focus-node", /* name */
                                                           "dom_selection_focus-node", /* short description */
                                                           "read-only  WebKitDOMNode* DOMSelection.focus-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FOCUS_OFFSET,
                                    g_param_spec_long("focus-offset", /* name */
                                                           "dom_selection_focus-offset", /* short description */
                                                           "read-only  glong DOMSelection.focus-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IS_COLLAPSED,
                                    g_param_spec_boolean("is-collapsed", /* name */
                                                           "dom_selection_is-collapsed", /* short description */
                                                           "read-only  gboolean DOMSelection.is-collapsed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_RANGE_COUNT,
                                    g_param_spec_long("range-count", /* name */
                                                           "dom_selection_range-count", /* short description */
                                                           "read-only  glong DOMSelection.range-count", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BASE_NODE,
                                    g_param_spec_object("base-node", /* name */
                                                           "dom_selection_base-node", /* short description */
                                                           "read-only  WebKitDOMNode* DOMSelection.base-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BASE_OFFSET,
                                    g_param_spec_long("base-offset", /* name */
                                                           "dom_selection_base-offset", /* short description */
                                                           "read-only  glong DOMSelection.base-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EXTENT_NODE,
                                    g_param_spec_object("extent-node", /* name */
                                                           "dom_selection_extent-node", /* short description */
                                                           "read-only  WebKitDOMNode* DOMSelection.extent-node", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_NODE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_EXTENT_OFFSET,
                                    g_param_spec_long("extent-offset", /* name */
                                                           "dom_selection_extent-offset", /* short description */
                                                           "read-only  glong DOMSelection.extent-offset", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "dom_selection_type", /* short description */
                                                           "read-only  gchar* DOMSelection.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_selection_init(WebKitDOMDOMSelection* request)
{
    WebKitDOMDOMSelectionPrivate* priv = WEBKIT_DOM_DOM_SELECTION_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMSelectionPrivate();
}

void
webkit_dom_dom_selection_collapse(WebKitDOMDOMSelection* self, WebKitDOMNode* node, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(node));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::ExceptionCode ec = 0;
    item->collapse(convertedNode, index, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_collapse_to_end(WebKitDOMDOMSelection* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->collapseToEnd(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_collapse_to_start(WebKitDOMDOMSelection* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->collapseToStart(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_delete_from_document(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    WebCore::DOMSelection* item = WebKit::core(self);
    item->deleteFromDocument();
}

gboolean
webkit_dom_dom_selection_contains_node(WebKitDOMDOMSelection* self, WebKitDOMNode* node, gboolean allowPartial)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_NODE(node), FALSE);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    gboolean result = item->containsNode(convertedNode, allowPartial);
    return result;
}

void
webkit_dom_dom_selection_select_all_children(WebKitDOMDOMSelection* self, WebKitDOMNode* node, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(node));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::ExceptionCode ec = 0;
    item->selectAllChildren(convertedNode, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_extend(WebKitDOMDOMSelection* self, WebKitDOMNode* node, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(node));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::ExceptionCode ec = 0;
    item->extend(convertedNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMRange*
webkit_dom_dom_selection_get_range_at(WebKitDOMDOMSelection* self, glong index, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Range> gobjectResult = WTF::getPtr(item->getRangeAt(index, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

void
webkit_dom_dom_selection_remove_all_ranges(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    WebCore::DOMSelection* item = WebKit::core(self);
    item->removeAllRanges();
}

void
webkit_dom_dom_selection_add_range(WebKitDOMDOMSelection* self, WebKitDOMRange* range)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_RANGE(range));
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Range* convertedRange = WebKit::core(range);
    item->addRange(convertedRange);
}

void
webkit_dom_dom_selection_modify(WebKitDOMDOMSelection* self, const gchar* alter, const gchar* direction, const gchar* granularity)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(alter);
    g_return_if_fail(direction);
    g_return_if_fail(granularity);
    WebCore::DOMSelection* item = WebKit::core(self);
    WTF::String convertedAlter = WTF::String::fromUTF8(alter);
    WTF::String convertedDirection = WTF::String::fromUTF8(direction);
    WTF::String convertedGranularity = WTF::String::fromUTF8(granularity);
    item->modify(convertedAlter, convertedDirection, convertedGranularity);
}

void
webkit_dom_dom_selection_set_base_and_extent(WebKitDOMDOMSelection* self, WebKitDOMNode* baseNode, glong baseOffset, WebKitDOMNode* extentNode, glong extentOffset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(baseNode));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(extentNode));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedBaseNode = WebKit::core(baseNode);
    WebCore::Node* convertedExtentNode = WebKit::core(extentNode);
    WebCore::ExceptionCode ec = 0;
    item->setBaseAndExtent(convertedBaseNode, baseOffset, convertedExtentNode, extentOffset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_set_position(WebKitDOMDOMSelection* self, WebKitDOMNode* node, glong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    g_return_if_fail(WEBKIT_DOM_IS_NODE(node));
    g_return_if_fail(!error || !*error);
    WebCore::DOMSelection* item = WebKit::core(self);
    WebCore::Node* convertedNode = WebKit::core(node);
    WebCore::ExceptionCode ec = 0;
    item->setPosition(convertedNode, offset, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_selection_empty(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self));
    WebCore::DOMSelection* item = WebKit::core(self);
    item->empty();
}

WebKitDOMNode*
webkit_dom_dom_selection_get_anchor_node(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->anchorNode());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_dom_selection_get_anchor_offset(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    glong result = item->anchorOffset();
    return result;
}

WebKitDOMNode*
webkit_dom_dom_selection_get_focus_node(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->focusNode());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_dom_selection_get_focus_offset(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    glong result = item->focusOffset();
    return result;
}

gboolean
webkit_dom_dom_selection_get_is_collapsed(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), FALSE);
    WebCore::DOMSelection* item = WebKit::core(self);
    gboolean result = item->isCollapsed();
    return result;
}

glong
webkit_dom_dom_selection_get_range_count(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    glong result = item->rangeCount();
    return result;
}

WebKitDOMNode*
webkit_dom_dom_selection_get_base_node(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->baseNode());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_dom_selection_get_base_offset(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    glong result = item->baseOffset();
    return result;
}

WebKitDOMNode*
webkit_dom_dom_selection_get_extent_node(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    RefPtr<WebCore::Node> gobjectResult = WTF::getPtr(item->extentNode());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_dom_selection_get_extent_offset(WebKitDOMDOMSelection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_SELECTION(self), 0);
    WebCore::DOMSelection* item = WebKit::core(self);
    glong result = item->extentOffset();
    return result;
}

