#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <telepathy-glib/dbus-properties-mixin.h>

G_BEGIN_DECLS

/**
 * HazeSvcConnectionInterfaceMailNotification:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _HazeSvcConnectionInterfaceMailNotification HazeSvcConnectionInterfaceMailNotification;

/**
 * HazeSvcConnectionInterfaceMailNotificationClass:
 *
 * The class of HazeSvcConnectionInterfaceMailNotification.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_mail_notification (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) haze_svc_connection_interface_mail_notification_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (subscribe);
 *   IMPLEMENT (unsubscribe);
 *   IMPLEMENT (request_inbox_url);
 *   IMPLEMENT (request_mail_url);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _HazeSvcConnectionInterfaceMailNotificationClass HazeSvcConnectionInterfaceMailNotificationClass;

GType haze_svc_connection_interface_mail_notification_get_type (void);
#define HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION \
  (haze_svc_connection_interface_mail_notification_get_type ())
#define HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, HazeSvcConnectionInterfaceMailNotification))
#define HAZE_IS_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION))
#define HAZE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), HAZE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, HazeSvcConnectionInterfaceMailNotificationClass))


typedef void (*haze_svc_connection_interface_mail_notification_subscribe_impl) (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void haze_svc_connection_interface_mail_notification_implement_subscribe (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_subscribe_impl impl);
/**
 * haze_svc_connection_interface_mail_notification_return_from_subscribe:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void haze_svc_connection_interface_mail_notification_return_from_subscribe (DBusGMethodInvocation *context);
static inline void
haze_svc_connection_interface_mail_notification_return_from_subscribe (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*haze_svc_connection_interface_mail_notification_unsubscribe_impl) (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void haze_svc_connection_interface_mail_notification_implement_unsubscribe (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_unsubscribe_impl impl);
/**
 * haze_svc_connection_interface_mail_notification_return_from_unsubscribe:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void haze_svc_connection_interface_mail_notification_return_from_unsubscribe (DBusGMethodInvocation *context);
static inline void
haze_svc_connection_interface_mail_notification_return_from_unsubscribe (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*haze_svc_connection_interface_mail_notification_request_inbox_url_impl) (HazeSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void haze_svc_connection_interface_mail_notification_implement_request_inbox_url (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_request_inbox_url_impl impl);
/**
 * haze_svc_connection_interface_mail_notification_return_from_request_inbox_url:
 * @context: The D-Bus method invocation context
 * @out_URL: const GValueArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void haze_svc_connection_interface_mail_notification_return_from_request_inbox_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL);
static inline void
haze_svc_connection_interface_mail_notification_return_from_request_inbox_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL)
{
  dbus_g_method_return (context,
      out_URL);
}

typedef void (*haze_svc_connection_interface_mail_notification_request_mail_url_impl) (HazeSvcConnectionInterfaceMailNotification *self,
    const gchar *in_ID,
    const GValue *in_URL_Data,
    DBusGMethodInvocation *context);
void haze_svc_connection_interface_mail_notification_implement_request_mail_url (HazeSvcConnectionInterfaceMailNotificationClass *klass, haze_svc_connection_interface_mail_notification_request_mail_url_impl impl);
/**
 * haze_svc_connection_interface_mail_notification_return_from_request_mail_url:
 * @context: The D-Bus method invocation context
 * @out_URL: const GValueArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void haze_svc_connection_interface_mail_notification_return_from_request_mail_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL);
static inline void
haze_svc_connection_interface_mail_notification_return_from_request_mail_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL)
{
  dbus_g_method_return (context,
      out_URL);
}

void haze_svc_connection_interface_mail_notification_emit_mails_received (gpointer instance,
    const GPtrArray *arg_Mails);
void haze_svc_connection_interface_mail_notification_emit_unread_mails_changed (gpointer instance,
    guint arg_Count,
    const GPtrArray *arg_Mails_Added,
    const gchar **arg_Mails_Removed);


G_END_DECLS
