/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(JAVASCRIPT_DEBUGGER)

#include "JSScriptProfile.h"

#include "JSScriptProfileNode.h"
#include "KURL.h"
#include "ScriptProfile.h"
#include "ScriptProfileNode.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSScriptProfileTableValues[] =
{
    { "title", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileTitle), (intptr_t)0, NoIntrinsic },
    { "uid", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileUid), (intptr_t)0, NoIntrinsic },
    { "head", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsScriptProfileHead), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScriptProfileTable = { 8, 7, JSScriptProfileTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSScriptProfilePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSScriptProfilePrototypeTable = { 1, 0, JSScriptProfilePrototypeTableValues, 0 };
const ClassInfo JSScriptProfilePrototype::s_info = { "ScriptProfilePrototype", &Base::s_info, &JSScriptProfilePrototypeTable, 0, CREATE_METHOD_TABLE(JSScriptProfilePrototype) };

JSObject* JSScriptProfilePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSScriptProfile>(exec, globalObject);
}

const ClassInfo JSScriptProfile::s_info = { "ScriptProfile", &Base::s_info, &JSScriptProfileTable, 0 , CREATE_METHOD_TABLE(JSScriptProfile) };

JSScriptProfile::JSScriptProfile(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<ScriptProfile> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSScriptProfile::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSScriptProfile::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSScriptProfilePrototype::create(exec->globalData(), globalObject, JSScriptProfilePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSScriptProfile::destroy(JSC::JSCell* cell)
{
    JSScriptProfile* thisObject = static_cast<JSScriptProfile*>(cell);
    thisObject->JSScriptProfile::~JSScriptProfile();
}

JSScriptProfile::~JSScriptProfile()
{
    releaseImplIfNotNull();
}

bool JSScriptProfile::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSScriptProfile* thisObject = jsCast<JSScriptProfile*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSScriptProfile, Base>(exec, &JSScriptProfileTable, thisObject, propertyName, slot);
}

bool JSScriptProfile::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSScriptProfile* thisObject = jsCast<JSScriptProfile*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSScriptProfile, Base>(exec, &JSScriptProfileTable, thisObject, propertyName, descriptor);
}

JSValue jsScriptProfileTitle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->title());
    return result;
}


JSValue jsScriptProfileUid(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = jsNumber(impl->uid());
    return result;
}


JSValue jsScriptProfileHead(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSScriptProfile* castedThis = jsCast<JSScriptProfile*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    ScriptProfile* impl = static_cast<ScriptProfile*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->head()));
    return result;
}


static inline bool isObservable(JSScriptProfile* jsScriptProfile)
{
    if (jsScriptProfile->hasCustomProperties())
        return true;
    return false;
}

bool JSScriptProfileOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSScriptProfile* jsScriptProfile = jsCast<JSScriptProfile*>(handle.get().asCell());
    if (!isObservable(jsScriptProfile))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSScriptProfileOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSScriptProfile* jsScriptProfile = jsCast<JSScriptProfile*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsScriptProfile->impl(), jsScriptProfile);
    jsScriptProfile->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ScriptProfile* impl)
{
    return wrap<JSScriptProfile>(exec, globalObject, impl);
}

ScriptProfile* toScriptProfile(JSC::JSValue value)
{
    return value.inherits(&JSScriptProfile::s_info) ? jsCast<JSScriptProfile*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(JAVASCRIPT_DEBUGGER)
