/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGSymbolElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedRect.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGSymbolElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGSymbolElementTableValues[] =
{
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementXmllang), (intptr_t)setJSSVGSymbolElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementXmlspace), (intptr_t)setJSSVGSymbolElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementStyle), (intptr_t)0, NoIntrinsic },
    { "viewBox", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementViewBox), (intptr_t)0, NoIntrinsic },
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementPreserveAspectRatio), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGSymbolElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSymbolElementTable = { 16, 15, JSSVGSymbolElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGSymbolElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSymbolElementConstructorTable = { 1, 0, JSSVGSymbolElementConstructorTableValues, 0 };
const ClassInfo JSSVGSymbolElementConstructor::s_info = { "SVGSymbolElementConstructor", &Base::s_info, &JSSVGSymbolElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGSymbolElementConstructor) };

JSSVGSymbolElementConstructor::JSSVGSymbolElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGSymbolElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGSymbolElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGSymbolElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGSymbolElementConstructor, JSDOMWrapper>(exec, &JSSVGSymbolElementConstructorTable, jsCast<JSSVGSymbolElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGSymbolElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGSymbolElementConstructor, JSDOMWrapper>(exec, &JSSVGSymbolElementConstructorTable, jsCast<JSSVGSymbolElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGSymbolElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGSymbolElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGSymbolElementPrototypeTable = { 2, 1, JSSVGSymbolElementPrototypeTableValues, 0 };
const ClassInfo JSSVGSymbolElementPrototype::s_info = { "SVGSymbolElementPrototype", &Base::s_info, &JSSVGSymbolElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGSymbolElementPrototype) };

JSObject* JSSVGSymbolElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGSymbolElement>(exec, globalObject);
}

bool JSSVGSymbolElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSymbolElementPrototype* thisObject = jsCast<JSSVGSymbolElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGSymbolElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGSymbolElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSymbolElementPrototype* thisObject = jsCast<JSSVGSymbolElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGSymbolElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGSymbolElement::s_info = { "SVGSymbolElement", &Base::s_info, &JSSVGSymbolElementTable, 0 , CREATE_METHOD_TABLE(JSSVGSymbolElement) };

JSSVGSymbolElement::JSSVGSymbolElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGSymbolElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGSymbolElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGSymbolElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGSymbolElementPrototype::create(exec->globalData(), globalObject, JSSVGSymbolElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGSymbolElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGSymbolElement* thisObject = jsCast<JSSVGSymbolElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGSymbolElement, Base>(exec, &JSSVGSymbolElementTable, thisObject, propertyName, slot);
}

bool JSSVGSymbolElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGSymbolElement* thisObject = jsCast<JSSVGSymbolElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGSymbolElement, Base>(exec, &JSSVGSymbolElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGSymbolElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGSymbolElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGSymbolElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSymbolElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSymbolElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGSymbolElementViewBox(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    RefPtr<SVGAnimatedRect> obj = impl->viewBoxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSymbolElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = impl->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGSymbolElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGSymbolElement* domObject = jsCast<JSSVGSymbolElement*>(asObject(slotBase));
    return JSSVGSymbolElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGSymbolElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGSymbolElement* thisObject = jsCast<JSSVGSymbolElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGSymbolElement, Base>(exec, propertyName, value, &JSSVGSymbolElementTable, thisObject, slot);
}

void setJSSVGSymbolElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(thisObject);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGSymbolElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(thisObject);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGSymbolElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGSymbolElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGSymbolElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGSymbolElement::s_info))
        return throwVMTypeError(exec);
    JSSVGSymbolElement* castedThis = jsCast<JSSVGSymbolElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGSymbolElement::s_info);
    SVGSymbolElement* impl = static_cast<SVGSymbolElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
