/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyboardEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "KeyboardEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSKeyboardEventTableValues[] =
{
    { "keyIdentifier", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyIdentifier), (intptr_t)0, NoIntrinsic },
    { "keyLocation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyLocation), (intptr_t)0, NoIntrinsic },
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCtrlKey), (intptr_t)0, NoIntrinsic },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventShiftKey), (intptr_t)0, NoIntrinsic },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltKey), (intptr_t)0, NoIntrinsic },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventMetaKey), (intptr_t)0, NoIntrinsic },
    { "altGraphKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltGraphKey), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventTable = { 18, 15, JSKeyboardEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSKeyboardEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventConstructorTable = { 1, 0, JSKeyboardEventConstructorTableValues, 0 };
const ClassInfo JSKeyboardEventConstructor::s_info = { "KeyboardEventConstructor", &Base::s_info, &JSKeyboardEventConstructorTable, 0, CREATE_METHOD_TABLE(JSKeyboardEventConstructor) };

JSKeyboardEventConstructor::JSKeyboardEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSKeyboardEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSKeyboardEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSKeyboardEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSKeyboardEventConstructor, JSDOMWrapper>(exec, &JSKeyboardEventConstructorTable, jsCast<JSKeyboardEventConstructor*>(cell), propertyName, slot);
}

bool JSKeyboardEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSKeyboardEventConstructor, JSDOMWrapper>(exec, &JSKeyboardEventConstructorTable, jsCast<JSKeyboardEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSKeyboardEventPrototypeTableValues[] =
{
    { "initKeyboardEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsKeyboardEventPrototypeFunctionInitKeyboardEvent), (intptr_t)11, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventPrototypeTable = { 2, 1, JSKeyboardEventPrototypeTableValues, 0 };
const ClassInfo JSKeyboardEventPrototype::s_info = { "KeyboardEventPrototype", &Base::s_info, &JSKeyboardEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSKeyboardEventPrototype) };

JSObject* JSKeyboardEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSKeyboardEvent>(exec, globalObject);
}

bool JSKeyboardEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSKeyboardEventPrototype* thisObject = jsCast<JSKeyboardEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSKeyboardEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSKeyboardEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSKeyboardEventPrototype* thisObject = jsCast<JSKeyboardEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSKeyboardEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSKeyboardEvent::s_info = { "KeyboardEvent", &Base::s_info, &JSKeyboardEventTable, 0 , CREATE_METHOD_TABLE(JSKeyboardEvent) };

JSKeyboardEvent::JSKeyboardEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<KeyboardEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSKeyboardEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSKeyboardEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSKeyboardEventPrototype::create(exec->globalData(), globalObject, JSKeyboardEventPrototype::createStructure(exec->globalData(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSKeyboardEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSKeyboardEvent* thisObject = jsCast<JSKeyboardEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSKeyboardEvent, Base>(exec, &JSKeyboardEventTable, thisObject, propertyName, slot);
}

bool JSKeyboardEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSKeyboardEvent* thisObject = jsCast<JSKeyboardEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSKeyboardEvent, Base>(exec, &JSKeyboardEventTable, thisObject, propertyName, descriptor);
}

JSValue jsKeyboardEventKeyIdentifier(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keyIdentifier());
    return result;
}


JSValue jsKeyboardEventKeyLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->keyLocation());
    return result;
}


JSValue jsKeyboardEventCtrlKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ctrlKey());
    return result;
}


JSValue jsKeyboardEventShiftKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->shiftKey());
    return result;
}


JSValue jsKeyboardEventAltKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altKey());
    return result;
}


JSValue jsKeyboardEventMetaKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->metaKey());
    return result;
}


JSValue jsKeyboardEventAltGraphKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altGraphKey());
    return result;
}


JSValue jsKeyboardEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* domObject = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    return JSKeyboardEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSKeyboardEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyboardEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSKeyboardEvent::s_info))
        return throwVMTypeError(exec);
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSKeyboardEvent::s_info);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    const String& type(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& keyIdentifier(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned keyLocation(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altGraphKey(MAYBE_MISSING_PARAMETER(exec, 10, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initKeyboardEvent(type, canBubble, cancelable, view, keyIdentifier, keyLocation, ctrlKey, altKey, shiftKey, metaKey, altGraphKey);
    return JSValue::encode(jsUndefined());
}


}
