/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFormControlsCollection.h"

#include "HTMLFormControlsCollection.h"
#include "JSNode.h"
#include "Node.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLFormControlsCollectionTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLFormControlsCollectionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFormControlsCollectionTable = { 2, 1, JSHTMLFormControlsCollectionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLFormControlsCollectionConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFormControlsCollectionConstructorTable = { 1, 0, JSHTMLFormControlsCollectionConstructorTableValues, 0 };
const ClassInfo JSHTMLFormControlsCollectionConstructor::s_info = { "HTMLFormControlsCollectionConstructor", &Base::s_info, &JSHTMLFormControlsCollectionConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLFormControlsCollectionConstructor) };

JSHTMLFormControlsCollectionConstructor::JSHTMLFormControlsCollectionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLFormControlsCollectionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLFormControlsCollectionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLFormControlsCollectionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFormControlsCollectionConstructor, JSDOMWrapper>(exec, &JSHTMLFormControlsCollectionConstructorTable, jsCast<JSHTMLFormControlsCollectionConstructor*>(cell), propertyName, slot);
}

bool JSHTMLFormControlsCollectionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFormControlsCollectionConstructor, JSDOMWrapper>(exec, &JSHTMLFormControlsCollectionConstructorTable, jsCast<JSHTMLFormControlsCollectionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFormControlsCollectionPrototypeTableValues[] =
{
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLFormControlsCollectionPrototypeFunctionNamedItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLFormControlsCollectionPrototypeTable = { 2, 1, JSHTMLFormControlsCollectionPrototypeTableValues, 0 };
const ClassInfo JSHTMLFormControlsCollectionPrototype::s_info = { "HTMLFormControlsCollectionPrototype", &Base::s_info, &JSHTMLFormControlsCollectionPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLFormControlsCollectionPrototype) };

JSObject* JSHTMLFormControlsCollectionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFormControlsCollection>(exec, globalObject);
}

bool JSHTMLFormControlsCollectionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFormControlsCollectionPrototype* thisObject = jsCast<JSHTMLFormControlsCollectionPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLFormControlsCollectionPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLFormControlsCollectionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFormControlsCollectionPrototype* thisObject = jsCast<JSHTMLFormControlsCollectionPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLFormControlsCollectionPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLFormControlsCollection::s_info = { "HTMLFormControlsCollection", &Base::s_info, &JSHTMLFormControlsCollectionTable, 0 , CREATE_METHOD_TABLE(JSHTMLFormControlsCollection) };

JSHTMLFormControlsCollection::JSHTMLFormControlsCollection(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFormControlsCollection> impl)
    : JSHTMLCollection(structure, globalObject, impl)
{
}

void JSHTMLFormControlsCollection::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLFormControlsCollection::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLFormControlsCollectionPrototype::create(exec->globalData(), globalObject, JSHTMLFormControlsCollectionPrototype::createStructure(exec->globalData(), globalObject, JSHTMLCollectionPrototype::self(exec, globalObject)));
}

bool JSHTMLFormControlsCollection::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLFormControlsCollection* thisObject = jsCast<JSHTMLFormControlsCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSHTMLFormControlsCollection>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLFormControlsCollection*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<HTMLFormControlsCollection*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLFormControlsCollection, Base>(exec, &JSHTMLFormControlsCollectionTable, thisObject, propertyName, slot);
}

bool JSHTMLFormControlsCollection::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLFormControlsCollection* thisObject = jsCast<JSHTMLFormControlsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = JSHTMLFormControlsCollectionTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLFormControlsCollection*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<HTMLFormControlsCollection*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLFormControlsCollection, Base>(exec, &JSHTMLFormControlsCollectionTable, thisObject, propertyName, descriptor);
}

bool JSHTMLFormControlsCollection::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLFormControlsCollection* thisObject = jsCast<JSHTMLFormControlsCollection*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<HTMLFormControlsCollection*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<HTMLFormControlsCollection*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLFormControlsCollectionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLFormControlsCollection* domObject = jsCast<JSHTMLFormControlsCollection*>(asObject(slotBase));
    return JSHTMLFormControlsCollection::getConstructor(exec, domObject->globalObject());
}

void JSHTMLFormControlsCollection::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSHTMLFormControlsCollection* thisObject = jsCast<JSHTMLFormControlsCollection*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<HTMLFormControlsCollection*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSHTMLFormControlsCollection::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFormControlsCollectionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLFormControlsCollectionPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLFormControlsCollection::s_info))
        return throwVMTypeError(exec);
    JSHTMLFormControlsCollection* castedThis = jsCast<JSHTMLFormControlsCollection*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLFormControlsCollection::s_info);
    return JSValue::encode(castedThis->namedItem(exec));
}


JSValue JSHTMLFormControlsCollection::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSHTMLFormControlsCollection* thisObj = jsCast<JSHTMLFormControlsCollection*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<HTMLFormControlsCollection*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSHTMLFormControlsCollection* jsHTMLFormControlsCollection)
{
    if (jsHTMLFormControlsCollection->hasCustomProperties())
        return true;
    return false;
}

bool JSHTMLFormControlsCollectionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSHTMLFormControlsCollection* jsHTMLFormControlsCollection = jsCast<JSHTMLFormControlsCollection*>(handle.get().asCell());
    if (!isObservable(jsHTMLFormControlsCollection))
        return false;
    void* root = WebCore::root(jsHTMLFormControlsCollection->impl()->base());
    return visitor.containsOpaqueRoot(root);
}

void JSHTMLFormControlsCollectionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSHTMLFormControlsCollection* jsHTMLFormControlsCollection = jsCast<JSHTMLFormControlsCollection*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLFormControlsCollection->impl(), jsHTMLFormControlsCollection);
    jsHTMLFormControlsCollection->releaseImpl();
}


}
