/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLElement.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(MICRODATA)
#include "DOMSettableTokenList.h"
#include "JSDOMSettableTokenList.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLElementTableValues[] =
{
    { "id", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementId), (intptr_t)setJSHTMLElementId, NoIntrinsic },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTitle), (intptr_t)setJSHTMLElementTitle, NoIntrinsic },
    { "lang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementLang), (intptr_t)setJSHTMLElementLang, NoIntrinsic },
    { "translate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTranslate), (intptr_t)setJSHTMLElementTranslate, NoIntrinsic },
    { "dir", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDir), (intptr_t)setJSHTMLElementDir, NoIntrinsic },
    { "tabIndex", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementTabIndex), (intptr_t)setJSHTMLElementTabIndex, NoIntrinsic },
    { "draggable", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementDraggable), (intptr_t)setJSHTMLElementDraggable, NoIntrinsic },
    { "webkitdropzone", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementWebkitdropzone), (intptr_t)setJSHTMLElementWebkitdropzone, NoIntrinsic },
    { "hidden", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementHidden), (intptr_t)setJSHTMLElementHidden, NoIntrinsic },
    { "accessKey", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementAccessKey), (intptr_t)setJSHTMLElementAccessKey, NoIntrinsic },
    { "innerHTML", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerHTML), (intptr_t)setJSHTMLElementInnerHTML, NoIntrinsic },
    { "innerText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementInnerText), (intptr_t)setJSHTMLElementInnerText, NoIntrinsic },
    { "outerHTML", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterHTML), (intptr_t)setJSHTMLElementOuterHTML, NoIntrinsic },
    { "outerText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementOuterText), (intptr_t)setJSHTMLElementOuterText, NoIntrinsic },
    { "children", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementChildren), (intptr_t)0, NoIntrinsic },
    { "contentEditable", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementContentEditable), (intptr_t)setJSHTMLElementContentEditable, NoIntrinsic },
    { "isContentEditable", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementIsContentEditable), (intptr_t)0, NoIntrinsic },
    { "spellcheck", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementSpellcheck), (intptr_t)setJSHTMLElementSpellcheck, NoIntrinsic },
#if ENABLE(MICRODATA)
    { "itemScope", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemScope), (intptr_t)setJSHTMLElementItemScope, NoIntrinsic },
#endif
#if ENABLE(MICRODATA)
    { "itemType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemType), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(MICRODATA)
    { "itemId", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemId), (intptr_t)setJSHTMLElementItemId, NoIntrinsic },
#endif
#if ENABLE(MICRODATA)
    { "itemRef", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemRef), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(MICRODATA)
    { "itemProp", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemProp), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(MICRODATA)
    { "itemValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementItemValue), (intptr_t)setJSHTMLElementItemValue, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLElementTable = { 70, 63, JSHTMLElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLElementConstructorTable = { 1, 0, JSHTMLElementConstructorTableValues, 0 };
const ClassInfo JSHTMLElementConstructor::s_info = { "HTMLElementConstructor", &Base::s_info, &JSHTMLElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLElementConstructor) };

JSHTMLElementConstructor::JSHTMLElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLElementConstructor, JSDOMWrapper>(exec, &JSHTMLElementConstructorTable, jsCast<JSHTMLElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLElementConstructor, JSDOMWrapper>(exec, &JSHTMLElementConstructorTable, jsCast<JSHTMLElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLElementPrototypeTableValues[] =
{
    { "insertAdjacentElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentElement), (intptr_t)2, NoIntrinsic },
    { "insertAdjacentHTML", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentHTML), (intptr_t)2, NoIntrinsic },
    { "insertAdjacentText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionInsertAdjacentText), (intptr_t)2, NoIntrinsic },
    { "click", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLElementPrototypeFunctionClick), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLElementPrototypeTable = { 8, 7, JSHTMLElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLElementPrototype::s_info = { "HTMLElementPrototype", &Base::s_info, &JSHTMLElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLElementPrototype) };

JSObject* JSHTMLElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLElement>(exec, globalObject);
}

bool JSHTMLElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLElementPrototype* thisObject = jsCast<JSHTMLElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLElementPrototype* thisObject = jsCast<JSHTMLElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLElement::s_info = { "HTMLElement", &Base::s_info, &JSHTMLElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLElement) };

JSHTMLElement::JSHTMLElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLElement> impl)
    : JSElement(structure, globalObject, impl)
{
}

void JSHTMLElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLElementPrototype::create(exec->globalData(), globalObject, JSHTMLElementPrototype::createStructure(exec->globalData(), globalObject, JSElementPrototype::self(exec, globalObject)));
}

bool JSHTMLElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLElement* thisObject = jsCast<JSHTMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLElement, Base>(exec, &JSHTMLElementTable, thisObject, propertyName, slot);
}

bool JSHTMLElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLElement* thisObject = jsCast<JSHTMLElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLElement, Base>(exec, &JSHTMLElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLElementId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::idAttr));
    return result;
}


JSValue jsHTMLElementTitle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::titleAttr));
    return result;
}


JSValue jsHTMLElementLang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::langAttr));
    return result;
}


JSValue jsHTMLElementTranslate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->translate());
    return result;
}


JSValue jsHTMLElementDir(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::dirAttr));
    return result;
}


JSValue jsHTMLElementTabIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->tabIndex());
    return result;
}


JSValue jsHTMLElementDraggable(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->draggable());
    return result;
}


JSValue jsHTMLElementWebkitdropzone(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::webkitdropzoneAttr));
    return result;
}


JSValue jsHTMLElementHidden(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::hiddenAttr));
    return result;
}


JSValue jsHTMLElementAccessKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::accesskeyAttr));
    return result;
}


JSValue jsHTMLElementInnerHTML(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->innerHTML());
    return result;
}


JSValue jsHTMLElementInnerText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->innerText());
    return result;
}


JSValue jsHTMLElementOuterHTML(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->outerHTML());
    return result;
}


JSValue jsHTMLElementOuterText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->outerText());
    return result;
}


JSValue jsHTMLElementChildren(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->children()));
    return result;
}


JSValue jsHTMLElementContentEditable(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->contentEditable());
    return result;
}


JSValue jsHTMLElementIsContentEditable(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->isContentEditable());
    return result;
}


JSValue jsHTMLElementSpellcheck(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->spellcheck());
    return result;
}


#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemScope(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::itemscopeAttr));
    return result;
}

#endif

#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->itemType()));
    return result;
}

#endif

#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::itemidAttr));
    return result;
}

#endif

#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemRef(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->itemRef()));
    return result;
}

#endif

#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemProp(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->itemProp()));
    return result;
}

#endif

#if ENABLE(MICRODATA)
JSValue jsHTMLElementItemValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(slotBase));
    return castedThis->itemValue(exec);
}

#endif

JSValue jsHTMLElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLElement* domObject = jsCast<JSHTMLElement*>(asObject(slotBase));
    return JSHTMLElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLElement* thisObject = jsCast<JSHTMLElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLElement, Base>(exec, propertyName, value, &JSHTMLElementTable, thisObject, slot);
}

void setJSHTMLElementId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::idAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::titleAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementLang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::langAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementTranslate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setTranslate(value.toBoolean(exec));
}


void setJSHTMLElementDir(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::dirAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementTabIndex(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setTabIndex(value.toInt32(exec));
}


void setJSHTMLElementDraggable(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setDraggable(value.toBoolean(exec));
}


void setJSHTMLElementWebkitdropzone(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::webkitdropzoneAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementHidden(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::hiddenAttr, value.toBoolean(exec));
}


void setJSHTMLElementAccessKey(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::accesskeyAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLElementInnerHTML(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setInnerHTML(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLElementInnerText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setInnerText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLElementOuterHTML(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setOuterHTML(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLElementOuterText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setOuterText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLElementContentEditable(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setContentEditable(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLElementSpellcheck(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setSpellcheck(value.toBoolean(exec));
}


#if ENABLE(MICRODATA)
void setJSHTMLElementItemScope(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::itemscopeAttr, value.toBoolean(exec));
}

#endif

#if ENABLE(MICRODATA)
void setJSHTMLElementItemId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(thisObject);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::itemidAttr, valueToStringWithNullCheck(exec, value));
}

#endif

#if ENABLE(MICRODATA)
void setJSHTMLElementItemValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLElement*>(thisObject)->setItemValue(exec, value);
}

#endif

JSValue JSHTMLElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLElement::s_info);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& where(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertAdjacentElement(where, element, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentHTML(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLElement::s_info);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& where(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& html(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertAdjacentHTML(where, html, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionInsertAdjacentText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLElement::s_info);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& where(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& text(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertAdjacentText(where, text, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLElementPrototypeFunctionClick(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLElement* castedThis = jsCast<JSHTMLElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLElement::s_info);
    HTMLElement* impl = static_cast<HTMLElement*>(castedThis->impl());
    impl->click();
    return JSValue::encode(jsUndefined());
}

HTMLElement* toHTMLElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLElement::s_info) ? jsCast<JSHTMLElement*>(asObject(value))->impl() : 0;
}

}
